FUNCTION nrbmakeplane, ll=ll,ww=ww

IF n_elements(ll) EQ 0 THEN ll=10d
IF n_elements(ww) EQ 0 THEN ww=3d

ll=double(ll)
ww=double(ww)
n=6
x=nrblinear(-1.,1.,n)
y=nrblinear(-1.,1.,n)
z=dblarr(n,n)

coefs=nrbconvsurf(xx=x,yy=y,zz=z)

knots=nrbgetknots(coefs)

scale=vecscale([ww/2D,ll/2D,0.])
plane=nrbstruct(coefs,knots.uknots,knots.vknots)
plane=nrbtransform(plane,scale)

return, plane

END
