; 
;===============================================================================
;
Pro xshoe_f_grating,oestr,GROUP=group,ACTION=action

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_F_GRATING: Error caught: '+$
	!err_string,/error)
   return
endif

if n_elements(oestr) EQ 0 then oestr=read_gfile('exafin.exa')


titles_holog = ['"left"  distance (cm)',$
  '"left" incidence angle',$
  '"left" azimuth from +Y [deg] [CCW]',$
  '"right" distance (cm)',$
  '"right"  incidence angle',$
  '"right"  azimuth from +Y [deg] [CCW]',$
  'Pattern type',$
  'Source type',$
  'Cylindrical source',$
  'Recording wavelength [Angs.]' ]
flags_holog = replicate('1',n_elements(titles_holog))

HOLOG = {HOLO_R1:oestr.HOLO_R1,$
  HOLO_DEL:oestr.HOLO_DEL,$
  HOLO_RT1:oestr.HOLO_RT1,$
  HOLO_R2:oestr.HOLO_R2,$
  HOLO_GAM:oestr.HOLO_GAM,$
  HOLO_RT2:oestr.HOLO_RT2,$
  F_PW:[strcompress(oestr.F_PW,/rem),'Spherical/Spherical','Plane/Spherical',$
	'Spherical/Plane','Plane/Plane']  ,$
  F_VIRTUAL:[strcompress(oestr.F_VIRTUAL,/rem),'Real/Real','Real/Virtual',$
      'Virtual/Real','Virtual/Virtual'], $
  F_PW_C:[strcompress(oestr.F_PW_C,/rem),'Spherical/Spherical',$
     'Cylindrical/Spherical','Spherical/Cylindrical',$
     'Cylindrical/Cylindrical'],$
  HOLO_W:oestr.HOLO_W, $
  FLAGS:flags_holog,$
  TITLES:titles_holog,$
  wtitle:'Define hologram',$
  NOTYPE:1,$
  INTERPRET:1}

titles_hunter = ['Blaze angle [deg]',$
  'Grating selected',$
  'Monochromator length',$
  'Distance between beams']
flags_hunter = replicate('1',n_elements(titles_hunter))

HUNTER = { BLAZE:oestr.BLAZE,$
   F_HUNT:[strcompress(oestr.F_HUNT-1,/Rem),'First','Second'],$
   HUNT_L:oestr.HUNT_L,$
   HUNT_H:oestr.HUNT_H,$
   FLAGS:flags_hunter, $
   TITLES:titles_hunter, $
   WTITLE:'Define Hunter Monochromator',$
   NOTYPE:1, $
   INTERPRET:1 }

titles= [ 'Ruling type',$
  'HOLOG pars...',$
  'Grooves Pole distance',$
  'Grooves Pole azimuth',$
  'Coma correction factor',$
  'Lines/CM (at origin)',$
  'Poly. line density coeff: linear',$
  'Poly. line density coeff: quadratic',$
  'Poly. line density coeff: third power',$
  'Poly. line density coeff: fourth power',$
  'Signed/Absolute',$
  'Auto tuning',$
  'Diffraction order',$
  'Energy/wavelength',$
  'Energy [Angs]',$
  'Energy [eV]',$
  'Mount type',$
  'HUNTER pars...']
flags = ['1', $   ; Ruling typ
   'w(0) EQ 2',$  ; HOLOG structure
   'w(0) EQ 3',$   ;
   'w(0) EQ 3',$   ;
   'w(0) EQ 3',$   ;
   'w(0) NE 2 AND w(0) NE 4',$   ; Lines/CM (at origin) 
   'w(0) EQ 5',$   ; Polyn coeff
   'w(0) EQ 5',$   ; Polyn coeff
   'w(0) EQ 5',$   ; Polyn coeff
   'w(0) EQ 5',$   ; Polyn coeff
   'w(0) EQ 5',$   ; Signed/Absolute
   '1',$   ; 11: Autotunning
   '1',$   ; Diffraction order
   'w(11) EQ 1',$   ; 13: Energy/wavelength
   'w(11) EQ 1 AND w(13) EQ 1',$   ;
   'w(11) EQ 1 AND w(13) EQ 0',$   ;
   '1',$   ; 16: Mount type 
   'w(16) EQ 4' ]   ;
tmp =    { F_RULING:[strcompress(oestr.F_RULING,/Rem),'Constant','Uniform',$
	'Holog','FanType','Reserved','Polynom'],$
  HOLOG:HOLOG, $
  DIST_FAN:oestr.DIST_FAN,$ 
  AZIM_FAN:oestr.AZIM_FAN,$ 
  COMA_FAC:oestr.COMA_FAC,$ 
  RULING:oestr.RULING,$ 
  RUL_A1:oestr.RUL_A1,$ 
  RUL_A2:oestr.RUL_A2,$ 
  RUL_A3:oestr.RUL_A3,$ 
  RUL_A4:oestr.RUL_A4,$ 
  F_RUL_ABS:[strcompress(oestr.F_RUL_ABS,/Rem),'Absolute','Signed'],$
  F_CENTRAL:[strcompress(oestr.F_CENTRAL,/Rem),'No','Yes'],$
  ORDER:oestr.ORDER,$ 
  F_PHOT_CENT:[strcompress(oestr.F_PHOT_CENT,/Rem),'eV','Anstroms'],$
  R_LAMBDA:oestr.R_LAMBDA,$ 
  PHOT_CENT:oestr.PHOT_CENT,$ 
  F_MONO:[strcompress(oestr.F_MONO,/Rem),'TGM/Seya','ERG',$
	'Const Inc Angle','Const diff angle','Hunter'],$
  HUNTER:HUNTER }

action=0
XWMenu,tmp,/NOTYPE,/INTERPRET,wtitle='Define grating',$
  FLAGS=flags,TITLES=titles,ACTION=action,GROUP=group,NCOL=3
if action eq 'DONT' then return

;
; copy variables of MAIN window
;
oestr.F_RULING = fix(tmp.F_RULING(0))
oestr.DIST_FAN = tmp.DIST_FAN
oestr.AZIM_FAN = tmp.AZIM_FAN
oestr.COMA_FAC = tmp.COMA_FAC
oestr.RULING = tmp.RULING
oestr.RUL_A1 = tmp.RUL_A1
oestr.RUL_A2 = tmp.RUL_A2
oestr.RUL_A3 = tmp.RUL_A3
oestr.RUL_A4 = tmp.RUL_A4
oestr.F_RUL_ABS = fix(tmp.F_RUL_ABS(0))
oestr.F_CENTRAL = fix(tmp.F_CENTRAL(0))
oestr.ORDER = tmp.ORDER
oestr.F_PHOT_CENT = fix(tmp.F_PHOT_CENT(0))
oestr.R_LAMBDA = tmp.R_LAMBDA
oestr.PHOT_CENT = tmp.PHOT_CENT
oestr.F_MONO = fix(tmp.F_MONO(0))
;
; copy variables of HOLOG window
;
oestr.HOLO_R1 = tmp.holog.HOLO_R1
oestr.HOLO_DEL = tmp.holog.HOLO_DEL
oestr.HOLO_RT1 = tmp.holog.HOLO_RT1
oestr.HOLO_R2 = tmp.holog.HOLO_R2
oestr.HOLO_GAM = tmp.holog.HOLO_GAM
oestr.HOLO_RT2 = tmp.holog.HOLO_RT2
oestr.F_PW = fix(tmp.holog.F_PW(0)) 
oestr.F_VIRTUAL = fix(tmp.holog.F_VIRTUAL(0))
oestr.F_PW_C = fix(tmp.holog.F_PW_C(0))
oestr.HOLO_W = tmp.holog.HOLO_W
;
; copy variables of HUNTER window
;
oestr.BLAZE = tmp.hunter.BLAZE
oestr.F_HUNT = 1+fix(tmp.hunter.F_HUNT(0))
oestr.HUNT_L = tmp.hunter.HUNT_L
oestr.HUNT_H = tmp.hunter.HUNT_H

return
end

