PRO XSh_Source_UpdatePanels,wids,ptrStr,Group=group, Map=map

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /Cancel
   Message,/Info,'Error caught: '+!err_string
   itmp = Dialog_Message('XSH_SOURCE_UPDATEPANELS: Error caught: '+$
	!err_string,/Error, Dialog_Parent=group)
   RETURN
ENDIF

str = *ptrStr

IF Tag_Exist(wids,'NPOINT') THEN $
  Widget_Control,wids.NPOINT,Set_Value=str.NPOINT
IF Tag_Exist(wids,'ISTAR1') THEN $
  Widget_Control,wids.ISTAR1,Set_Value=str.ISTAR1
IF Tag_Exist(wids,'FGRID') THEN $
  Widget_Control,wids.FGRID,Set_Value=str.FGRID
IF Tag_Exist(wids,'F_OPD') THEN $
  Widget_Control,wids.F_OPD,Set_Value=str.F_OPD


;
; Geometrical source ****************************************************
;
IF Tag_Exist(wids,'FSOUR') THEN $
  Widget_Control,wids.FSOUR,Set_Value=str.FSOUR
IF Tag_Exist(wids,'PreFDISTR') THEN $
  Widget_Control,wids.PreFDISTR,Set_Value=str.FDISTR-1
IF Tag_Exist(wids,'PreFSOURCE_DEPTH') THEN $
  Widget_Control,wids.PreFSOURCE_DEPTH,Set_Value=str.FSOURCE_DEPTH-1

;Widget_Control,wids.F_PHOT,Set_Value=str.F_PHOT
IF Tag_Exist(wids,'PreF_COLOR') THEN $
  Widget_Control,wids.PreF_COLOR,Set_Value=str.F_COLOR-1


IF Tag_Exist(wids,'F_POLAR') THEN $
  Widget_Control,wids.F_POLAR,Set_Value=str.F_POLAR

;
; Bending Magnet sources *************************************************
;
IF Tag_Exist(wids,'PH1') THEN $
  Widget_Control,wids.PH1,Set_Value=str.PH1
IF Tag_Exist(wids,'PH2') THEN $
  Widget_Control,wids.PH2,Set_Value=str.PH2

IF Tag_Exist(wids,'SIGMAX') THEN $
  Widget_Control,wids.SIGMAX,Set_Value=str.SIGMAX
IF Tag_Exist(wids,'SIGMAZ') THEN $
  Widget_Control,wids.SIGMAZ,Set_Value=str.SIGMAZ

IF Tag_Exist(wids,'EPSI_X') THEN $
  Widget_Control,wids.EPSI_X,Set_Value=str.EPSI_X
IF Tag_Exist(wids,'EPSI_Z') THEN $
  Widget_Control,wids.EPSI_Z,Set_Value=str.EPSI_Z

IF Tag_Exist(wids,'BENER') THEN $
  Widget_Control,wids.BENER,Set_Value=str.BENER

IF Tag_Exist(wids,'HDIV1') THEN $
  Widget_Control,wids.HDIV1,Set_Value=str.HDIV1
IF Tag_Exist(wids,'HDIV2') THEN $
  Widget_Control,wids.HDIV2,Set_Value=str.HDIV2

IF Tag_Exist(wids,'VDIV1') THEN $
  Widget_Control,wids.VDIV1,Set_Value=str.VDIV1
IF Tag_Exist(wids,'VDIV2') THEN $
  Widget_Control,wids.VDIV2,Set_Value=str.VDIV2

IF Tag_Exist(wids,'Pre1R_MAGNET') THEN $
  Widget_Control,wids.Pre1R_MAGNET,Set_Value=str.R_MAGNET
IF Tag_Exist(wids,'Pre2R_MAGNET') THEN BEGIN
  bener = 0
  Widget_Control,wids.BENER,Get_Value=bener
  bFieldMax = 3.334728*bener/str.R_MAGNET
  Widget_Control,wids.Pre2R_MAGNET,Set_Value=bFieldMax
ENDIF

IF Tag_Exist(wids,'Pre2FDISTR') THEN BEGIN
  CASE str.FDISTR OF
    4: Widget_Control,wids.Pre2FDISTR,Set_Value='0'
    6: Widget_Control,wids.Pre2FDISTR,Set_Value='1'
    else: BEGIN
	itmp = Dialog_Message(Dialog_Parent=group, $
	  ['FDIST = '+StrCompress(str.FDISTR), $
	   'This value is not valid for Bending magnet sources.',$
	   'Setting FDISTR=6 (exact SR calculation).']) 
	Widget_Control,wids.Pre2FDISTR,Set_Value='1'
	str.FDISTR=6
	END
  ENDCASE
ENDIF

IF Tag_Exist(wids,'PreF_POL') THEN $
  Widget_Control,wids.PreF_POL,Set_Value=str.F_POL-1
IF Tag_Exist(wids,'F_SR_TYPE') THEN $
  Widget_Control,wids.F_SR_TYPE,Set_Value=str.F_SR_TYPE
IF Tag_Exist(wids,'EPSI_DX') THEN $
  Widget_Control,wids.EPSI_DX,Set_Value=str.EPSI_DX
IF Tag_Exist(wids,'EPSI_DZ') THEN $
  Widget_Control,wids.EPSI_DZ,Set_Value=str.EPSI_DZ


;
;
;

IF Keyword_Set(map) THEN XSh_Source_MapPanels,wids,Group=group

END
