;+
; NAME:
;       OPEN_optical_system.
;
; PURPOSE:
;       This procedure call the procedure adapted to open the file
;
; CATEGORY:
;       BLViewer
;
; CALLING SEQUENCE:
;       OPEN_optical_system, pInfo, file
;
; INPUTS:
;       pInfo:  A pointer on the blviewer uValue.
;		File: the name of a Sytemfile created by XOP (*.dat) or 
;		by BLViewer(*.blv)
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:;
;		OPEN_optical_system, pInfo, file
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-
pro blv_open_optical_system, pInfo, file, end_file=end_file

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_open_optical_system: error caught: '+!error_state.msg)
   RETURN
ENDIF


if n_elements(end_file) eq 0 then end_file=0

widget_control, /HOURGLASS
widget_control, (*pInfo).wid.statut, set_value='Reading...'
if file eq '' then begin
	widget_control, (*pInfo).wid.statut, set_value='Ready.'
	return
endif

; get the type files
fileB=byte(file)
s=size(fileB)
n=s[1]
p=n-1

bb = (byte('.'))[0]
while (fileB[p] ne bb) and (p gt 0) do begin
	p=p-1
endwhile
if p eq 0 then return
exten=string(fileB[p:n-1])

case exten of
	'.dat': blv_open_optical_system_dat, pInfo, file, end_file=end_file
	'.blv': blv_open_optical_system_blv, pInfo, file
	else: begin
		message,'Not a good file extension: '+exten
		return
	end
endcase
if (*pInfo).wid.wModule ne (*pInfo).wid.tbl then begin
	widget_control,(*pInfo).wid.wModule, get_uvalue=info
	widget_control, (*info.pInfoModule).wNbModule, set_value=string((*pInfo).data.system->count())
	widget_control, (*info.pInfoModule).wSelectedModule, set_value=(*pInfo).data.position+1
	blv_change_selected_module, pInfo
endif
end
