;
;+
;
;==============================  XShWig   ==================================
;
; XShWig is a widget based graphical interface for calculating the 
; wiggler source with SHADOW.
;
;
; COPYRIGHT:
;	XSHWig  belongs to SHADOWVUI package and it is distributed 
;	as an XOP extension.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;	http://www.esrf.fr/computing/scientific/xop/
;
; CREDITS:
;
;	Published calculations made with SHADOW and SHADOWVUI should refer:
;
;	F. Cerrina and M. Sanchez del Rio
;	"Ray tracing of X-ray optical systems"
;       Handbook of Optics (Volume V):
;       Atmospheric Optics, Modulators, Fiber Optics, X-Ray and Neutron Optics
;	Chapter 35 (pags 35.1-35.6) (2009)
;       ISBN: 0071633138 / 9780071633130
;       http://www.mhprofessional.com/handbookofoptics/vol5.php
;	
;	M. Sanchez del Rio and R. J. Dejus  
;       "Status of XOP: an x-ray optics software toolkit" 
;       SPIE Proceedings Vol. 5536 (2004) pp.171-174
;	http://dx.doi.org/10.1117/12.560903
;
; LAST MODIFICATION: msr/msr/2012-05-29
;
;-
;
; -----------------------------------------------------------------------
;	Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF
;	98/03/18 rewritten by srio@esrf.fr from an original from C.
;		Michetschlaeger.
;	00/05/30 srio@esrf.fr adds Only_Run keyword 
;	00/07/10 srio@esrf.fr documented.
;       2012/05/29 srio@esrf.eu added "reject rays" option.
;
;
;========================================================================
;

PRO xshwig_update,inp,wids

Widget_Control,wids.npoint, Set_Value=strcompress(inp.npoint,/Rem)
Widget_Control,wids.istar1, Set_Value=strcompress(inp.istar1,/Rem)
Widget_Control,wids.sigmax, Set_Value=strcompress(inp.sigmax,/Rem)
Widget_Control,wids.sigmaz, Set_Value=strcompress(inp.sigmaz,/Rem)
Widget_Control,wids.epsi_x, Set_Value=strcompress(inp.epsi_x,/Rem)
Widget_Control,wids.epsi_z, Set_Value=strcompress(inp.epsi_z,/Rem)
Widget_Control,wids.bener, Set_Value=strcompress(inp.bener,/Rem)
Widget_Control,wids.ph1, Set_Value=strcompress(inp.ph1,/Rem)
Widget_Control,wids.ph2, Set_Value=strcompress(inp.ph2,/Rem)

Widget_Control,wids.periods, Set_Value=strcompress(inp.periods,/Rem)
Widget_Control,wids.wavlen, Set_Value=strcompress(inp.wavlen,/Rem)
Widget_Control,wids.k, Set_Value=strcompress(inp.k,/Rem)
Widget_Control,wids.f_bound_sour, Set_Value=strcompress(inp.f_bound_sour,/Rem)

end
;		
;========================================================================
;

PRO xshwig_updatestr,inp,wids

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHWIG_UPDATESTR: Error caught: '+$
	!err_string,/error)
   return
endif

tmp = 0

Widget_Control,wids.npoint, Get_Value=tmp
inp.npoint = float(tmp(0))

Widget_Control,wids.istar1, Get_Value=tmp
inp.istar1 = long(tmp(0))

Widget_Control,wids.sigmax, Get_Value=tmp
inp.sigmax = float(tmp(0))

Widget_Control,wids.sigmaz, Get_Value=tmp
inp.sigmaz = float(tmp(0))

Widget_Control,wids.epsi_x, Get_Value=tmp
inp.epsi_x = float(tmp(0))

Widget_Control,wids.epsi_z, Get_Value=tmp
inp.epsi_z = float(tmp(0))

Widget_Control,wids.bener, Get_Value=tmp
inp.bener = float(tmp(0))

Widget_Control,wids.ph1, Get_Value=tmp
inp.ph1 = float(tmp(0))

Widget_Control,wids.ph2, Get_Value=tmp
inp.ph2 = float(tmp(0))

Widget_Control,wids.periods, Get_Value=tmp
inp.periods = fix(tmp(0))

Widget_Control,wids.wavlen, Get_Value=tmp
inp.wavlen = float(tmp(0))

Widget_Control,wids.k, Get_Value=tmp
inp.k = float(tmp(0))

Widget_Control,wids.f_bound_sour, Get_Value=tmp
inp.f_bound_sour = fix(tmp[0])


end
;		
;========================================================================
;


Pro xshwig_write_inp,inp

common shadow3,shadow3_mode, shadow3_binary

; 
; epath
;
IF shadow3_mode EQ 0 THEN  BEGIN
  file='xsh_epath_tmp.inp'
  Openw,lun,file,/Get_Lun
ENDIF ELSE BEGIN
  file='shadow3.inp'
  Openw,lun,file,/Get_Lun
  Printf,lun,'epath'
ENDELSE

Printf,lun,'1' ; Type of Insertion Device.for wiggler   (large K) [ 1 ]
Printf,lun,strcompress(inp.periods,/Rem)
Printf,lun,'1' ; for normal wiggler     [1]
Printf,lun,strcompress(inp.wavlen,/Rem)
Printf,lun,strcompress(inp.k,/Rem)
Printf,lun,strcompress(inp.bener,/Rem)
Printf,lun,'101' ; number of points to be used in the trajectory calculation
                 ; ( max = 1001, suggested 101 )
Printf,lun,'1.0' ; End correction field factor (0-1)
Printf,lun,'xshwig.par'
Printf,lun,'xshwig.traj'


IF shadow3_mode EQ 0 THEN free_lun,lun

; 
; nphoton
;
IF shadow3_mode EQ 0 THEN  BEGIN
  file='xsh_nphoton_tmp.inp'
  Openw,lun,file,/Get_Lun
ENDIF ELSE BEGIN
  Printf,lun,'nphoton'
ENDELSE

Printf,lun,'xshwig.traj'
Printf,lun,'1' ; for normal wiggler   [1]
Printf,lun,strcompress(inp.ph1,/Rem)
Printf,lun,strcompress(inp.ph2,/Rem)
Printf,lun,'xshwig.sha'

IF shadow3_mode EQ 0 THEN free_lun,lun

; 
; input_source
;
IF shadow3_mode EQ 0 THEN  BEGIN
  file='xsh_input_source_tmp.inp'
  Openw,lun,file,/Get_Lun
ENDIF ELSE BEGIN
  Printf,lun,'input_source'
ENDELSE

Printf,lun,'1' ; 
Printf,lun,'0' ; Source modelling type [ 0-5 ] ?
Printf,lun,strcompress(inp.npoint,/Rem)
Printf,lun,strcompress(inp.istar1,/Rem)
Printf,lun,strcompress(inp.f_bound_sour,/remove_all) ; Do you want to optimize the source ?
case inp.f_bound_sour of
  0:
  1: BEGIN
     Printf,lun,strcompress(inp.file_bound,/remove_all) 
     END
  2: BEGIN
     file = strcompress(inp.file_bound,/remove_all) 
     openw,unit,file,/get_lun
     printf,unit,inp.slit_distance, inp.slit_xmin, inp.slit_xmax, $
                                      inp.slit_zmin, inp.slit_zmax
     free_lun,unit
     Printf,lun,strcompress(inp.file_bound,/remove_all) 
     END
  else:
endcase
Printf,lun,'1' ; Source type : [ 1 ] normal wiggler
Printf,lun,'xshwig.sha'
Printf,lun,'100' ; Conversion factor from meters to user units ? 
Printf,lun,'1' ; Horizontal half-divergence [ (+)x, rads ] ? 
Printf,lun,'1' ; Horizontal half-divergence [ (-)x, rads ] ? 
Printf,lun,'1' ;  Vertical                   [ (+)z, rads ] ?
Printf,lun,'1' ;  Vertical                   [ (-)z, rads ] ?
Printf,lun,strcompress(inp.sigmax,/Rem)
Printf,lun,strcompress(inp.sigmaz,/Rem)
Printf,lun,strcompress(inp.epsi_x,/Rem)
Printf,lun,'0' ; Distance of insertion device's center from X waist [ signed ] ?
Printf,lun,strcompress(inp.epsi_z,/Rem)
Printf,lun,'0' ; Distance of insertion device's center from Z waist [ signed ] ?
Printf,lun,'3' ;  Polarization Selected [ 1-3 ] ? total 3
Printf,lun,'1' ; Do you want to store the optical paths (OPD) [Y/N] ?
Printf,lun,'1' ; Do you want to generate the A vectors (electric field) [Y/N] ?

IF shadow3_mode NE 0 THEN BEGIN
  Printf,lun,'source'
  Printf,lun,'systemfile'
  Printf,lun,'exit'
ENDIF

free_lun,lun
end
;		
;========================================================================
;
Pro xshwig_event,event

common shadow3, shadow3_mode, shadow3_binary

CATCH, error_status
IF error_status NE 0 THEN BEGIN
   Message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,$
        'XSHWIG: error caught: '+!err_string)
   Catch, /Cancel
   RETURN
ENDIF


Widget_Control,event.id,get_uvalue=uval

infoId = Widget_Info(event.handler,/Child)
Widget_Control, infoId, get_UValue=info 

case uval of
  'F_BOUND_SOUR': BEGIN
	Widget_Control,info.wids.F_BOUND_SOUR,Get_Value=index
	info.inp.F_BOUND_SOUR = index
	CASE index OF
	  '0': BEGIN ; No
		END
	  '1': BEGIN ; histo3 file with phase-space volume
		titles = ['File with phase-space volume:']
		wTitle='Optimize source using phase-space volume'
		flags = ['1']
		tmp=info.inp.FILE_BOUND
		data={ file_bound:tmp }
		XScrMenu,data,Titles=titles,/NoType,WTitle=wtitle, $
		  Action=action, Dialog_Parent=event.top, /Interpret, $
		  NCol=1, Flags=flags
		IF action EQ 'DONT' THEN Return
		info.inp.FILE_BOUND=data.FILE_BOUND
                Widget_Control, infoId, set_UValue=info 
		END
	  '2': BEGIN ; slit/acceptance file
		titles = ["Slit distance [cm] (set 0 for angular acceptance)",$
                          "min x [cm] ( or min x' if distance=0)", $
                          "max x [cm] ( or max x' if distance=0)", $
                          "min z [cm] ( or min z' if distance=0)", $
                          "max z [cm] ( or max z' if distance=0)" ]

		wTitle='Optimize source using slit/acceptance'
		flags = replicate('1',5)
		tmp=info.inp.FILE_BOUND
		data={ slit_distance:info.inp.slit_distance, $
		       slit_xmin:info.inp.slit_xmin, $
		       slit_xmax:info.inp.slit_xmax, $
		       slit_zmin:info.inp.slit_zmin, $
		       slit_zmax:info.inp.slit_zmax  }
		XScrMenu,data,Titles=titles,/NoType,WTitle=wtitle, $
		  Action=action, Dialog_Parent=event.top, /Interpret, $
		  NCol=1, Flags=flags
		IF action EQ 'DONT' THEN Return
		info.inp.slit_distance=data.slit_distance
		info.inp.slit_xmin=data.slit_xmin
		info.inp.slit_xmax=data.slit_xmax
		info.inp.slit_zmin=data.slit_zmin
		info.inp.slit_zmax=data.slit_zmax
		info.inp.FILE_BOUND='xsh_slit_tmp.dat'
                Widget_Control, infoId, set_UValue=info 
		END
	ENDCASE 

        END
  'Run Shadow/source': BEGIN
	Widget_Control,Widget_info(event.handler,/Child),Get_UValue=state
	tmp = state.inp
	xshwig_updatestr,tmp,state.wids

	xshwig_write_inp,tmp
	Widget_Control,/HourGlass
	;xsh_run,"epath < xsh_epath_tmp.inp"
	;xsh_run,"nphoton < xsh_nphoton_tmp.inp"
	;xsh_run,"input_source < xsh_input_source_tmp.inp"
	;xsh_run,"gen_source start.00"
     
        CASE shadow3_mode OF
          0: BEGIN
	      xsh_run,["epath < xsh_epath_tmp.inp",$
	         "nphoton < xsh_nphoton_tmp.inp",$
	         "input_source < xsh_input_source_tmp.inp",$
	         "gen_source start.00"]
             END
          else: BEGIN
              XSh_Run,shadow3_binary+" < shadow3.inp"
                END
        ENDCASE
	; command = 'rm xsh_epath_tmp.inp xsh_input_source_tmp.inp '+$
	;		'xsh_nphoton_tmp.inp'
	; message,/info,'Executing: '+command
	; spawn,command
	END
  'Close': BEGIN
	Widget_Control,Widget_info(event.handler,/Child),Get_UValue=state
	tmp = state.inp
	xshwig_updatestr,tmp,state.wids
	if Ptr_Valid(state.input) then *(state.input) = tmp
	Widget_Control,event.top,/Destroy
	END
  'Discard changes': BEGIN
	Widget_Control,event.top,/Destroy
	END
   else: ; message,/info,'Case not found: '+val
endcase

end
;		
;========================================================================
;
PRO xshwig,input,Group=group, Only_Run=only_run

common shadow3, shadow3_mode, shadow3_binary

if xregistered('XSHWIG') then begin
  itmp = Dialog_Message(Dialog_Parent=group,/Question,/Default_No,$
    ['SHADOW VUI has detected an open window for Wiggler Source',$
     'Do you want another one?'])
  if itmp EQ 'No' then return
endif
if n_params() EQ 1 then begin
  inp = *input
  no_block=1
endif else begin
  inp = xsh_defaults('XSHWIG')
  input = 0
  no_block=0
endelse

IF Keyword_Set(only_Run) THEN BEGIN
  xshwig_write_inp,inp
  Widget_Control,/HourGlass
        CASE shadow3_mode OF
          0:    BEGIN
                xsh_run,["epath < xsh_epath_tmp.inp",$
                  "nphoton < xsh_nphoton_tmp.inp",$
                  "input_source < xsh_input_source_tmp.inp",$
                  "gen_source start.00"]
                END
          else: BEGIN
                XSh_Run,shadow3_binary+" < shadow3.inp"
                END
        ENDCASE
  RETURN
ENDIF

base1=Widget_Base(Column=1,Title='Wiggler Parameters')

butbase=Widget_Base(base1,Row=1)

;wtmp=Widget_Button(butbase,Value='Accept')
wtmp=Widget_Button(butbase,Value='Close',UValue='Close')
;wtmp=Widget_Button(butbase,Value='Cancel')
wtmp=Widget_Button(butbase,Value='Discard changes',UValue='Discard changes')
wtmp=Widget_Button(butbase,Value='Run Shadow/source',UValue='Run Shadow/source')

para=Widget_Base(base1,Column=1,Frame=1)

labeler=Widget_Label(para,Value='Machine Parameters')
subpara=Widget_Base(para,Row=1)
wsigmax=CW_Field(subpara,XSize=12,Value='0.0',Title='Sigma X [cm]', /Floating)
wsigmaz=CW_Field(subpara,XSize=12,Value='0.0',Title='Sigma Z [cm]', /Floating)

subbie=Widget_Base(para,Row=1)
wepsi_x=CW_Field(subbie,XSize=12,Value='0.0',Title='Emittance X [rad.cm]',$
	/Floating)
wepsi_z=CW_Field(subbie,XSize=12,Value='0.0',Title='Emittance Z [rad.cm]',$
	/Floating)

ener=Widget_Base(para,Row=1)
wbener=CW_Field(ener,XSize=12,Value='0.0',Title='Energy [GeV]',/Floating)

wigpara=Widget_Base(base1,Column=1,Frame=1)
labler=Widget_Label(wigpara,Value='Wiggler Parameters')
wav_k_base=Widget_Base(wigpara,Row=1)
wwavlen=CW_Field(wav_k_base,XSize=12,Value='0.0',Title='ID wavelength [m]:',$
	/Floating)
wk=CW_Field(wav_k_base,XSize=12,Value='0.0',Title='K Value:',/Floating)

periodbase=Widget_Base(wigpara,Row=1)
wperiods=CW_Field(periodbase,XSize=12,Value='0.0',Title='Number of periods:',$
	/Long)

calcpara=Widget_Base(base1,Column=1,Frame=1)
laberer=Widget_Label(calcpara,Value='Calculation Parameters')
numer=Widget_Base(calcpara,Row=1)
wnpoint=CW_Field(numer,XSize=12,Value='00',Title='Number of Rays:',/Long)
wistar1=CW_Field(numer,XSize=12,Value='0.0',Title='Seed: (integer, 0=clock)',$
	/Long)

miner=Widget_Base(calcpara,Row=1)
wph1=CW_Field(miner,XSize=12,Value='0.0',Title='Emin [eV]',/Floating)
wph2=CW_Field(miner,XSize=12,Value='0.0',Title='Emax [eV]',/Floating)

list = ['0','No','Using file with phase-space volume...','Using slit/acceptance...']
wF_BOUND_SOUR = CW_DropList(calcpara,Value=list,  $
      Title='Optimize source (reject rays):',UValue='F_BOUND_SOUR')



Widget_Control,base1,/Realize
wids = {npoint:wnpoint, istar1:wistar1, sigmax:wsigmax, sigmaz:wsigmaz, $
 epsi_x:wepsi_x, epsi_z:wepsi_z, bener:wbener, ph1:wph1, ph2:wph2, $
 periods:wperiods, k:wk, wavlen:wwavlen, f_bound_sour:wf_bound_sour }

state = {wids:wids, inp:inp, input:input }

xshwig_update,inp,wids

Widget_Control,Widget_Info(base1,/Child),Set_UValue=state; ,/No_copy
XManager,'XSHWIG',base1,no_block=no_block, group=group

END

