; 
;===============================================================================
;
Pro xshoe_f_refrac,oestr,GROUP=group,ACTION=action

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_F_REFRAC: Error caught: '+$
	!err_string,/error)
   return
endif

if n_elements(oestr) EQ 0 then oestr=read_gfile('exafin.exa')

titles=[ 'refractive index in object medium',$
         'attenuation in object medium [cm^-1]', $
         'refractive index in image medium',$
         'attenuation in image medium [cm^-1]',$
         'Fresnel Zone Plate']

flags = replicate('1',n_elements(titles))
 
tmp =    { R_IND_OBJ:oestr.R_IND_OBJ, $
   R_ATTENUATION_OBJ:oestr.R_ATTENUATION_OBJ, $
   R_IND_IMA:oestr.R_IND_IMA, $
   R_ATTENUATION_IMA:oestr.R_ATTENUATION_IMA, $
   FZP:[strcompress(oestr.FZP,/rem),'No','Yes'] }

action=0
XScrMenu,tmp,/NOTYPE,/INTERPRET,wtitle='Refractive Index',$
  FLAGS=flags,TITLES=titles,ACTION=action,GROUP=group,NCOL=2

if action eq 'DONT' then return

oestr.R_IND_OBJ = tmp.R_IND_OBJ
oestr.R_IND_IMA = tmp.R_IND_IMA

oestr.R_ATTENUATION_OBJ = tmp.R_ATTENUATION_OBJ
oestr.R_ATTENUATION_IMA = tmp.R_ATTENUATION_IMA

oestr.FZP = fix(tmp.FZP(0))

;help,oestr.FZP
;print,oestr.FZP

return
end

