;+
; NAME:
;       NO_SHOW_ELEMENT.
;
; PURPOSE:
;       This procedure set the property of an optical_module to show 
;		it as a not selected module.
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;       NO_SHOW_ELEMENT, pInfo
;
; INPUTS:
; 		pInfo: A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;		none
;
; EXAMPLE:;
;       SHOW_ELEMENT, pInfo
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-

;********no_show_element*****************
pro blv_no_show_element, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_no_show_element: error caught: '+!error_state.msg)
   RETURN
ENDIF


if (*pinfo).data.position eq -1 then return
module=(*pInfo).data.system->get_module(pos=(*pinfo).data.position)
module->setProperty, selected=0
module->trace
end
;***************************************
