function read_blv_format, file, Group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'read_blv_format: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


system=obj_new('optical_system')

g_data=read_gfile(file)

for p=0, g_data.nb_module-1 do begin
	;to delete blank caractere in string field
	; print, 'Reading Module ',p+1
	temp=byte(g_data.type_name[p])
	e=0
	bb = (byte(' '))[0]
	while(temp[e] eq bb) do e=e+1
	g_data.type_name[p]=string(temp[e:*])

	temp=byte(g_data.file_name[p])
	e=0
	while(temp[e] eq bb) do e=e+1
	g_data.file_name[p]=string(temp[e:*])

    dim={t_source:g_data.t_source[p], t_image:g_data.t_image[p], $
            t_incidence:g_data.t_incidence[p], t_reflection:g_data.t_reflection[p], alpha:g_data.alpha[p], $
			rlen1:g_data.rlen1[p], rlen2:g_data.rlen2[p], rwidx1:g_data.rwidx1[p], rwidx2:g_data.rwidx2[p], prof:g_data.prof[p], $
			file_name:g_data.file_name[p], type_name:g_data.type_name[p], $
			color:[g_data.color_R[p],g_data.color_G[p],g_data.color_B[p]], mesh_file:g_data.mesh_file[p]}
			print, dim.mesh_file
   	optic=blv_create_optical_module(dim)
 	system->add_module, optic
endfor
source=system->get_source()
source->setProperty, mesh_file=g_data.mesh_file_source
if g_data.mesh_file_source ne 'undefined' and g_data.mesh_file_source ne '' then begin
	mesh=read_vrml_file(g_data.mesh_file_source)
	source->setProperty, symbol=mesh
endif

return, system
end
