
;
;+
;
;==============================  XShWig   ==================================
;
; XShWig is a widget based graphical interface for calculating the 
; wiggler source with SHADOW.
;
;
; COPYRIGHT:
;	XSHWig  belongs to SHADOWVUI package and it is distributed 
;	as an XOP extension.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;	http://www.esrf.fr/computing/scientific/xop/
;
; CREDITS:
;	Published calculations made with SHADOW and SHADOWVUI should refer:
;
;	C. Welnak, G.J. Chen and F. Cerrina "SHADOW: a synchrotron
;	radiation X-ray optics simulation tool", Nucl. Instr. and Meth. A347
;	(1994) 344-347 
;	
;	M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	SPIE proceedings vol. 3448, pp.340-345, 1998.
;
; LAST MODIFICATION: msr/msr/00-07-10
;
;-
;
; -----------------------------------------------------------------------
;	Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF
;	98/03/18 rewritten by srio@esrf.fr from an original from C.
;		Michetschlaeger.
;	00/05/30 srio@esrf.fr adds Only_Run keyword 
;	00/07/10 srio@esrf.fr documented.
;
;
;========================================================================
;

PRO xshwig_update,inp,wids

Widget_Control,wids.npoint, Set_Value=strcompress(inp.npoint,/Rem)
Widget_Control,wids.istar1, Set_Value=strcompress(inp.istar1,/Rem)
Widget_Control,wids.sigmax, Set_Value=strcompress(inp.sigmax,/Rem)
Widget_Control,wids.sigmaz, Set_Value=strcompress(inp.sigmaz,/Rem)
Widget_Control,wids.epsi_x, Set_Value=strcompress(inp.epsi_x,/Rem)
Widget_Control,wids.epsi_z, Set_Value=strcompress(inp.epsi_z,/Rem)
Widget_Control,wids.bener, Set_Value=strcompress(inp.bener,/Rem)
Widget_Control,wids.ph1, Set_Value=strcompress(inp.ph1,/Rem)
Widget_Control,wids.ph2, Set_Value=strcompress(inp.ph2,/Rem)

Widget_Control,wids.periods, Set_Value=strcompress(inp.periods,/Rem)
Widget_Control,wids.wavlen, Set_Value=strcompress(inp.wavlen,/Rem)
Widget_Control,wids.k, Set_Value=strcompress(inp.k,/Rem)

end
;		
;========================================================================
;

PRO xshwig_updatestr,inp,wids

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHWIG_UPDATESTR: Error caught: '+$
	!err_string,/error)
   return
endif

tmp = 0

Widget_Control,wids.npoint, Get_Value=tmp
inp.npoint = float(tmp(0))

Widget_Control,wids.istar1, Get_Value=tmp
inp.istar1 = long(tmp(0))

Widget_Control,wids.sigmax, Get_Value=tmp
inp.sigmax = float(tmp(0))

Widget_Control,wids.sigmaz, Get_Value=tmp
inp.sigmaz = float(tmp(0))

Widget_Control,wids.epsi_x, Get_Value=tmp
inp.epsi_x = float(tmp(0))

Widget_Control,wids.epsi_z, Get_Value=tmp
inp.epsi_z = float(tmp(0))

Widget_Control,wids.bener, Get_Value=tmp
inp.bener = float(tmp(0))

Widget_Control,wids.ph1, Get_Value=tmp
inp.ph1 = float(tmp(0))

Widget_Control,wids.ph2, Get_Value=tmp
inp.ph2 = float(tmp(0))

Widget_Control,wids.periods, Get_Value=tmp
inp.periods = fix(tmp(0))

Widget_Control,wids.wavlen, Get_Value=tmp
inp.wavlen = float(tmp(0))

Widget_Control,wids.k, Get_Value=tmp
inp.k = float(tmp(0))

end
;		
;========================================================================
;


Pro xshwig_write_inp,inp

common shadow3,shadow3_mode, shadow3_binary

; 
; epath
;
IF shadow3_mode EQ 0 THEN  BEGIN
  file='xsh_epath_tmp.inp'
  Openw,lun,file,/Get_Lun
ENDIF ELSE BEGIN
  file='shadow3.inp'
  Openw,lun,file,/Get_Lun
  Printf,lun,'epath'
ENDELSE

Printf,lun,'1' ; Type of Insertion Device.for wiggler   (large K) [ 1 ]
Printf,lun,strcompress(inp.periods,/Rem)
Printf,lun,'1' ; for normal wiggler     [1]
Printf,lun,strcompress(inp.wavlen,/Rem)
Printf,lun,strcompress(inp.k,/Rem)
Printf,lun,strcompress(inp.bener,/Rem)
Printf,lun,'101' ; number of points to be used in the trajectory calculation
                 ; ( max = 1001, suggested 101 )
Printf,lun,'1.0' ; End correction field factor (0-1)
Printf,lun,'xshwig.par'
Printf,lun,'xshwig.traj'


IF shadow3_mode EQ 0 THEN free_lun,lun

; 
; nphoton
;
IF shadow3_mode EQ 0 THEN  BEGIN
  file='xsh_nphoton_tmp.inp'
  Openw,lun,file,/Get_Lun
ENDIF ELSE BEGIN
  Printf,lun,'nphoton'
ENDELSE

Printf,lun,'xshwig.traj'
Printf,lun,'1' ; for normal wiggler   [1]
Printf,lun,strcompress(inp.ph1,/Rem)
Printf,lun,strcompress(inp.ph2,/Rem)
Printf,lun,'xshwig.sha'

IF shadow3_mode EQ 0 THEN free_lun,lun

; 
; input_source
;
IF shadow3_mode EQ 0 THEN  BEGIN
  file='xsh_input_source_tmp.inp'
  Openw,lun,file,/Get_Lun
ENDIF ELSE BEGIN
  Printf,lun,'input_source'
ENDELSE

Printf,lun,'1' ; 
Printf,lun,'0' ; Source modelling type [ 0-5 ] ?
Printf,lun,strcompress(inp.npoint,/Rem)
Printf,lun,strcompress(inp.istar1,/Rem)
Printf,lun,'0' ; Do you want to optimize the source ?
Printf,lun,'1' ; Source type : [ 1 ] normal wiggler
Printf,lun,'xshwig.sha'
Printf,lun,'100' ; Conversion factor from meters to user units ? 
Printf,lun,'1' ; Horizontal half-divergence [ (+)x, rads ] ? 
Printf,lun,'1' ; Horizontal half-divergence [ (-)x, rads ] ? 
Printf,lun,'1' ;  Vertical                   [ (+)z, rads ] ?
Printf,lun,'1' ;  Vertical                   [ (-)z, rads ] ?
Printf,lun,strcompress(inp.sigmax,/Rem)
Printf,lun,strcompress(inp.sigmaz,/Rem)
Printf,lun,strcompress(inp.epsi_x,/Rem)
Printf,lun,'0' ; Distance of insertion device's center from X waist [ signed ] ?
Printf,lun,strcompress(inp.epsi_z,/Rem)
Printf,lun,'0' ; Distance of insertion device's center from Z waist [ signed ] ?
Printf,lun,'3' ;  Polarization Selected [ 1-3 ] ? total 3
Printf,lun,'1' ; Do you want to store the optical paths (OPD) [Y/N] ?
Printf,lun,'1' ; Do you want to generate the A vectors (electric field) [Y/N] ?

IF shadow3_mode NE 0 THEN BEGIN
  Printf,lun,'source'
  Printf,lun,'systemfile'
  Printf,lun,'exit'
ENDIF

free_lun,lun
end
;		
;========================================================================
;
Pro xshwig_event,event

common shadow3, shadow3_mode, shadow3_binary

if tag_names(event,/Structure_Name) NE 'WIDGET_BUTTON' then return
Widget_Control,event.id,get_value=val
case val of
  'Run Shadow/source': BEGIN
	Widget_Control,Widget_info(event.handler,/Child),Get_UValue=state
	tmp = state.inp
	xshwig_updatestr,tmp,state.wids

	xshwig_write_inp,tmp
	Widget_Control,/HourGlass
	;xsh_run,"epath < xsh_epath_tmp.inp"
	;xsh_run,"nphoton < xsh_nphoton_tmp.inp"
	;xsh_run,"input_source < xsh_input_source_tmp.inp"
	;xsh_run,"gen_source start.00"
     
        CASE shadow3_mode OF
          0: BEGIN
	      xsh_run,["epath < xsh_epath_tmp.inp",$
	         "nphoton < xsh_nphoton_tmp.inp",$
	         "input_source < xsh_input_source_tmp.inp",$
	         "gen_source start.00"]
             END
          else: BEGIN
              XSh_Run,shadow3_binary+" < shadow3.inp"
                END
        ENDCASE
	; command = 'rm xsh_epath_tmp.inp xsh_input_source_tmp.inp '+$
	;		'xsh_nphoton_tmp.inp'
	; message,/info,'Executing: '+command
	; spawn,command
	END
  'Close': BEGIN
	Widget_Control,Widget_info(event.handler,/Child),Get_UValue=state
	tmp = state.inp
	xshwig_updatestr,tmp,state.wids
	if Ptr_Valid(state.input) then *(state.input) = tmp
	Widget_Control,event.top,/Destroy
	END
  'Discard changes': BEGIN
	Widget_Control,event.top,/Destroy
	END
   else:message,/info,'Case not found: '+val
endcase

end
;		
;========================================================================
;
PRO xshwig,input,Group=group, Only_Run=only_run

common shadow3, shadow3_mode, shadow3_binary

if xregistered('XSHWIG') then begin
  itmp = Dialog_Message(Dialog_Parent=group,/Question,/Default_No,$
    ['SHADOW VUI has detected an open window for Wiggler Source',$
     'Do you want another one?'])
  if itmp EQ 'No' then return
endif
if n_params() EQ 1 then begin
  inp = *input
  no_block=1
endif else begin
  inp = xsh_defaults('XSHWIG')
  input = 0
  no_block=0
endelse

IF Keyword_Set(only_Run) THEN BEGIN
  xshwig_write_inp,inp
  Widget_Control,/HourGlass
        CASE shadow3_mode OF
          0:    BEGIN
                xsh_run,["epath < xsh_epath_tmp.inp",$
                  "nphoton < xsh_nphoton_tmp.inp",$
                  "input_source < xsh_input_source_tmp.inp",$
                  "gen_source start.00"]
                END
          else: BEGIN
                XSh_Run,shadow3_binary+" < shadow3.inp"
                END
        ENDCASE
  RETURN
ENDIF

base1=Widget_Base(Column=1,Title='Wiggler Parameters')

butbase=Widget_Base(base1,Row=1)

;wtmp=Widget_Button(butbase,Value='Accept')
wtmp=Widget_Button(butbase,Value='Close')
;wtmp=Widget_Button(butbase,Value='Cancel')
wtmp=Widget_Button(butbase,Value='Discard changes')
wtmp=Widget_Button(butbase,Value='Run Shadow/source')

para=Widget_Base(base1,Column=1,Frame=1)

labeler=Widget_Label(para,Value='Machine Parameters')
subpara=Widget_Base(para,Row=1)
wsigmax=CW_Field(subpara,XSize=12,Value='0.0',Title='Sigma X [cm]', /Floating)
wsigmaz=CW_Field(subpara,XSize=12,Value='0.0',Title='Sigma Z [cm]', /Floating)

subbie=Widget_Base(para,Row=1)
wepsi_x=CW_Field(subbie,XSize=12,Value='0.0',Title='Emittance X [rad.cm]',$
	/Floating)
wepsi_z=CW_Field(subbie,XSize=12,Value='0.0',Title='Emittance Z [rad.cm]',$
	/Floating)

ener=Widget_Base(para,Row=1)
wbener=CW_Field(ener,XSize=12,Value='0.0',Title='Energy [GeV]',/Floating)

wigpara=Widget_Base(base1,Column=1,Frame=1)
labler=Widget_Label(wigpara,Value='Wiggler Parameters')
wav_k_base=Widget_Base(wigpara,Row=1)
wwavlen=CW_Field(wav_k_base,XSize=12,Value='0.0',Title='ID wavelength [m]:',$
	/Floating)
wk=CW_Field(wav_k_base,XSize=12,Value='0.0',Title='K Value:',/Floating)

periodbase=Widget_Base(wigpara,Row=1)
wperiods=CW_Field(periodbase,XSize=12,Value='0.0',Title='Number of periods:',$
	/Long)

calcpara=Widget_Base(base1,Column=1,Frame=1)
laberer=Widget_Label(calcpara,Value='Calculation Parameters')
numer=Widget_Base(calcpara,Row=1)
wnpoint=CW_Field(numer,XSize=12,Value='00',Title='Number of Rays:',/Long)
wistar1=CW_Field(numer,XSize=12,Value='0.0',Title='Seed: [odd, 100-1 000 000]',$
	/Long)

miner=Widget_Base(calcpara,Row=1)
wph1=CW_Field(miner,XSize=12,Value='0.0',Title='Emin [eV]',/Floating)
wph2=CW_Field(miner,XSize=12,Value='0.0',Title='Emax [eV]',/Floating)


Widget_Control,base1,/Realize
wids = {npoint:wnpoint, istar1:wistar1, sigmax:wsigmax, sigmaz:wsigmaz, $
 epsi_x:wepsi_x, epsi_z:wepsi_z, bener:wbener, ph1:wph1, ph2:wph2, $
 periods:wperiods, k:wk, wavlen:wwavlen }

state = {wids:wids, inp:inp, input:input }

xshwig_update,inp,wids

Widget_Control,Widget_Info(base1,/Child),Set_UValue=state,/No_copy
XManager,'XSHWIG',base1,no_block=no_block, group=group

END

