;+
;
; PRO xsh_summary,txt,group=group,notext=notext
;
; makes a summary of distances, focusing conditions, deflection, etc
; Takes input from systemfile.dat and end.xx files. 
;
; srio@esrf.fr 16-02-2006
; srio@esrf.fr 16-09-2009 added src-oe distance, chech for F_EXT
; 
;-

PRO xsh_summary,txt,group=group,notext=notext

txt=''
; Get number of oe
a=read_textfile('systemfile.dat')
IF a[0] EQ '' THEN BEGIN
    itmp = Dialog_Message(/Error, Dialog_Parent=group, $
      ['Error getting info from systemfile.dat data.',$
       'It looks like you did not run SHADOW/trace'])
    RETURN
ENDIF
n = N_Elements(a)

tot=0.0
alphatot=0.0
deflection_H = 0.0
deflection_V = 0.0
pihalf = !pi/2

txt = [txt,'  ********  SUMMARY OF DISTANCES ********']
txt=[txt,' ']
txt=[txt, '   ** DISTANCES FOR ALL O.E. [cm] **           ']
line=String(['OE','TYPE','p[cm]','q[cm]','src-oe','src-screen'],Format='(6A12)')
txt=[txt, line]

txt1 = ''
txt2 = ''

FOR i=0,n-1 DO BEGIN

  ; get data
  IF i LE 8 THEN sh1 = read_gfile('end.0'+StrCompress(i+1,/Rem)) ELSE $
                   sh1 = read_gfile('end.'+StrCompress(i+1,/Rem)) 
  IF type(sh1) NE 8 THEN BEGIN
    itmp = Dialog_Message(/Error, 'Error getting info from element: '+$
	StrCompress(i+1) )
    RETURN
  ENDIF

  ; 1) Distances summary
  oetype='UNKNOWN'
  IF sh1.F_REFRAC EQ 1 THEN oetype='REFRACTOR' ELSE oetype='MIRROR'
  IF sh1.F_CRYSTAL EQ 1 THEN oetype='CRYSTAL'
  IF sh1.F_GRATING EQ 1 THEN oetype='GRATING'

  tot = tot + sh1.T_SOURCE + sh1.T_IMAGE
  totoe = tot - sh1.T_IMAGE
  line=String(i+1,oetype,sh1.T_SOURCE,sh1.T_IMAGE,totoe,tot,Format='(I12,A12,4F12.2)')
  txt1=[txt1,line]

  ; 2) focusing summary

  IF sh1.FMIRR NE 5 AND sh1.FMIRR NE 9 THEN BEGIN
     CASE sh1.FMIRR OF 
       1:IF sh1.FCYL EQ 0 THEN oeshape='SPHERE' ELSE oeshape='CYLINDER'
       2:IF sh1.FCYL EQ 0 THEN oeshape='ELLIPSOID' ELSE oeshape='ELLIPSE'
       3:oeshape='TOROID'
       4:IF sh1.FCYL EQ 0 THEN oeshape='PARABOLID' ELSE oeshape='PARABOLA'
       6:oeshape='CODLING SLIT'
       7:IF sh1.FCYL EQ 0 THEN oeshape='HYPERBOLOID' ELSE oeshape='HYPERBOLA'
       8:oeshape='CONE'
       9:oeshape='POLYNOMIAL'
       else:
     ENDCASE
     IF sh1.F_DEFAULT EQ 1 THEN BEGIN
       pp = sh1.T_SOURCE
       qq = sh1.T_IMAGE
     ENDIF ELSE BEGIN
       pp = sh1.SSOUR
       qq = sh1.SIMAG
     ENDELSE

     IF sh1.F_EXT EQ 1 THEN BEGIN
        line=String(i+1,oeshape,'?','?','?',Format='(I10,A10,3A10)')
     ENDIF ELSE BEGIN
        line=String(i+1,oeshape,pp,qq,pp/qq,Format='(I10,A10,3F10.2)')
     ENDELSE

     txt2=[txt2,line]
  ENDIF

  ; 3) total deflection 

  alphatot=alphatot+sh1.alpha

  deflection_H = deflection_H +  sin(alphatot) *  $
    ( (pihalf-sh1.t_incidence) + (pihalf-sh1.t_reflection) )
  deflection_V = deflection_V +  cos(alphatot) *  $
    ( (pihalf-sh1.t_incidence) + (pihalf-sh1.t_reflection) )

ENDFOR

txt=[txt,txt1]
txt=[txt,' ']
txt=[txt, '   ** FOCUSING ELEMENTS **           ']
; focusing elements
line=String(Format='(5A10)','OE','SHAPE','p_foc','q_foc','1/M')
txt=[txt, line, txt2]


txt=[txt,' ']
line=String('Sum of Alphas Mod 180 deg',alphatot*!radeg MOD 180)
txt=[txt,line]
line=String('Sum of Alphas Mod 360 deg',alphatot*!radeg MOD 360)
txt=[txt,line]

txt=[txt,' ']
line=String('Total deflection angle H =',deflection_H,' rad = ', $
                                  deflection_H*!radeg,' deg', $
	Format='(A,F12.6,A,F9.3,A)')
txt=[txt,line]
line=String('Total deflection angle V =',deflection_V,' rad = ', $
                                  deflection_V*!radeg,' deg', $
	Format='(A,F12.6,A,F9.3,A)')
txt=[txt,line]


IF not(keyword_set(noText)) THEN $
XDisplayFile1,Text=txt,Title='Distances summary',height=36



END ; xsh_summary

