PRO xsh_run_presurface,fileroot,filedat=filedat,filesha=filesha,group=group, $
    noInfo=noInfo

;+
;
;       NAME:
;               XSH_RUN_PRESURFACE
;       PURPOSE:
;               This function runs the "presurface" SHADOW's utility
;               to create a spline binary file (usually *.sha) from
;               the SHADOW mesh surface (usually *.dat)
;       CATEGORY:
;               SHADOW tools
;       CALLING SEQUENCE:
;               xsh_run_presurface,fileroot
;
; 	INPUTS:
;		fileroot: the file root. Example 'tmp' for considering
;                         tmp.dat as input surface and tmp.sha as
;                         binary output. Default: presurface
;	
; 	KEYWORD PARAMETERS
;		fileDat: the full name of the file with surface
;                        (default: fileroot+'.dat')
;		fileSha: the full name of the file with binary output
;                        (default: fileroot+'.sha')
;               noInfo: Set this keywords to avoid the dialog 
;                       informing on the created file (for loops)
;               group: The Id of the parent widget (for centering dialogs)
;
;       PROCEDURE:
;               Creates temporary file presurface_tmp.inp and calls xsh_run
;
;	AUTHOR: 
;		M. Sanchez del Rio srio@esrf.eu
;	
;	MODIFICATION HISTORY:
;		2009-12-16 srio@esrf.eu written.
;
;-

common shadow3,shadow3_mode, shadow3_binary

on_error,2

IF N_Elements(fileroot) EQ 0 THEN BEGIN
  IF N_Elements(filedat) NE 0 THEN BEGIN
        fileroot=strmid(filedat,0,strpos(filedat,'.'))
  ENDIF ELSE BEGIN
        fileroot='presurface'
  ENDELSE
ENDIF

IF N_Elements(filedat) EQ 0 THEN filedat=fileroot+'.dat'
IF N_Elements(filesha) EQ 0 THEN filesha=fileroot+'.sha'

	; delete .sha
	openw,unit,filesha,/delete,/get_lun
	free_lun,unit
	
	
	; create new file
     IF shadow3_mode EQ 0 THEN BEGIN
	CASE SDep() OF
	'UNIX': BEGIN
	  command = "printf '"+filedat+" \n"+filesha+"\n' | presurface"
	  xsh_run,command
	  END
	'WINDOWS': BEGIN
	  OpenW,unit,'presurface_tmp.inp',/Get_Lun
	  PrintF,unit,filedat
	  PrintF,unit,filesha
	  Free_Lun,unit
	  xsh_run,'presurface < presurface_tmp.inp'
	  END
	 ELSE: itmp = Dialog_Message(/Error,'OS not implemented: '+SDep(),$
		Dialog_Parent=event.top)
	ENDCASE
     ENDIF ELSE BEGIN
	  OpenW,unit,'shadow3.inp',/Get_Lun
	  PrintF,unit,'presurface'
	  PrintF,unit,filedat
	  PrintF,unit,filesha
	  PrintF,unit,'exit'
	  Free_Lun,unit
	  xsh_run,shadow3_binary+' < shadow3.inp'
     ENDELSE

	IF checkfile(filesha) NE 1 THEN  BEGIN
	  itmp = Dialog_Message(/Error,Dialog_Parent=group, $
		'XSH_RUN_PRESURFACE: Problem creating file '+filesha)
	ENDIF ELSE BEGIN
	  IF not(keyword_set(noInfo)) THEN $
                itmp = Dialog_Message(/Info,Dialog_Parent=group, $
		'XSH_RUN_PRESURFACE: File (binary) written to disk: '+filesha)
	ENDELSE

        ; delate temporary file

	IF shadow3_mode EQ 0 THEN BEGIN
	  openw,unit,'presurface_tmp.inp',/delete,/get_lun
	  free_lun,unit
	ENDIF
	
END
