pro xsh_run,command,bg=bg,logfile=logfile,logview=logview,noinit=noinit

;+
; NAME:
;	XSH_RUN
;
; PURPOSE:
;	Spawns a command to run shadow.
;
; CATEGORY:
;	Shadow gui application.
;
; CALLING SEQUENCE:
;
;	XSH_RUN,command
;
; INPUTS:
;	command:	Command to be run
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	LOGFILE = file with log of running (not available under W95).
;	LOGVIEW = When set, opend a window with the log file after the
;		completition of the run. (not available under W95).
;	BG = When set, performs the task in the background.
;	NOINIT = when set, the initialization file (usually .shadowrc) is
;		not executed before the spawned command. (always set under W95).
;
; OUTPUTS:
;	None.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;	shadow (includes the shadow_start (i.e. source .../.shadowrc))
;
; SIDE EFFECTS:
;	initializes the spawn command with the result of
;		xsh_defaults('INITIALIZE')
;
; RESTRICTIONS: 
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	xsh_run,'epath < epath.inp'
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio
;	November, 1996
;	97/11/04 srio@esrf.fr makes spawned processes under /bin/sh. 
;	97/11/12 srio@esrf.fr adapts for W95.
;	98/03/19 srio@esrf.fr adds common block with shadow_start and shell
;	98/04/06 srio@esrf.fr removes shell from common block
;	98/04/08 srio@esrf.fr bug fixed in Unix after PC changes
;	00/07/17 srio@esrf.fr debugging messages when XOP_BINARIES_DEBUG
;		environment variable is set.
;-
common shadow, xshgeom, xshoe, shadow_start

on_error,2
if n_elements(command) EQ 0 then command = ''
idebug=0
IF StrCompress(Xop_GetEnv('XOP_BINARIES_DEBUG'),/Remove_All) NE '' THEN BEGIN
  idebug = 1
  itmp = Dialog_Message(/Info,Dialog_Parent=group,/Cancel,$
    ['Debugging message: Start to run: ','',command])
  IF itmp EQ 'Cancel' THEN Return
ENDIF  

IF SDEP() NE 'WINDOWS' THEN BEGIN
  if keyword_set(logview) then $
    if not(keyword_set(logfile)) then logfile=1
  
  if keyword_set(logfile) then begin
    if type(logfile) ne 7 then logfile = 'xsh_run.log'
    add = ' 2>&'+logfile
  endif else add = ''
ENDIF ELSE BEGIN
  ; noinit=1
  add=''
  logfile=0
  logview=0
ENDELSE


IF SDEP() EQ 'WINDOWS' THEN BEGIN
  if not(keyword_set(noinit)) then begin
    if n_elements(shadow_start) EQ 0 then $
	  shadow_start=xsh_defaults('SHADOW_START')
    init = shadow_start
  endif else init = ''
  newcommand = [init,command]
  openw,Unit,'shadowvui.bat',/Get_Lun
  for i=0,n_elements(newcommand)-1 do printf,Unit,newcommand(i)
  IF idebug EQ 1 THEN printf,Unit,'PAUSE'
  Free_Lun,Unit
  newcommand='shadowvui.bat'
ENDIF ELSE BEGIN
  if not(keyword_set(noinit)) then begin
    if n_elements(shadow_start) EQ 0 then $
	  shadow_start=xsh_defaults('SHADOW_START')
    init = shadow_start+' ; '
  endif else init = ''
  newcommand = init+command+add
  if keyword_set(bg) then newcommand = newcommand + '&'
ENDELSE
IF newcommand(0) NE '' THEN BEGIN
  for i=0,n_elements(newcommand)-1 do begin
    message,/info,'Executing: '+newcommand(i)
    IF idebug EQ 1 THEN BEGIN
      itmp = Dialog_Message(/Info,Dialog_Parent=group,/Cancel,$
        ['Start to run: ','',newcommand[i]])
      IF itmp EQ 'Cancel' THEN Return
    ENDIF  
    spawn,newcommand(i)
    wait,0.25
  endfor
ENDIF ELSE BEGIN
  message,/info,'Executing spawn'
  IF idebug EQ 1 THEN BEGIN
    itmp = Dialog_Message(/Info,Dialog_Parent=group,/Cancel,$
      ['Executing spawn'])
    IF itmp EQ 'Cancel' THEN Return
  ENDIF  
  spawn
ENDELSE

IF idebug EQ 1 THEN itmp = Dialog_Message(/Info,Dialog_Parent=group,$
    'Debugging message: Process run completed.')
 
if keyword_set(logfile) and keyword_set(logview) then $
  xdisplayfile1,logfile,/remove
end


