FUNCTION shresample,indata,_extra=extra, seed=iseed

;+
; NAME:
;	SHRESAMPLE
; PURPOSE:
;	This function reads a Shadow file/structure and resamples
;	it in another one with less rays, but all rays have intensity one
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	result = shResample(shadow_in)
; INPUTS:
;	shadow_in: The IDL structure with SHADOW data
; OUTPUTS:
;	 Result: The IDL/Shadow structure of the resampled beam
; KEYWORD PARAMETERS (INPUT):
;	SEED = Initialization for the random sample generator randomu1()
;	_Extra = extra keywords accepted by ShRead()
;
; ALGORITHM: 
;        A variance reduction technique: a number of random numbers
;        equal to the number of raysis created. For each ray, if the 
;        intensity if smaller than the corresponding random value, the ray 
;        is discarded. The intensity of the good (not discarted) rays is then 
;        set to one. 
;
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble May 2007
;
;-

on_error,2

a = readsh(indata,_extra=extra)

int1 = getShCol(a,23)

n = N_Elements(int1)

rand = randomu1(iseed,n)

igood = Where( int1 GE rand, ngood)


IF igood[0] EQ -1 THEN BEGIN
  print,'No good resampled points'
  ngood = 0
ENDIF

b = {name:a.name, ncol:a.ncol, npoint:ngood }

IF ngood GT 0 THEN BEGIN
  ray = a.ray
  ; set intensity to one
  ray[ [7,8,9,16,17,18]-1,*]=ray[ [7,8,9,16,17,18]-1,*]/sqrt(int1##Replicate(1,6))
  ; keew  only resampled rays
  newray = ray[*,igood]
  b = create_struct(b, 'ray', newray )
ENDIF
RETURN,b
END

