#! /bin/csh -f
#
# MAKE_PWR: Driver script for make_pwr utility.
#
# Author: Mumit Khan <khan@xraylith.wisc.edu>
#
# Source: src/utils/macro/MAKE_PWR
#
# ----------------------------------------------
#               SHADOW
#    Center for X-ray Lithography
#  University of Wisconsin-Madison
#  3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
# Log: MAKE_PWR
# Revision 1.5  1993/01/11  17:08:09  cwelnak
# need to add -f option to script created for user as well.
#
# Revision 1.4  1993/01/05  15:30:47  cwelnak
# added -f to /bin/csh line to save the path at the start
# of a subshell.
#
# Revision 1.3  1992/01/15  21:00:46  cwelnak
# file names to lower case
#
# Revision 1.2  1991/07/06  19:41:42  khan
# Grenoble Changes ...
#
# Revision 1.1  91/03/15  15:48:38  khan
# Initial revision
# 
# 

#
# Make sure the environment is correctly set up.
#

# This is for The CXrL Shadow developers only. Users can safely delete this.
umask 002


echo "--------------------------------------------------"
echo ""
echo -n "Name for the batch job [ ex: myjob.csh ] ? "; set jobname=$<
echo ""
echo -n "How many elements do you want to analyze ? "; set kount=$<

set jobfiles

@ i = 1

while ($i <= $kount)
    echo
    echo "Defining element: $i"
    echo 

    # Run pwr_dens.

    pwr_dens

    # Get the name of the output file for this pass.

    echo ""
    echo -n "Output file name for this element[ ex: ele1.par, ele2.par, ... ]? "
    set newname=$<

    /bin/mv PWR_DENS_PAR $newname

    set jobfiles = ($jobfiles $newname)

    @ i++

end

echo ""
echo "--------------------------------------------------"
echo ""
echo "Input completed. Now creating the batch file."
echo ""


# Save the old job file if it exists.
if ( -e $jobname) then
    echo "Renaming old jobfile to $jobname.OLD"
    /bin/mv -f $jobname $jobname.OLD
endif

@ i = 0
echo "Files read:"
foreach j ($jobfiles)
    @ i++
    echo "	${i}: ${j}"
end
echo ""

echo -n "How many OE's in this system? "; set nelem = $<
echo -n "How many loops? "; set kount = $<

# Start creating the jobfile now.

cat >> $jobname << EOB
#!/bin/csh -f
# SHADOW batch file created by MAKE_PWR.
#

@ i = 1
while (\$i <= $kount)
    echo "----------------------->> Starting iteration \$i"
    gen_source start.00
    trace -m batch << EOT
0
EOB

# now put all the elements needed for trace to run.
@ j = 1
while ($j <= $nelem)
    cat >> $jobname << EOB
start.0$j
0
EOB
    @ j++
end

cat >> $jobname << EOB
EXIT
EOT

# end of SHADOW run. Now run pwr_dens.
EOB

foreach j ($jobfiles)
    echo pwr_dens $j >> $jobname
end

# now clean it up (change the seed, etc) and end the outerloop.
cat >> $jobname << EOB
# change the seed.
echo start.00 | seed

echo ">>----------------------- Finished iteration \$i"
@ i++
end			# end of outer loop
exit 0
EOB

echo "--------------------------------------------------"
echo ""
echo "Batch file ready. Check for $jobname in your current directory."
echo "Note: Must have 'source .shadowrc' in your startup scripts."
echo ""
echo "--------------------------------------------------"
echo ""

