Function column_name,col,STR=str, ZeroCol=zerocol
;+
;
; Function column_name,col,STR=str, ZeroCol=zerocol
;
; Returns Shadow column description
; To be used internally by plotxy, histo1, etc...
; To be used internally by CW_XShCol (using keywords)
;
;
; 2006-02-21 The functionality of column_name is the same as xsh_coldes. 
; The code of xsh_coldes is integrated here, and xsh_coldes deleted. 
;
; history: 
; srio@esrf.fr 5-Dec-1997
; srio@esrf.fr 7-Apr-1998
; srio@esrf.fr 21-Feb-2006 added cols 19,25-28
; srio@esrf.eu 31-Mar-2008 minimal doc
;
;-

out = 0
titles = ['0: <none>', $
   '1: X [user unit]','2: Y [user unit]','3: Z [user unit]', $
   '4: Xp [rads]','5: Yp [rads]','6: Zp [rads]',$
   '7: Es X component','8: Es Y component','9: Es Z component', $
   '10: Lost Ray Flag','11: Energy [eV]','12: Ray Index', $
   '13: Optical Path Length','14: Es Phase','15: Ep Phase', $
   '16: Ep X component','17: Ep Y component','18: Ep Z component', $
   '19: Wavelength [A]','20: R= SQRT(X^2+Y^2+Z^2)','21: angle from Y axis', $
   '22: Electromagnetic vector magnitude','23: |E|^2 (total intensity)',$
   '24: total intensity for s-polarization', $
   '25: total intensity for p-polarization', $
   '26: K [A^-1]','27: Kx [A^-1]','28: Ky [A^-1]','29: Kz [A^-1]', $
   '30: S0-stokes = |Es|^2 + |Ep|^2 ', $
   '31: S1-stokes = |Es|^2 - |Ep|^2 ', $
   '32: S2-stokes = 2 |Es| |Ep| cos(ph_s-ph_p)', $
   '33: S3-stokes = 2 |Es| |Ep| sin(ph_s-ph_p)']


if keyword_set(str) then begin
  junk = {CW_PDMENU_S, flags:0, name:'' }
  ;out = [ {CW_PDMENU_S, 1, titles(0)}, $
  out = [ {CW_PDMENU_S, 1, titles(0)} ]
; allows col 0
	IF KeyWord_Set(ZeroCol) THEN out=[out,{CW_PDMENU_S, 0, titles(0)}]
	out = [out, {CW_PDMENU_S, 0, titles(1)}, $
	{CW_PDMENU_S, 0, titles(2)}, $
	{CW_PDMENU_S, 0, titles(3)}, $
	{CW_PDMENU_S, 0, titles(4)}, $
	{CW_PDMENU_S, 0, titles(5)}, $
	{CW_PDMENU_S, 0, titles(6)}, $
	{CW_PDMENU_S, 0, titles(11)}, $
	{CW_PDMENU_S, 1, 'Others:'}, $
	  {CW_PDMENU_S, 0, titles(10)}, $
	  {CW_PDMENU_S, 0, titles(12)}, $
	  {CW_PDMENU_S, 1, 'Electric Vector s-pol: '}, $
	    {CW_PDMENU_S, 0, titles(7)}, $
	    {CW_PDMENU_S, 0, titles(8)}, $
	    {CW_PDMENU_S, 0, titles(9)}, $
	    {CW_PDMENU_S, 2, titles(14)}, $
	  {CW_PDMENU_S, 1, 'Electric Vector p-pol: '}, $
	    {CW_PDMENU_S, 0, titles(16)}, $
	    {CW_PDMENU_S, 0, titles(17)}, $
	    {CW_PDMENU_S, 0, titles(18)}, $
	    {CW_PDMENU_S, 2, titles(15)}, $
	  {CW_PDMENU_S, 0, titles(13)}, $
	  {CW_PDMENU_S, 2, titles(19)}, $
	{CW_PDMENU_S, 1, 'Compound:'}, $
	  {CW_PDMENU_S, 0, titles(20)}, $
	  {CW_PDMENU_S, 0, titles(21)}, $
	  {CW_PDMENU_S, 0, titles(22)}, $
	  {CW_PDMENU_S, 0, titles(23)}, $
	  {CW_PDMENU_S, 0, titles(24)}, $
	  {CW_PDMENU_S, 0, titles(25)}, $
	  {CW_PDMENU_S, 0, titles(26)}, $
	  {CW_PDMENU_S, 0, titles(27)}, $
	  {CW_PDMENU_S, 0, titles(28)}, $
	  {CW_PDMENU_S, 0, titles(29)}, $
	  {CW_PDMENU_S, 1, 'Stokes:'}, $
	    {CW_PDMENU_S, 0, titles(30)}, $
	    {CW_PDMENU_S, 0, titles(31)}, $
	    {CW_PDMENU_S, 0, titles(32)}, $
	    {CW_PDMENU_S, 2, titles(33)}]
  return,out
endif
if n_params() GE 1 then return, titles(col) else return, titles
end
