pro xsh_preferences,Group=group

;+
; NAME:
;	XSH_PREFERENCES
;
; PURPOSE:
;	Sets the preferences for SHADOW VUI
;
; CATEGORY:
;	Shadow gui application.
;
; CALLING SEQUENCE:
;
;	XSH_PREFERENCES
;
; INPUTS:
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	GROUP = the widget id of the group parent
;
; OUTPUTS:
;	None.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;	shadow (includes the shadow_start (i.e. source .../.shadowrc)
;		and SHELL variables.
;
; SIDE EFFECTS:
;	changes the default SHELL (using setenv,'..')
;
; RESTRICTIONS: 
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	xsh_preferences
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio
;	March 19, 1998
;-
common shadow, xshgeom, xshoe, shadow_start
common shadow3, shadow3_mode

on_error,2

if n_elements(shadow_start) EQ 0 then shadow_start=xsh_defaults('SHADOW_START')
if n_elements(shell) EQ 0 then shell=xsh_defaults('SHELL')


help1 = ['This option customizes the SHADOW VUI with the command that ',$
 'should be run before when spawning proceses. This points to the SHADOW ',$
 'installation.',' ', $
 'The modifications done here will last during the current session only.', $
 'If you want to change the default preferences you should edit the file: ', $
 ' ',$
 Xop_Getenv('SHADOWVUI_HOME')+SDep(/ds)+'extensions'+SDep(/ds)+'data'+ $
   SDep(/ds)+'shadowvui_preferences.pro','', $
 'and then restart your ShadowVUI session.',' ']
 

sh3=[StrCompress(shadow3_mode),'Shadow2','Shadow3']

case sdep() of
  'WINDOWS': BEGIN
	tmp = { shadow_start:shadow_start,shadow3_mode:sh3}
	titles=['Initialization directory/command for SHADOW','Shadow Main Version:']
	Help = help1
	flags = replicate('1',n_elements(titles))
	END
  'UNIX': BEGIN
	shell = getenv('SHELL')
	tmp = { shadow_start:shadow_start, shell:shell, shadow3_mode:sh3}
	titles=['Initialization directory/command for SHADOW',$
	  'Spawning SHELL','Shadow3 mode']
	Help = [help1, $
 'For Unix systems this menu permits to choose the unix SHELL to be',$
 'used when processes are spawned. Our experience is that sh goes much',$
 'faster than csh and should be preferred.',$
 'Please be consistent with the command depending on the chosen SHELL: ',$
 'Use "source .../.shadowrc" when using "csh" and ',$
 '    ". .../.shadowrc.sh" when using "sh".'  ]
	flags = replicate('1',n_elements(titles))
	END
else: 
endcase
  

action = 0
XScrMenu,tmp,/notype,action=action, Help=help, Titles=titles, $
  Flags=flags, Wtitle='SHADOW VUI preferences', FieldLen=80, Group=group, $
  Dialog_Parent=group,/Interpret
if action EQ 'DONT' then return

if sdep() EQ 'UNIX' then begin
  setenv,'SHELL='+tmp.shell
  shell = tmp.shell
endif
shadow_start = tmp.shadow_start
shadow3_mode=Fix(tmp.shadow3_mode[0])
help,shadow3_mode

end


