;+
; NAME:
;       OPTICAL_SOURCE__DEFINE.
;
; PURPOSE:
;       This procedure defines the 'optical_source' object. An optical_source 
;		is used to build a 3D representation of an optical source.
;		It can be add to an optical_system.
;
; FIELD:
;		parent: a ref on an optical system object
;		model_source: an idlgrmodel to draw the mesh representation
;		graphic: an idlgrmodel to draw the all the 3D representation
;		dimension_scale: the scale of all the components
;		dimensionElement_scale: the scale of the mesh
;		show_axisX,	show_axisY,	show_axisZ: 
;		Does the axis_Lambda must be draw: 0->Yes, 1->No
;		show_symbol: Does the mesh must be draw: 0->Yes, 1->No
;		trans: Does the mesh must be transparency: 0->No, 1->Yes
;		optical_element_color: the RVB color of the mesh.
;		axis_color: The RVB color of the axis.
;
; CATEGORY:
;       optical_plane class.
;
; CALLING SEQUENCE:
;       plane=obj_new('OPTICAL_Plane')
;
; INPUTS:
;		None
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:;
;
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-
;*********************************
;purpose:the init function
function optical_source::Init
self.parent=obj_new()
self.smodel.graphic=obj_new('idlgrmodel')

;*draw Property

self.sPrivateParameter.dimension_scale=1.
self.sPrivateParameter.dimensionElement_scale=1.
self.sprivateParameter.trans=0
self.sprivateParameter.show_axisX=0
self.sprivateParameter.show_axisY=0
self.sprivateParameter.show_axisZ=0
self.sprivateParameter.show_symbol=0
self.sprivateParameter.optical_element_color=[110,110,255]
self.sprivateParameter.axis_color=[255,255,255]
self.sprivateParameter.axis_scale=1.
self.sprivateParameter.mesh_file=string('undefined')

;axes X-Y-Z
ox_title=obj_new('idlgrtext','X',CHAR_DIMENSIONS=[0.3,0.3])
oy_title=obj_new('idlgrtext','Y',CHAR_DIMENSIONS=[0.3,0.3])
oz_title=obj_new('idlgrtext','Z',CHAR_DIMENSIONS=[0.3,0.3])
oaxisX=obj_new('idlgraxis',name='x',direction=0,range=[0,0.4],color=self.sprivateParameter.axis_color,major=0,minor=0,title=ox_title)
oaxisY=obj_new('idlgraxis',name='y',direction=1,range=[0,0.4],color=self.sprivateParameter.axis_color,major=0,minor=0,title=oy_title)
oaxisZ=obj_new('idlgraxis',name='z',direction=2,range=[0,0.4],color=self.sprivateParameter.axis_color,major=0,minor=0,title=oz_title)
oAxes=obj_new('idlgrmodel', name='axesX-Y-Z')
oAxes->add, oaxisX
oAxes->add, oaxisY
oAxes->add, oaxisZ
self.smodel.graphic->add, oAxes

;symbol
symbol=obj_new('idlgrmodel', name='symbol')
self.smodel.graphic->add, symbol


return, 1
end
;****************cleanUP*****************
;PURPOSE: use to clean memory when object is destroy
pro optical_source::cleanUp

if obj_isa(self.parent,'blv_optical_source') then $
		self.parent->remove, self

m=self.sModel.graphic->getbyname('axesX-Y-Z')
n=m->count()
for r=0, n-1 do begin
	o=m->get(pos=r)
	o->getProperty, title=t
	obj_destroy, t
endfor

obj_destroy, self.sModel.graphic
end
;***********setProperty****************
;PURPOSE: modify the field of the object when the keyWord of the field is used
pro optical_source::setProperty,Symbol=Symbol, $
								Graphic=graphic, $
								dimensionElement_scale=dimensionElement_scale, $
								dimension_scale=dimension_scale, $
								show_axisX=show_axisX, $
								show_axisY=show_axisY, $
								show_axisZ=show_axisZ, $
								show_symbol=show_symbol, $
								transparen=transparen, $
								parent=parent, $
								optical_element_color=optical_element_color, $
								axis_color=axis_color, $
								axis_scale=axis_scale, $
								mesh_file=mesh_file

if n_elements(Symbol) NE 0 then begin
			Oldsymbol=self.smodel.Graphic->getbyname('symbol')
			self.smodel.graphic->remove, Oldsymbol
			obj_destroy, Oldsymbol
			symbol->setProperty, name='symbol'
			self.smodel.graphic->add, symbol
endif
if n_elements(graphics) NE 0 then self.smodel.graphic=graphic

if n_elements(dimension_scale) NE 0 then self.sPrivateParameter.dimension_scale=dimension_scale
if n_elements(dimensionElement_scale) NE 0 then self.sPrivateParameter.dimensionElement_scale=dimensionElement_scale
if n_elements(show_axisX) NE 0 then self.sPrivateParameter.show_axisX=show_axisX
if n_elements(show_axisY) NE 0 then self.sPrivateParameter.show_axisY=show_axisY
if n_elements(show_axisZ) NE 0 then self.sPrivateParameter.show_axisZ=show_axisZ
if n_elements(show_symbol) NE 0 then self.sPrivateParameter.show_symbol=show_symbol
if n_elements(transparen) NE 0 then self.sPrivateParameter.trans=transparen

if n_elements(optical_element_color) NE 0 then self.sPrivateParameter.optical_element_color=optical_element_color
if n_elements(axis_color) NE 0 then self.sPrivateParameter.axis_color=axis_color

if n_elements(parent) ne 0 then self.parent=parent
if n_elements(axis_scale) NE 0 then self.sPrivateParameter.axis_scale=axis_scale
if n_elements(mesh_file) NE 0 then self.sPrivateParameter.mesh_file=mesh_file

self->upDate_parameter
end
;*********************************************
;purpose: to change field value, function to their actual value
pro optical_source::flip, show_axisX=saX, $
							show_axisY=saY, $
							show_axisZ=saZ, $
							show_symbol=ss, $
							transparen=transparen



if n_elements(saX) ne 0 then self.sPrivateParameter.show_axisX=abs(self.sPrivateParameter.show_axisX-1)
if n_elements(saY) ne 0 then self.sPrivateParameter.show_axisY=abs(self.sPrivateParameter.show_axisY-1)
if n_elements(saZ) ne 0 then self.sPrivateParameter.show_axisZ=abs(self.sPrivateParameter.show_axisZ-1)
if n_elements(ss) ne 0 then self.sPrivateParameter.show_symbol=abs(self.sPrivateParameter.show_symbol-1)
if n_elements(transparen) ne 0 then self.sPrivateParameter.trans=abs(self.sPrivateParameter.trans-1)

self->upDate_parameter
end
;***********getProperty****************
;PURPOSE: return the field of the object when the keyWord of the field is used
pro optical_source::getProperty, Graphic=graphic, $
								dimension_Scale=dimension_scale, $
								dimensionElement_scale=dimensionElement_scale, $
								Transparen=trans, $
								parent=parent, $
								optical_element_color=optical_element_color, $
								axis_color=axis_color, $
								show_symbol=show_symbol, $
								show_axisX=show_axisX, $
								show_axisY=show_axisY, $
								show_axisZ=show_axisZ, $
								axis_scale=axis_scale, $
								mesh_file=mesh_file

graphic=self.smodel.graphic
dimension_scale=self.sPrivateParameter.dimension_scale
dimensionElement_scale=self.sPrivateParameter.dimensionElement_scale
trans=self.sPrivateParameter.trans
parent=self.parent
show_symbol=self.sPrivateParameter.show_symbol
show_axisX=self.sPrivateParameter.show_axisX
show_axisY=self.sPrivateParameter.show_axisY
show_axisZ=self.sPrivateParameter.show_axisZ
optical_element_color=self.sPrivateParameter.optical_element_color
axis_color=self.sPrivateParameter.axis_color
axis_scale=self.sPrivateParameter.axis_scale
mesh_file=self.sPrivateParameter.mesh_file
end
;;***********trace****************
;	PURPOSE: build the element necessary to the graphic representation
;	function to the current property
pro optical_source::trace

self->update_parameter
;the module has a parent?
if obj_isa(self.parent,'optical_system') then begin
	self.parent->getProperty, distance_scale=g_distance_scale, $
							dimension_scale=g_dimension_scale
endif else begin
	g_distance_scale=1.
	g_dimension_scale=1.
endelse

self.smodel.graphic->reset
self.smodel.graphic->scale, self.sPrivateParameter.dimension_scale * g_dimension_scale , $
							self.sPrivateParameter.dimension_scale * g_dimension_scale , $
							self.sPrivateParameter.dimension_scale * g_dimension_scale

symbol=self.smodel.graphic->getbyname('symbol')
symbol->reset
symbol->scale, self.sPrivateParameter.dimension_scale * g_dimension_scale * self.sPrivateParameter.dimensionElement_scale, $
				self.sPrivateParameter.dimension_scale * g_dimension_scale * self.sPrivateParameter.dimensionElement_scale, $
				self.sPrivateParameter.dimension_scale * g_dimension_scale * self.sPrivateParameter.dimensionElement_scale
end
;******************************************
;purpose : to apply the current property
pro optical_source::update_parameter
	obj=self.smodel.graphic->getbyname('symbol')
	obj->setProperty, hide=self.sPrivateParameter.show_symbol
	if self.sPrivateParameter.trans then transparency, obj else opacity, obj
	;color_model, obj, self.sPrivateParameter.optical_element_color

	obj=self.smodel.graphic->getbyname('axesX-Y-Z')
	obj->reset


	obj->scale, self.sPrivateParameter.axis_scale, $
				self.sPrivateParameter.axis_scale, $
				self.sPrivateParameter.axis_scale

	axisX=obj->getbyname('x')
	axisY=obj->getbyname('y')
	axisZ=obj->getbyname('z')

	axisX->setProperty, hide=self.sPrivateParameter.show_axisX
	axisY->setProperty, hide=self.sPrivateParameter.show_axisY
	axisZ->setProperty, hide=self.sPrivateParameter.show_axisZ
	color_model, obj, self.sPrivateParameter.axis_color
end
;****************************************
;************************************
;purpose : the define procedure
pro optical_source__define
parent=obj_new()

sModel={model_source, $
		graphic:obj_new() $
		}
flt=0.
int=0

sPrivateParameter={parameters_source, $
			dimension_scale:flt, $
			dimensionElement_scale:flt, $
			show_axisX:int, $
			show_axisY:int, $
			show_axisZ:int, $
			show_symbol:int, $
			trans:int, $
			optical_element_color:[int,int,int], $
			axis_color:[int,int,int], $
			axis_scale:flt, $
			mesh_file:string('undefined') $
			}

struct={optical_source, $ ;name of the structure
		parent:parent ,$ ; ref on a system in witch the module is inclued
		sModel:sModel, $
		sPrivateParameter:sPrivateParameter $
		}
end
