;+
; NAME:
;       BLViewer.
;
; PURPOSE:
;       This procedure build representation of optical system and make able to
;		modify property of the system.
;
; CATEGORY:
;       Optic.
;
; CALLING SEQUENCE:
;       BLViewer, File=file
;
; INPUTS:
;		none
;
; KEYWORD PARAMETERS:
;		File: a systemfile to open immediatly (*.dat)
;
; EXAMPLE:;
;       BLViewer, File=file
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by:  ESRF, EXP, May 2001
;-

FUNCTION blviewer_version
RETURN,'1.0 Beta 1'
END
;************_add_optical_module_event_************
;purpose: Controls the statut bar and call the procedure to add a module
pro blv_add_optical_module_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, (*pInfo).wid.statut, set_value='Waiting...'
dim=blv_module_def_parameter(event.top)
if dim.ok eq 0 then begin
	widget_control, (*pInfo).wid.statut, set_value='Ready.'
	return
endif

blv_add_optical_module, dim, pInfo
blv_center_view, pInfo
blv_draw_system, pInfo
widget_control, (*pInfo).wid.statut, set_value='Ready.'
end
;**************************************************
;************track_event**********
;purpose: controls the view's rotation
PRO blv_Track_event, sEvent
Widget_control, sevent.top, Get_UValue=pInfo

if (sEvent.type EQ 4) then begin ;  Resize window
    WIDGET_CONTROL, sevent.top, /HOURGLASS ;Redraw entire window
    (*pInfo).wid.window->draw, (*pInfo).wid.view
    return
endif

bHaveXform = (*pInfo).wid.trackball->Update( sEvent, TRANSFORM=TrackXform)
	IF (bHaveXform) THEN BEGIN
   		(*pInfo).wid.model->GetProperty, TRANSFORM=ModelXform
		(*pInfo).wid.model->SetProperty, TRANSFORM=ModelXform # TrackXform
		blv_draw_system, pInfo
	ENDIF

if (*pInfo).data.flagTrack then begin

	(*pInfo).wid.window->getProperty, SCREEN_DIMENSIONS=screen

	dx=(*pInfo).data.TrackX	- float(sEvent.X)/screen[0]
	dy=(*pInfo).data.TrackY - float(sEvent.Y)/screen[1]

	(*pInfo).data.TrackX=sEvent.X/screen[0]
	(*pInfo).data.TrackY=sEvent.Y/screen[1]

	(*pInfo).wid.view->getProperty, VIEWPLANE_RECT=rect
	drectX=(rect[2]-rect[0])*dx
	drectY=(rect[3]-rect[1])*dy

	(*pInfo).wid.view->setProperty, VIEWPLANE_RECT=[rect[0]+drectX, rect[1] + drectY, $
													rect[2]+drectX, rect[3] + drectY]

	(*pInfo).wid.window->draw, (*pInfo).wid.view
endif


if (sEvent.type eq 0) then begin  ; click - start tracking
	if sEvent.press gt 1 then begin
		(*pInfo).data.flagTrack=1
		(*pInfo).wid.window->getProperty, SCREEN_DIMENSIONS=screen
		(*pInfo).data.TrackX=sEvent.X/screen[0]
		(*pInfo).data.TrackY=sEvent.Y/screen[1]
	endif
endif

if (sEvent.type eq 1) then begin    ; release mouse button - end tracking
			(*pInfo).data.flagTrack=0
endif
END


;
;==========================================================================================================
;
pro blv_close_BLViewer, pInfo
  obj_destroy, (*pInfo).data.system
  obj_destroy, (*pInfo).wid.model
  obj_destroy, (*pInfo).wid.trackball
  obj_destroy, (*pInfo).wid.view
  obj_destroy, (*pInfo).wid.printer
  tbl=(*pInfo).wid.tbl
  ptr_free, pInfo
  ; srio close, /all
  widget_control, tbl, /destroy
end


;*********************************
;*************close_event*********
;purpose: calls the procedure to close the application
pro blv_close_event, event
widget_control, event.top, get_uvalue=pInfo
blv_close_BLViewer, pInfo
;
; JUST IN CASE (srio)
;
heap_gc
end
;***************************************************
;******************color work***********************
;purpose: used to change the background color
pro blv_colors_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, (*pInfo).wid.statut, set_value='Waiting...'
(*pinfo).wid.view->getProperty, Color=color
data=Get_RGB(event.top, rgb=color)
if data.ok eq 0 then return
((*pInfo).wid.view)->setProperty, color=data.rgb
(*pInfo).wid.window->draw, (*pInfo).wid.view
widget_control, (*pInfo).wid.statut, set_value='Ready.'
end



;**********************************
;**********show_event**************
;purpose: changes options to draw the system
pro blv_show_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, event.id, get_uvalue=button
n_sys=(*pInfo).data.system->count()
case button of
	'Optical Axis': begin
		(*pInfo).data.system->flip, /show_axis

		if (*pInfo).wid.wGlobal ne  (*pinfo).wid.tbl then begin
			(*pInfo).data.system->getProperty,show_axis=show_axis
			widget_control, (*pInfo).wid.wGlobal, get_uvalue=info
			widget_control, (*info.pInfoGlobal).wOpticalAxes, set_button=abs(show_axis-1)
		endif
		end
	'Continuation Planes Source': begin
		(*pInfo).data.system->flip, /show_plane_source
		if (*pInfo).wid.wGlobal ne  (*pinfo).wid.tbl then begin
			(*pInfo).data.system->getProperty,show_plane_source=show_plane_source
			widget_control, (*pInfo).wid.wGlobal, get_uvalue=info
			widget_control, (*info.pInfoGlobal).wPlaneSource, set_button=abs(show_plane_source-1)
		endif
		end
	'Continuation Planes Image': begin
		(*pInfo).data.system->flip, /show_plane_image
		if (*pInfo).wid.wGlobal ne  (*pinfo).wid.tbl then begin
			(*pInfo).data.system->getProperty,show_plane_image=show_plane_image
			widget_control, (*pInfo).wid.wGlobal, get_uvalue=info
			widget_control, (*info.pInfoGlobal).wPlaneImage, set_button=abs(show_plane_image-1)
		endif
		end
	'Optical Elements': begin
		(*pInfo).data.system->flip, /show_symbol
		if (*pInfo).wid.wGlobal ne  (*pinfo).wid.tbl then begin
			(*pInfo).data.system->getProperty,show_symbol=show_symbol
			widget_control, (*pInfo).wid.wGlobal, get_uvalue=info
			widget_control, (*info.pInfoGlobal).wElement, set_button=abs(show_symbol-1)
		endif
		end
	'O.E. Normals': begin
		(*pInfo).data.system->flip, /show_normal
		if (*pInfo).wid.wGlobal ne  (*pinfo).wid.tbl then begin
			(*pInfo).data.system->getProperty,show_normal=show_normal
			widget_control, (*pInfo).wid.wGlobal, get_uvalue=info
			widget_control, (*info.pInfoGlobal).wNormal, set_button=abs(show_normal-1)
		endif
		end
	'O.E. Frame Axes':begin
		(*pInfo).data.system->flip, /show_axes_element
		if (*pInfo).wid.wGlobal ne  (*pinfo).wid.tbl then begin
			(*pInfo).data.system->getProperty,show_axes_element=show_axes_element
			widget_control, (*pInfo).wid.wGlobal, get_uvalue=info
			widget_control, (*info.pInfoGlobal).wAxesElement, set_button=abs(show_axes_element-1)
		endif
		end
	else : 	message,'Option not found: '+button
endcase

(*pInfo).data.system->trace
blv_draw_system, pInfo

end
;********************************************
;**********delete work***********
;purpose: deletes the current selected module
pro blv_delete_event, event
widget_control, event.top, get_uvalue=pInfo
blv_del_optical_module, pInfo
blv_center_view, pInfo
blv_draw_system, pInfo
end
;***********************************
;**********open work****************
;purpose: creates dialogue box used to ask a path's file and call a procedure able to open this file.
pro blv_open_datStart_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, (*pInfo).wid.statut, set_value='Waiting...'
file=dialog_pickfile(title='Open Optical System...', $
		/read,DIALOG_PARENT=(*pInfo).wid.tbl, Filter='*.dat')
IF file EQ '' THEN RETURN

(*pInfo).data.end_file=0
blv_open_optical_system, pInfo, file

(*pInfo).data.system->trace
blv_center_view, pInfo
blv_draw_system, pInfo

widget_control, (*pInfo).wid.statut, set_value='Ready.'
end
;**********open work****************
;purpose: creates dialogue box used to ask a path's file and call a procedure able to open this file.
pro blv_open_datEnd_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, (*pInfo).wid.statut, set_value='Waiting...'
file=dialog_pickfile(title='Open Optical System...', $
		/read,DIALOG_PARENT=(*pInfo).wid.tbl, Filter='*.dat')
IF file EQ '' THEN RETURN
(*pInfo).data.end_file=1
blv_open_optical_system, pInfo, file, /end_file

(*pInfo).data.system->trace
blv_center_view, pInfo
blv_draw_system, pInfo

widget_control, (*pInfo).wid.statut, set_value='Ready.'
end
;**********open work****************
;purpose: creates dialogue box used to ask a path's file and call a procedure able to open this file.
pro blv_open_blv_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, (*pInfo).wid.statut, set_value='Waiting...'
file=dialog_pickfile(title='Open Optical System...', $
		/read,DIALOG_PARENT=(*pInfo).wid.tbl, Filter='*.blv')
;srio cd, '
blv_open_optical_system, pInfo, file

(*pInfo).data.system->trace
blv_center_view, pInfo
blv_draw_system, pInfo

widget_control, (*pInfo).wid.statut, set_value='Ready.'
end
;**********************************
;*****save_event********************
;purpose: saves the current system in a *.blv ASCII file
pro blv_save_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, (*pInfo).wid.statut, set_value='Waiting...'
blv_save_optical_system, pInfo, Group=event.top
widget_control, (*pInfo).wid.statut, set_value='Ready.'
end



;srio ;***********************************
;srio ;*********refresh_event**************
;srio ; purpose: reload the last data in file
;srio pro blv_refresh_event, event,NoLoad=noLoad
;srio widget_control, event.top, get_uvalue=pInfo
;srio 
;srio IF NOT(Keyword_Set(noLoad)) THEN BEGIN
;srio   file=(*pInfo).data.last_file_name
;srio   if file ne '' then blv_open_optical_system, pInfo, file, end_file=(*pInfo).data.end_file
;srio   if file ne '' and (*pInfo).data.rays_file then read_system_rays_file,(*pInfo).data.system, file
;srio ENDIF
;srio 
;srio 
;srio (*pInfo).data.system->trace
;srio blv_center_view, pInfo
;srio blv_draw_system, pInfo
;srio 
;srio widget_control, (*pInfo).wid.statut, set_value='Ready.'
;srio end
;srio ;****************************************








;***********************************
;*********refresh_event**************
; purpose: reload the last data in file
pro blv_refresh1_event, event,NoLoad=noLoad

widget_control, event.top, get_uvalue=pInfo
autoLoad= (*pInfo).data.rays_file
IF Keyword_Set(noLoad) THEN autoLoad=0

IF autoLoad THEN BEGIN

  module=(*pInfo).data.system->get_module(pos=0)
  n_rays_toDraw1 = module->count_ray_toDraw()

  file=(*pInfo).data.last_file_name
  if file ne '' then blv_open_optical_system, pInfo, file, end_file=(*pInfo).data.end_file
  if file ne '' and (*pInfo).data.rays_file then read_system_rays_file,(*pInfo).data.system, file

			n_obj=(*pinfo).data.system->count()
			for pos=0, n_obj-1 do begin
				 module=(*pInfo).data.system->get_module(pos=pos)
				 n_rays_toDraw = module->count_ray_toDraw()
					for r=0, n_rays_toDraw1-1 do begin
						module=(*pinfo).data.system->get_module(pos=pos)
;						print,'<<<< adding ray: ', r
						module->add_ray_toDraw, r
					endfor
			endfor
ENDIF

(*pInfo).data.system->trace
blv_center_view, pInfo
blv_draw_system, pInfo

widget_control, (*pInfo).wid.statut, set_value='Ready.'
end



;****************************************
;************scale work*******************
pro blv_scale_event, event
;purpose: changes the scale type used to represent the system
widget_control, event.top, get_uvalue=pInfo
widget_control, event.id, get_uvalue=button
if button eq 'Linear' then begin
	(*pInfo).data.system->setProperty, log=0
endif else begin
	(*pInfo).data.system->setProperty, log=1
endelse

if (*pInfo).wid.wGlobal ne  (*pinfo).wid.tbl then begin
		widget_control, (*pInfo).wid.wGlobal, get_uvalue=info
		(*pInfo).data.system->getProperty, log=log
		widget_control, (*info.pInfoGlobal).wScaleGroup, set_value=log
endif

(*pInfo).data.system->trace
blv_draw_system, pInfo
end
;***************************************
;**********change view***************
;purpose: replace the view in the asked orientation by calling a procedure
pro blv_change_view_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, event.id, get_uvalue=button

if button eq '4' then begin
	blv_change_view, pInfo, 0
	blv_center_view, pInfo
	blv_draw_system, pInfo
endif

if (*pInfo).wid.wGlobal ne  (*pinfo).wid.tbl then begin
	widget_control, (*pInfo).wid.wGlobal, get_uvalue=info
	if uint(button) lt 4 then widget_control,(*info.pInfoGlobal).wViewGroup, set_value=uint(button) $
		else widget_control,(*info.pInfoGlobal).wViewGroup, set_value=0
endif

blv_change_view, pInfo, button
blv_center_view, pInfo
blv_draw_system, pInfo
end
;*****************************************************
;******************event on base**********************
;purpose: event on base: - resize, - kill
pro BLViewer_event, event
widget_control, event.top, get_uvalue=pInfo
IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_BASE' THEN begin
	CASE SDep() OF 
	  'WINDOWS': shift = [0,59]
	  'UNIX': shift = [5,90]
	  else: shift = [0,59]
        ENDCASE
	widget_control, (*pInfo).wid.draw, XSIZE=(event.x-shift[0])
	widget_control, (*pInfo).wid.draw, YSIZE=(event.y-shift[1])
	(*pInfo).data.scr_size =  [event.x-shift[0],event.y-shift[1]]
	return
endif
IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN begin
	blv_close_BLViewer, pInfo
endif
IF (TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_TIMER') THEN BEGIN
	if (*pInfo).data.flagAnimateRot then begin
		(*pInfo).wid.model->rotate,[1, 0, 0], 1.5
        (*pInfo).wid.model->rotate,[0, 1, 0], 1.
        (*pInfo).wid.model->rotate,[0, 0, 1], 0.5
		blv_draw_system, pInfo
		WIDGET_CONTROL, event.top, TIMER=0.01
	endif
	if (*pInfo).data.flagAnimateRays then begin
		;(*pInfo).data.system->trace, evolution=(*pInfo).data.evolutionTrace
		nb_module=(*pInfo).data.system->count()
		if nb_module gt 0 then evolMax=100./nb_module

		for pos=0, nb_module-1 do begin
			evolModule=nb_module*(*pInfo).data.evolutionTrace - pos*100
			if evolModule gt 0. and evolModule lt 110 then begin
				module=(*pInfo).data.system->get_module(posi=pos)
				module->trace, evolution=evolModule
			endif
		endfor

		blv_draw_system, pInfo
		(*pInfo).data.evolutionTrace=(*pInfo).data.evolutionTrace + 2
		if (*pInfo).data.evolutionTrace gt 100. then begin
			(*pInfo).data.evolutionTrace=0.
			(*pInfo).data.system->trace, evolution=(*pInfo).data.evolutionTrace
			if (*pInfo).data.flagAnimateMovie then begin
				(*pInfo).data.flagAnimateMovie=0
			endif
		endif
		if (*pInfo).data.flagAnimateMovie then begin
			image = (*pInfo).wid.window->read()
			image->getProperty, data=imageTab
			;im= CONGRID(imageTab[0,*,*], 128,128)
			obj_destroy, image
			widget_control, (*pInfo).wid.player, get_uvalue=wPlayer
			CW_ANIMATE_LOAD, wPlayer, image=imageTab
		endif
		WIDGET_CONTROL, event.top, TIMER=0.0001
	endif
ENDIF
end
;**************************************************
;******************frame or opaque**********************
;purpose: changes the opacity of the modules
pro blv_opa_fram_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, event.id, get_uvalue=button
case button of
	'Opaque': begin
		(*pInfo).data.system->setProperty, transparen=0
		end
	'Frame':begin
		(*pInfo).data.system->setProperty, transparen=1
		end
	else: return
endcase
if (*pInfo).wid.wGlobal ne  (*pinfo).wid.tbl then begin
	widget_control, (*pInfo).wid.wGlobal, get_uvalue=info
	(*pInfo).data.system->getProperty, transparen=trans
	widget_control,(*info.pInfoGlobal).wOEGroup, set_value=abs(trans-1)
endif
blv_draw_system, pInfo
end
;******************************
;***********************************
;purpose: calls other dialogue boxs for a better control
pro blv_open_frame_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, event.id, get_value=button
case button of
	'Global Controls':begin
				if (*pInfo).wid.wGlobal eq (*pInfo).wid.tbl then begin
				(*pInfo).wid.wGlobal=blv_global_control(pInfo)
				endif
				end
	'Rays':begin
				if (*pInfo).wid.wRays eq (*pInfo).wid.tbl then begin
				(*pInfo).wid.wRays=blv_Rays_control(pInfo)
				endif
				end
	'Module':begin
				if (*pInfo).wid.wModule eq (*pInfo).wid.tbl then begin
				(*pInfo).wid.wModule=blv_module_control(pInfo)
				blv_show_element, pInfo
				blv_draw_system, pInfo
				endif
				end
	'Source':begin
				IF (*pInfo).wid.wSource EQ (*pInfo).wid.tbl THEN BEGIN
				  (*pInfo).wid.wSource=blv_Source_control(pInfo)
				ENDIF
				end
	else: return
	endcase
end
;********************************
pro blv_print_event, event
widget_control, event.top, get_uvalue=pInfo
widget_control, (*pInfo).wid.statut, set_value='Waiting...'
r=DIALOG_PRINTERSETUP((*pInfo).wid.printer, DIALOG_PARENT=(*pInfo).wid.tbl)
if r eq 0 then begin
	widget_control, (*pInfo).wid.statut, set_value='Ready.'
	return
endif
widget_control, /HOURGLASS
widget_control, (*pInfo).wid.statut, set_value='Printing...'
(*pInfo).wid.printer->draw
(*pInfo).wid.printer->newDocument
widget_control, (*pInfo).wid.statut, set_value='Ready.'
end
;****************************************
pro blv_picture_event, event
widget_control, event.top, get_uvalue=pInfo
; srio (*pInfo).wid.window->getProperty, SCREEN_DIMENSIONS=screen
image = (*pInfo).wid.window->read()
screen = (*pInfo).data.scr_size
image->setProperty, dimension=[1,1]
blv_export_image, image, screen, Group = (*pInfo).wid.tbl
end
;************************************
pro blv_animate_rot_event, event
widget_control, event.top, get_uvalue=pInfo
(*pInfo).data.flagAnimateRot=abs((*pInfo).data.flagAnimateRot-1)
if (*pInfo).data.flagAnimateRot eq 1 then WIDGET_CONTROL, event.top, TIMER=0.01
end
;***************************
pro blv_animate_rays_event, event


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_animate_rays_event: error caught: '+!error_state.msg)
   RETURN
ENDIF

widget_control, event.top, get_uvalue=pInfo

nbMod=(*pInfo).data.system->count()
if nbMod gt 0 then begin
	module=(*pInfo).data.system->get_module()
	module->getProperty, rays_source=beam
	nb_rays=beam->count()
	IF nb_rays EQ 0 THEN RETURN
endif else RETURN


(*pInfo).data.flagAnimateRays=abs((*pInfo).data.flagAnimateRays-1)
if (*pInfo).data.flagAnimateRays eq 1 then begin
	(*pInfo).data.evolutionTrace=0.
	(*pInfo).data.system->trace, evolution=(*pInfo).data.evolutionTrace
	WIDGET_CONTROL, event.top, TIMER=0.0001
endif else begin
	(*pInfo).data.evolutionTrace=100.
	(*pInfo).data.system->trace, evolution=(*pInfo).data.evolutionTrace
	blv_draw_system, pInfo
endelse
end
;srio ;************************************
;srio pro blv_animate_rays_MPEG_event, event
;srio widget_control, event.top, get_uvalue=pInfo
;srio (*pInfo).data.flagAnimateRays=abs((*pInfo).data.flagAnimateRays-1)
;srio (*pInfo).data.flagAnimateMovie=abs((*pInfo).data.flagAnimateMovie-1)
;srio if ((*pInfo).data.flagAnimateMovie) then begin
;srio 	(*pInfo).wid.player = widget_base(GROUP_LEADER=TBL)
;srio 		wPlayer=cw_animate((*pInfo).wid.player, 700, 600, 11)
;srio 	widget_control, (*pInfo).wid.player, /realize
;srio 	widget_control, (*pInfo).wid.player, set_uvalue=wPlayer
;srio endif else begin
;srio 	widget_control, (*pInfo).wid.player, get_uvalue=wPlayer
;srio 	CW_ANIMATE_run, wPlayer, rate=1
;srio endelse
;srio if (*pInfo).data.flagAnimateRays eq 1 then begin
;srio 	(*pInfo).data.evolutionTrace=0.
;srio 	(*pInfo).data.system->trace, evolution=(*pInfo).data.evolutionTrace
;srio 	WIDGET_CONTROL, event.top, TIMER=0.0001
;srio endif else begin
;srio 	(*pInfo).data.evolutionTrace=100.
;srio 	(*pInfo).data.system->trace, evolution=(*pInfo).data.evolutionTrace
;srio 	blv_draw_system, pInfo
;srio endelse
;srio end
;***********************************
pro blv_help_event, event
txt = $	
[' BLVIEWER: an application for 3D visualization of optical systems',$
'  You can find the users manual of BLViewer at: ','',$
'  http://www.esrf.fr/computing/scientific/xop/shadowvui/blviewer.html',$
'','Known bugs: ',$
'1) The Y and Z axis labels in Linux are not placed correctly',$
'2) Not tested under Unix (excepts Linux)',$
'3) Only jpeg format is supported in this version (others to come)',$
'   Plase report bugs to srio@esrf.fr ']

XDisplayFile1,Text=txt,Dialog_Parent=event.top,Title='BLViewer help'

end
;************************************
pro blv_about_event, event
	result = DIALOG_MESSAGE(Dialog_Parent=event.top, Title='About BLViewer',/Information, $
        ['',$
	'                 BLViewer  '+blviewer_version(), $
	'','', $
	'                          by                   ',$
	'', $
	'                      Cyril Poirier            ',$
	'', $
	'                          and                   ',$
	'', $
	'                   Manuel Sanchez del Rio    ',$
	'', $
	'                        ESRF 2001             ',$
	'','', $
	"BLViewer is distributed as a part of the ShadowVUI XOP's extension",'',$
	'', $
	'Fore more info, see http://www.esrf.fr/computing/scientific/xop/'])
END

;
;==========================================================================================================
;

;************main********************

pro BLViewer, File=file_default,  Group=group, End_File=End_File, $
XSize=xsize, YSize=ysize, Config_file=config_file_flag

widget_control, /HOURGLASS
tbl=widget_base(title='BLViewer'+blviewer_version(),/col, mbar=bar, $
		/tlb_size_events,/TLB_KILL_REQUEST_EVENTS, event_pro='blv_viewer_event');,KILL_NOTIFY='close_event')

;=========================

	;******menu*********
	wfile=widget_button(bar,value='File', /MENU)
		wopen=widget_button(wfile, value='Open',/Menu)
			wopenDat=widget_button(wopen, value='System File (*.dat)',/Menu)
				wend=widget_button(wopendat, value='With End.xx',event_pro='blv_open_datEnd_event')
				wstart=widget_button(wopendat, value='With Start.xx',event_pro='blv_open_datStart_event')
			wopenBlv=widget_button(wopen, value='BlViewer File (*.blv)', event_pro='blv_open_blv_event')
		wsave=widget_button(wfile, value='Save As...', event_pro='blv_save_event')
		wrefresh=widget_button(wfile, value='Reload', event_pro='blv_refresh1_event')
		wPrint=widget_button(wfile, value='Print...',/SEPARATOR, event_pro='blv_print_event')

		wImage=widget_button(wfile, value='Grab picture', event_pro='blv_picture_event')
		wclose=widget_button(wfile, value='Quit',/SEPARATOR, event_pro='blv_close_event')
	wedit=widget_button(bar, value='Edit', /MENU)
		wdelete=widget_button(wedit, value='Delete optical module', event_pro='blv_delete_event')
		woptical_module=widget_button(wedit, value='Add optical module...', event_pro='blv_add_optical_module_event')
	wview=widget_button(bar, value='View',/MENU)
		wperspective=widget_button(wview,uvalue='0',value='Perspective', event_Pro='blv_change_view_event')
		wXY=widget_button(wview,value='Top View (X/Y)',uvalue='1', event_Pro='blv_change_view_event')
        wXZ=widget_button(wview,value='Side View (Y/Z)',uvalue='2', event_Pro='blv_change_view_event')
        wYZ=widget_button(wview,value='Front View (X/Z)',uvalue='3', event_Pro='blv_change_view_event')
        wCustomPerspective=widget_button(wview, value='Perspective...',uvalue='4', event_pro='blv_change_view_event')
		wlinear=widget_button(wview,uvalue='Linear', value='Linear', event_Pro='blv_scale_event',/SEPARATOR)
		wlog=widget_button(wview, uvalue='Logarithmic', value='Logarithmic', event_Pro='blv_scale_event')
		wfram=widget_button(wview, uvalue='Frame', value='Frame', event_pro='blv_opa_fram_event',/SEPARATOR)
		wopa=widget_button(wview, uvalue='Opaque', value='Opaque', event_pro='blv_opa_fram_event')
	wshow=widget_button(bar, value='Show',/MENU)
		wshow_symbol=widget_button(wshow, uvalue='Optical Elements', value='Optical Elements',event_Pro='blv_show_event')
		wshow_axis=widget_button(wshow,uvalue='Optical Axis', value='Optical Axis', event_Pro='blv_show_event')
;srio		wshow_plane_source=widget_button(wshow, uvalue='Continuation Planes Source', value='Continuation Planes Source', event_Pro='blv_show_event')
;srio		wshow_plane_image=widget_button(wshow, uvalue='Continuation Planes Image', value='Continuation Planes Image', event_Pro='blv_show_event')

		wshow_normal=widget_button(wshow, uvalue='O.E. Normals', value='O.E. Normals', event_Pro='blv_show_event')
		wshow_axes_element=widget_button(wshow, uvalue='O.E. Frame Axes', value='O.E. Frame Axes', event_Pro='blv_show_event')
	woption=widget_button(bar, value='Option',/MENU)
		wcolor=widget_button(woption, value='Background Colors...',event_pro='blv_colors_event')
	wAnimate=widget_button(bar, value='Animate',/MENU)
		wrotation=widget_button(wAnimate, value='Rotation (start/stop)', event_pro='blv_animate_rot_event')
		wrays=widget_button(wAnimate, value='Rays (start/stop)', event_pro='blv_animate_rays_event')
;		wMpeg=widget_button(wAnimate, value='MPEG', /separ, event_pro='blv_animate_rays_MPEG_event' )

	wHelp=widget_button(bar, value='Help',/MENU,/Help)
		wtmp=widget_button(wHelp, value='Help...',event_pro='blv_help_event')
		wtmp=widget_button(wHelp, value='About...',event_pro='blv_about_event')

	wbase_button=widget_base(tbl,/row,frame=1)
		wquitB=widget_button(wbase_button, value='Quit', event_Pro='blv_close_event')
;		wrefreshB=widget_button(wbase_button, value='Reload', event_Pro='blv_refresh_event')
		wrefreshB1=widget_button(wbase_button, value='Reload', event_pro='blv_refresh1_event')
		wSourceB=widget_button(wbase_button, value='Source', event_pro='blv_open_frame_event')
		wModuleB=widget_button(wbase_button, value='Module', event_pro='blv_open_frame_event')
		wRaysB=widget_button(wbase_button, value='Rays', event_pro='blv_open_frame_event')
		wGlobalB=widget_button(wbase_button, value='Global Controls', event_pro='blv_open_frame_event')
		;dimensions of window
IF N_Elements(xsize) EQ 0 THEN xsize = 500
IF N_Elements(ysize) EQ 0 THEN ysize = 400

wdraw=widget_draw(tbl, XSIZE=xsize, YSIZE=ysize, $
     GRAPHICS_LEVEL=2, /BUTTON_EVENTS, /MOTION_EVENTS, /EXPOSE, event_pro='blv_track_event')


;=========================

wstatut=widget_label(tbl,value='Loading...',/ALIGN_LEFT,xsize=500,ysize=17)
otrackball = OBJ_NEW('Trackball', [xsize/2.,ysize/2.], xsize/2.)

widget_control, tbl, /realize

;graphics' items
omodel=obj_new('idlgrmodel', name='Model')
omodelLight=obj_new('idlgrmodel')

olight=obj_new('idlgrlight',location=[0,0,1000000],type=1)

oview=obj_new('idlgrview',color=[100,100,100],PROJECTION=1)

oview->add, omodel
oview->add, omodelLight

omodelLight->add, oLight
widget_control, wdraw, get_value=window

; structure data
system=obj_new('optical_system')
system->getProperty, oModel=model
omodel-> add, model
position=-1
file_name=string('')
config_File=string('blviewer.config')
zoom=1.
PerspectiveAngle=[203,220,56]
printer=obj_new('idlGrPrinter', GRAPHICS_TREE=oview)
IF Not(Keyword_Set(end_file)) THEN end_file=0

data={	system:system, $
		position:position, $
		last_file_name:file_name, $
		end_file:end_file, $
		rays_file:0, $
		zoom:zoom, $
		PerspectiveAngle:PerspectiveAngle, $
		flagAnimateRot:0, $
		flagAnimateRays:0, $
		evolutionTrace:100., $
		flagTrack:0, $
		flagAnimateMovie:0, $
		trackX:0., $
		trackY:0., $
		config_File:config_File, $
		scr_size:[xSize,ySize] $
	}

; structure wid

wid={	tbl:tbl, $
		log:wlog, $
		linear:wlinear, $
		draw:wdraw, $
		statut:wstatut, $

		wSource:tbl,$
		wModule:tbl, $
		wRays:tbl, $
		wGlobal:tbl, $
		wPlanes:tbl, $

		view:oview,$
		window:window, $
		model:omodel, $
		trackball:otrackball, $
		printer:printer, $
		player:tbl $
	}

pInfo=ptr_new({ data:data, $
				wid:wid $
				})
widget_control, tbl, set_uvalue=pInfo,/no_copy
widget_control, tbl, get_uvalue=pInfo


(*pInfo).wid.model->rotate, [1,0,0], (*pInfo).data.PerspectiveAngle[0]
(*pInfo).wid.model->rotate, [0,1,0], (*pInfo).data.PerspectiveAngle[1]
(*pInfo).wid.model->rotate, [0,0,1], (*pInfo).data.PerspectiveAngle[2]
blv_center_view, pInfo
window->draw, oview


widget_control, wid.statut, set_value='Ready.'
xmanager, 'BLViewer', tbl, /no_block

if n_elements(file_default) ne 0 then begin
 	widget_control, (*pInfo).wid.statut, set_value='Waiting...'
	; only for idl > 5.4 	if file_test( file_default) then blv_open_optical_system, pInfo, file_default $
 	IF CheckFile( file_default) THEN BEGIN
	  blv_open_optical_system, pInfo, file_default, End_File=end_File
	  blv_refresh1_event,{top:tbl},/NoLoad ; added by srio
	  widget_control, wid.statut, set_value='Read system from file: '+file_default+'  Ready.'
 	ENDIF ELSE BEGIN
          ;tmp = Dialog_Message(Dialog_Parent=tbl,'File with systemfile not found: '+file_default)
	  RETURN
	ENDELSE
endif else begin
	IF keyword_set(config_file_flag) THEN $
	blv_read_config, pInfo,Group=tbl
	blv_refresh1_event,{top:tbl} ; added by srio
endelse

end
