FUNCTION shswapcols,a0,newcols,file=file

;+
; NAME:
;	SHSWAPCOLUMNS
; PURPOSE:
;	This function swap the columns of a Shadow file/structure 
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	result = shSwapColumns(shadow_in,newcolumns)
; INPUTS:
;	shadow_in: The IDL structure with SHADOW data
;	newcolumns:  a 3-element array with the new columns
;		(example [3,2,1])
; OUTPUTS:
;	 Result: The IDL/Shadow structure of the transformed beam
; KEYWORD PARAMETERS (OUTPUT):
;	FILE = set this keyword to a string with the file name for
;       writing the transformed beam.
;
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble May 2007
;
;-

IF N_ELEMENTS(newcols) NE 3 THEN newcols=[1,2,3]
;
;
;

a0=readsh(a0)
a=a0
ray=a.ray
ray1=ray

idiff = newcols-[1,2,3]
idiffx = idiff[0]
idiffy = idiff[1]
idiffz = idiff[2]

cols = [1,2,3]-1
xcol = cols[0]
ycol = cols[1]
zcol = cols[2]
print,'old->new: ',cols,cols+idiff
ray1[xcol+idiffx,*] =  ray[xcol,*]
ray1[ycol+idiffy,*] =  ray[ycol,*]
ray1[zcol+idiffz,*] =  ray[zcol,*]

cols = [4,5,6]-1
xcol = cols[0]
ycol = cols[1]
zcol = cols[2]
print,'old->new: ',cols,cols+idiff
ray1[xcol+idiffx,*] =  ray[xcol,*]
ray1[ycol+idiffy,*] =  ray[ycol,*]
ray1[zcol+idiffz,*] =  ray[zcol,*]

cols = [7,8,9]-1
xcol = cols[0]
ycol = cols[1]
zcol = cols[2]
print,'old->new: ',cols,cols+idiff
ray1[xcol+idiffx,*] =  ray[xcol,*]
ray1[ycol+idiffy,*] =  ray[ycol,*]
ray1[zcol+idiffz,*] =  ray[zcol,*]

cols = [16,17,18]-1
xcol = cols[0]
ycol = cols[1]
zcol = cols[2]
print,'old->new: ',cols,cols+idiff
ray1[xcol+idiffx,*] =  ray[xcol,*]
ray1[ycol+idiffy,*] =  ray[ycol,*]
ray1[zcol+idiffz,*] =  ray[zcol,*]

a.ray=ray1

IF Keyword_Set(file) THEN putrays,a,file
RETURN,a

END



