;+
;
;Purpose :this function made an image thanks to an XOP file
;
;-
function make_image, file=file,image=image, sizei=sizei, x=x, y=y, xrange=xr, yrange=yr, show=show


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'make_image: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


	if n_elements(show) eq 0 then show=0
	if n_elements(sizei) eq 0 then sizei=250
	if n_elements(x) eq 0 then x=0
	if n_elements(y) eq 0 then y=2
	if n_elements(image) eq 0 then begin
		tab=getshcol(file,[1,2,3],/nolost)
	endif else begin
		tab=image
	endelse
	if n_elements(xr) eq 0 then begin
		xmin=min(tab[x,*])
		xmax=max(tab[x,*])
	endif else begin
		xmin=xr[0]
		xmax=xr[1]
	endelse
	if n_elements(yr) eq 0 then begin
		ymin=min(tab[y,*])
		ymax=max(tab[y,*])
	endif else begin
		ymin=yr[0]
		ymax=yr[1]
	endelse
	im=uintarr(sizei,sizei)
	nb_ray=(size(tab))[2]
	print, size(tab)
	for r=0, nb_ray-1	do begin
		point=[tab[x,r],tab[y,r]]
		point[0]=(point[0]-xmin)*((sizei-1)/(xmax-xmin))
		point[1]=(point[1]-ymin)*((sizei-1)/(ymax-ymin))
		i=uint(point[0])
		j=uint(point[1])
		if (i lt sizei) and (j lt sizei)  then $
			im[i,j]=im[i,j]+1
	endfor

	maxi=max(im)
	im=im*(255./maxi)

	if show eq 1 then begin
		image=obj_new('idlgrimage',im,/greyscale)
		model=obj_new('idlgrmodel')
		model->add, image
		view=obj_new('idlgrview')
		view->add, model
		view->setProperty, VIEWPLANE_RECT=[0,0,sizei,sizei]
		win=obj_new('idlgrwindow')
		win->draw, view
		obj_destroy, view
	endif
	return, im
end
