;+
; NAME:
;       blv_global_control
;
; PURPOSE:
;       This function creates and returns a widget base with all the widget 
;	element necessary to control
;	the global propertys of the current optical system.
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;		wBase=blv_global_control, pInfo
;
; INPUTS:
;       pInfo: A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, 2001
;-

;
;===============================================================================
;
;purpose : this procedure closes the widget
pro blv_global_control_close, pInfo


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_global_control_close: error caught: '+!error_state.msg)
   RETURN
ENDIF


	temp=(*pInfo).wid.wGlobal
	(*pInfo).wid.wGlobal=(*pInfo).wid.tbl

	widget_control, temp, /destroy
end

;
;===============================================================================
;
pro blv_global_control_flipShow_event, event
;purpose : this procedure defines all the binary operations on widget 
;	of type Show/Paste

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_global_control_flipShow_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


widget_control, event.id, get_uvalue=button
widget_control, event.top, get_uvalue=info
case button of
	'optical element':begin
	 	(*info.pInfo).data.system->flip, /show_symbol
		end
	'optical axes':begin
	 	(*info.pInfo).data.system->flip, /show_axis
		end
	'ScreenSlitPlanes':begin
		(*info.pInfo).data.system->flip, /show_plane_source
		(*info.pInfo).data.system->flip, /show_plane_image
		(*info.pInfo).data.system->flip, /show_plane_added
		end
	'o.e normal': begin
		(*info.pInfo).data.system->flip, /show_normal
		end
	'o.e axes': begin
		(*info.pInfo).data.system->flip, /show_axes_element
		end
	else: return
endcase
(*info.pInfo).data.system->trace
blv_draw_system, info.pInfo
end


;
;===============================================================================
;
pro blv_global_control_planes_event, event
;purpose : controls the show/hide option of the optical planes


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_global_control_planes_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


widget_control, event.id, get_uvalue=button
widget_control, event.top, get_uvalue=info

case button of
	'show':begin
		(*info.pInfo).data.system->setProperty, show_plane_added=0
		end
	'hide':begin
		(*info.pInfo).data.system->setProperty, show_plane_added=1
		end
endcase
if (*info.pInfo).wid.wPlanes ne (*info.pInfo).wid.tbl then begin
	blv_planes_control_print_property, info
endif

(*info.pInfo).data.system->trace
blv_draw_system, info.pInfo
end

;
;===============================================================================
;
PRO blv_global_control_event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_global_control_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


widget_control, event.top, get_uvalue=info

IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN BEGIN
	blv_global_control_close, info.pInfo
	return
ENDIF

widget_control, event.id, get_uvalue=uvalue

CASE uvalue OF
	'wViewGroup':begin
			widget_control, (*info.pInfoGlobal).wViewGroup, $
				get_value=index
			blv_change_view, info.pInfo, index
			blv_draw_system, info.pInfo
			end
	'dimScale':begin
			widget_control, (*info.pInfoGlobal).wDimension, $
				get_value=dimScale
			(*info.pInfo).data.system->setProperty, $
				dimension_scale=dimScale
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'distScale':begin
			widget_control, (*info.pInfoGlobal).wDistance, $
				get_value=distScale
			(*info.pInfo).data.system->setProperty, $
				distance_scale=distScale
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'zoom':begin
			widget_control, (*info.pInfoGlobal).wZoom, $
				get_value=Zoom
			(*info.pInfo).data.zoom=zoom
			blv_center_view, info.pInfo
			blv_draw_system, info.pInfo
			end
	'wScaleGroup':begin
			widget_control, (*info.pInfoGlobal).wScaleGroup, $
				get_value=index
			(*info.pInfo).data.system->setProperty, log=index
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'wOEGroup':begin
			widget_control, (*info.pInfoGlobal).wOEGroup, $
				get_value=trans
			(*info.pInfo).data.system->setProperty, $
				transparen=abs(trans-1)
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'normalScale':begin
			widget_control, (*info.pInfoGlobal).wNormalScale, $
				get_value=scale
			(*info.pInfo).data.system->setProperty, $
				normal_scale=scale
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'oeAxesScale':begin
			widget_control, (*info.pInfoGlobal).wOeAxesScale, $
				get_value=scale
			(*info.pInfo).data.system->setProperty, $
				axes_element_scale=scale
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'distEqual':begin
			widget_control, (*info.pInfoGlobal).wEqual, $
				set_button=1 ; added srio
			widget_control, (*info.pInfoGlobal).wDistEqual, $
				get_value=equalValue
			(*info.pInfo).data.system->setProperty, $
				distEqual=abs(equalValue), $
			flagEqual=1 ; srio added from $
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end

;	'blv_global_control_change_view_event': BEGIN
;				;purpose : Calls a procedure to change the view with the selected view.
;				widget_control, event.top, get_uvalue=info
;				widget_control, event.id, get_uvalue=button
;				blv_change_view, info.pInfo, button
;				blv_draw_system, info.pInfo
;			END
	'blv_global_control_customview_event': BEGIN
			;purpose : Calls the procedure to custmize the 
			;	perspective view
			widget_control, event.top, get_uvalue=info
			blv_change_view, info.pInfo, 0
			widget_control, (*info.pinfoGlobal).wViewGroup, $
				set_value=0
			blv_draw_system, info.pInfo
			blv_change_view, info.pInfo, '4'
			blv_draw_system, info.pInfo
			END
	'blv_global_control_done_event': BEGIN
			;purpose : this procedure calls the procedure to 
			;	close the widget
			widget_control, event.top, get_uvalue=info
			blv_global_control_close, info.pInfo
			END

	'blv_global_control_color_optical_axes': BEGIN
			;purpose : the five next procedures make possible to 
			;	change the color of elements
			widget_control, event.top, get_uvalue=info
			(*info.pInfo).data.system->getProperty, $
				optical_axes_color=color
			dim=Get_RGB((*info.pInfoGlobal).wBase, rgb=color)
			if dim.ok eq 1 then $
				(*info.pInfo).data.system->setProperty, $
				optical_axes_color=dim.rgb
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			END
	'blv_global_control_color_plane_event': BEGIN
			widget_control, event.top, get_uvalue=info
			(*info.pInfo).data.system->getProperty, $
				optical_plane_color=color
			dim=Get_RGB((*info.pInfoGlobal).wBase, rgb=color)
			if dim.ok eq 1 then $
				(*info.pInfo).data.system->setProperty, $
				optical_plane_color=dim.rgb
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			END
	'blv_global_control_color_normal': BEGIN
			widget_control, event.top, get_uvalue=info
			(*info.pInfo).data.system->getProperty, $
				normal_color=color
			dim=Get_RGB((*info.pInfoGlobal).wBase, rgb=color)
			if dim.ok eq 1 then $
				(*info.pInfo).data.system->setProperty, $
				normal_color=dim.rgb
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			END
	'blv_global_control_color_oe_axes': BEGIN
			widget_control, event.top, get_uvalue=info
			(*info.pInfo).data.system->getProperty, $
				axes_element_color=color
			dim=Get_RGB((*info.pInfoGlobal).wBase, rgb=color)
			if dim.ok eq 1 then $
				(*info.pInfo).data.system->setProperty, $
				axes_element_color=dim.rgb
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			END
	'blv_global_control_color_optical_element': BEGIN
			widget_control, event.top, get_uvalue=info
			(*info.pInfo).data.system->getProperty, $
				optical_element_color=color
			dim=Get_RGB((*info.pInfoGlobal).wBase, rgb=color)
			if dim.ok eq 1 then $
				(*info.pInfo).data.system->setProperty, $
				optical_element_color=dim.rgb
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			END
	'blv_global_control_source_event': BEGIN
			;purpose: call the widget base used to control 
			;	the source
			widget_control, event.top, get_uvalue=info
			if (*info.pInfo).wid.wsource eq (*info.pInfo).wid.tbl $
				then  (*info.pInfo).wid.wSource= $
				blv_Source_control(info.pInfo)
			END
	'blv_global_control_flipEqual_event': BEGIN
			;purpose: change the equal distance option for 
			;	the system
			widget_control, event.top, get_uvalue=info
			(*info.pInfo).data.system->getProperty, $
				flagEqual=flagEqual
			widget_control, (*info.pInfoGlobal).wDistEqual, $
				get_value=distEqual
			(*info.pInfo).data.system->setProperty, $
				flagEqual=abs(flagEqual-1), $
				distEqual=abs(distEqual)
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			END

	else: print,'CASE not found: '+uValue
ENDCASE

END


;
;===============================================================================
;
FUNCTION blv_global_control, pInfo
;purpose: define the widget base

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_global_control: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


(*pInfo).data.system->getProperty, dimension_Scale=dimScale, $
								distance_Scale=distScale

wBase=widget_base(GROUP_LEADER=(*pInfo).wid.tbl,title='Global Controls',/col, /TLB_KILL_REQUEST_EVENTS, $
				event_pro='blv_global_control_event', /floating)
	;
	; global sliders
	;
	wButton=widget_base(wBase,/row)
		wDone=widget_button(wButton, value='Dismiss',UValue='blv_global_control_done_event')
	wScale=widget_base(wBase,title='Scale',/frame,/col)
		wScaleDim=widget_base(wScale,/row,/ALIGN_RIGHT)
			wtitleDim=widget_label(wScaleDim, value='Dimension Scale : ')

			if dimscale gt 4. then maximum=dimscale else maximum=4.
			wDimension=CW_FSlider1(wScaleDim,minimum=0.001,maximum=maximum, $
				value=dimScale, uvalue='dimScale', /edit,/Reset,XSize=175)
;			wreset=widget_button(wScaleDim,value='Reset',uvalue='dimension', $
;							event_pro='blv_global_control_resetScale_event')

		wScaleDis=widget_base(wScale,/row,/ALIGN_RIGHT)
			wtitleDis=widget_label(wScaleDis, value='Distance Scale : ')
			if distscale gt 4. then maximum=distscale else maximum=4.
			wDistance=CW_FSlider1(wScaleDis,minimum=0.001,maximum=maximum, $
				value=distScale, uvalue='distScale', /edit, /Reset,XSize=175)
;			wreset=widget_button(wScaleDis,value='Reset',uvalue='distance', $
;							event_pro='blv_global_control_resetScale_event')

		wScaleZoom=widget_base(wScale,/row,/ALIGN_RIGHT)
			wtitleZoom=widget_label(wScaleZoom, value='Zoom Scale: ')
			if (*pInfo).data.zoom gt 4. then maximum=(*pInfo).data.zoom else maximum=4.
			wZoom=CW_FSlider1(wScaleZoom,minimum=0.001,maximum=maximum, $
				value=(*pInfo).data.zoom, uvalue='zoom', /edit, /reset,XSize=175)
;			wreset=widget_button(wScaleZoom,value='Reset',uvalue='zoom', $
;							event_pro='blv_global_control_resetScale_event')

	;
	; view
	;
	radioView=['Perspective','Top View (X/Y)','Side View (Y/Z)', 'Front View (X/Z)']

	wView=widget_base(wBase,/row,/frame)
		wtextView=widget_label(wView, value='View    ')
		wViewChoice=widget_base(wView,/col)
    		wViewGroup=CW_BGROUP(wViewChoice, radioView, $ ; srio  SET_VALUE=0, $
			/Col,/RETURN_INDEX, /EXCLUSIVE, /NO_RELEASE, uValue='wViewGroup')
        	wCustomPerspective=widget_button(wviewChoice, value='Perspective...', $ ; uvalue='4', $
			UValue='blv_global_control_customview_event')
		Widget_Control,wCustomPerspective,Set_Button=4

	;
	; scale 
	;
	radioScale=['Linear','Logarithmique']
	(*pInfo).data.system->getProperty, log=log, distEqual=distEqual, flagEqual=flagEqual
	wScale=widget_base(wBase,/row,/frame)
	  wtextScale=widget_label(wScale, value='Scale    ')
	  wScaleChoice=widget_base(wScale,/col)
    	    wScaleGroup=CW_BGROUP(wScaleChoice, radioScale, SET_VALUE=log,  /row,/RETURN_INDEX, /EXCLUSIVE, $
                    	    /NO_RELEASE, uValue='wScaleGroup')
          wtempBase=widget_base(wScale, /NONEXCLUSIVE)
    	    wEqual=widget_button(wtempBase,value='Equal to:', UValue='blv_global_control_flipEqual_event')
    	  wDistEqual=cw_field(wScale, title=' ',value=distEqual, /floating, xsize=8,/return_event, $
		uValue='distEqual')
    	widget_control, wEqual, set_button=flagEqual

	;
	; source
	;
	wSource=widget_button(wBase, value='Source controls...',scr_xsize=200,/align_center, $
	UValue='blv_global_control_source_event')

	;
	; OE/modules controls
	;
	wShow=widget_base(wBase,/col,/frame,/base_align_right)
		(*pInfo).data.system->getProperty, show_axis=show_axis, $
				show_plane=show_plane, $
				show_normal=show_normal, $
				show_symbol=show_element, $
				show_axes_element=show_axes_element, $
				transparen=trans

		wShowBin = WIDGET_BASE(wShow, /column)
			; 
			; OE
			;
			wtempBase=widget_base(wShowBin,/row,/align_right)
				wtextOE=widget_label(wtempBase, value='Optical Element    ')
				wtempCheck=widget_base(wtempBase,/NONEXCLUSIVE)
				  wElement=WIDGET_BUTTON(wtempCheck, VALUE='Show/Hide', $
					uvalue='optical element', EVENT_PRO='blv_global_control_flipShow_event')
				  widget_control, wElement, set_button=abs(show_element-1)

				radioOE=['Frame', 'Opaque' ]
				wOEChoice=widget_base(wtempBase,/col)
    				  wOEGroup=CW_BGROUP(wOeChoice, radioOe, SET_VALUE=abs(trans-1), $
                	        	/row,/RETURN_INDEX, /EXCLUSIVE, /NO_RELEASE, uValue='wOEGroup')

				wColor=widget_button(wtempBase, value='Color...', $
					UValue='blv_global_control_color_optical_element')


			; 
			; Axes
			;
			wtempBase=widget_base(wShowBin,/row,/align_right)
				wTitle=widget_label(wtempBase,value='Optical Axes    ',/Align_Left)
				wtempCheck=widget_base(wtempBase,/NONEXCLUSIVE)
        				wOpticalAxes = WIDGET_BUTTON(wtempCheck, VALUE='Show/Hide', $
                        		  uvalue='optical axes', EVENT_PRO='blv_global_control_flipShow_event')
					widget_control, wOpticalAxes, set_button=abs(show_axis-1)
				wtemp=widget_base(wtempBase,XSIZE=150) ; for alignment purposes
				wColor=widget_button(wtempBase, value='Color...', $
					UValue='blv_global_control_color_optical_axes')

			; 
			; Sreens
			;
			wtempBase=widget_base(wShowBin,/row,/align_right)
			  wTitle=widget_label(wtempBase,value='Screen/Slit Planes')
			  wShowPlanes = WIDGET_BUTTON(wtempBase, VALUE='Show', uvalue='show', $
                        	EVENT_PRO='blv_global_control_planes_event')
            		  wHidePlanes = WIDGET_BUTTON(wtempBase, VALUE='Hide', uvalue='hide', $
                        	EVENT_PRO='blv_global_control_planes_event')
			  wtemp=widget_base(wtempBase,XSIZE=150) ; for alignment purposes
			  wColor=widget_button(wtempBase, value='Color...', $
				UValue='blv_global_control_color_plane_event')

			; 
			; Normal
			;
			wtempBase=widget_base(wShowBin,/row,/align_right)
			  wTitle=widget_label(wtempBase,value='OE Normal')
			  wtempCheck=widget_base(wtempBase,/NONEXCLUSIVE)
			  wNormal = WIDGET_BUTTON(wtempCheck, VALUE='Show/Hide', uvalue='o.e normal', $
                        	EVENT_PRO='blv_global_control_flipShow_event')
			widget_control, wNormal, set_button=abs(show_normal-1)
			(*pInfo).data.system->getProperty, normal_scale=value

			  wtemp=widget_base(wtempBase,XSIZE=75) ; for alignment purposes
			  wNormalScale=CW_Field(wtempBase, title='Scale : ', value=value, $
				uvalue='normalScale', xsize=4, /return_event)
			  wColor=widget_button(wtempBase, value='Color...', $
				UValue='blv_global_control_color_normal')

			; 
			; Reference frame axes
			;
			wtempBase=widget_base(wShowBin,/row,/align_right)
			  wTitle=widget_label(wtempBase,value='OE frame axes')
			  wtempCheck=widget_base(wtempBase,/NONEXCLUSIVE)
			  wAxesElement = WIDGET_BUTTON(wtempCheck, VALUE='Show/Hide', uvalue='o.e axes', $
                        	EVENT_PRO='blv_global_control_flipShow_event')
			wtemp=widget_base(wtempBase,XSIZE=70) ; for alignment purposes
			widget_control, wAxesElement, set_button=abs(show_axes_element-1)
			(*pInfo).data.system->getProperty, axes_element_scale=value
			wOeAxesScale=CW_Field(wtempBase, title='Scale : ', $
				value=value, uvalue='oeAxesScale', xsize=4, /return_event)
			  wColor=widget_button(wtempBase, value='Color...', $
				UValue='blv_global_control_color_oe_axes')



pInfoGlobal=ptr_new({wBase:wBase, $
			wDimension:wDimension, $
			wDistance:wDistance, $
			wZoom:wZoom, $
			wViewGroup:wViewGroup, $
			wScaleGroup:wScaleGroup, $
			wOEGroup:wOEGroup, $
			wOpticalAxes:wOpticalAxes, $
			wNormal:wNormal, $
			wAxesElement:wAxesElement, $
			wElement:wElement, $
			wNormalScale:wNormalScale, $
			wOeAxesScale:wOeAxesScale, $
			wDistEqual:wDistEqual, $
			wEqual:wEqual $
			 })
info={pInfoGlobal:pInfoGlobal, pInfo:pInfo}

widget_control, wBase, set_uValue=info
widget_control, wBase, /realize
xmanager, 'blv_global_control', wBase, /no_block

return, wBase
END
