# 
# SHADOW 2.3.3 startup file for SH/KSH/BASH (Bourne shell family) users 
# on Unix. You can safely call this file from your $HOME/.profile file.
# Insert:
#     . /usr/local/shadow-2.3.3/.shadowrc.sh
# at the end of .profile file.
#
# Author: Mumit Khan <khan@xraylith.wisc.edu>
#
# Created: 05-Oct-02
#

# Defines the environment variables needed to run SHADOW/Unix. The only
# variable that HAS to be defined is SHADOW_ROOT, unless you install
# SHADOW in the same directory where it was installed at CXrL. The other
# one, depending on your installation directory, is LD_LIBRARY_PATH or
# equivalent (see below).
#
# Note the quotes ("") around variable values. These are important only
# when you have embedded spaces in pathnames, otherwise no effect.


SHADOW_ROOT=$XOP_HOME/extensions/shadowvui/shadow-2.3.3-darwin
export SHADOW_ROOT 

if test -z "$DISPLAY"; then
  DISPLAY=0:0.0
  export DISPLAY
fi

#
# some systems will require that you set LD_LIBRARY_PATH (or equivalent,
# such as SHLIB_PATH on HP-UX and LIBPATH on AIX) to resolve shared 
# libraries needed by SHADOW programs.  But do check if the variable 
# already exists, and if so, prepend to the current library path.
#
# If you installed the programs under /usr/local/shadow, you can safely
# comment these out.
#
DYLD_LIBRARY_PATH="${SHADOW_ROOT}/lib":${DYLD_LIBRARY_PATH}
export DYLD_LIBRARY_PATH

# The following variables are inferred from $SHADOW_ROOT set above. Change 
# or uncomment only if you move the data files out of $SHADOW_ROOT/data
# directory. Also uncomment the appropriate 'export' directive below.
# 
#SHADOW_DATA_DIR=$SHADOW_ROOT/data
#SHADOW_MENU_FILE=$SHADOW_ROOT/data/shadow.men
#PLFONTS=$SHADOW_ROOT/data/
#export SHADOW_DATA_DIR
#export SHADOW_MENU_FILE 
#export PLFONTS

#added by srio@esrf.fr to allow runnin id's without using make_id
SHADOW_ENV_FILE="/tmp/shadow-env-${USER}"
export SHADOW_ENV_FILE

#
# the default format for START.* files is FORTRAN Namelist format, which
# is typically not portable among various machines/compilers. The other
# choice is GFILE, which is a simple text file of 'name = value' pairs
# and is portable. The default is GFILE; if you want something else to
# be the default, uncomment the appropriate line below as well as the
# export directive below.
#

#SHADOW_START_FORMAT=GFILE
#SHADOW_START_FORMAT=FORTRAN
#export SHADOW_START_FORMAT

#
# Add SHADOW programs to your shell search PATH. Unless you like typing
# in full pathnames for each program, I suggest you keep this.
#
PATH="$SHADOW_ROOT/bin":$PATH
export PATH

