rem @echo off

rem *** Startup batch file (xop.bat) for XOP using IDL on Windows.
rem *** Use local variables to limit the scope, i.e., will not affect the parent shell.
rem *** Customizations are needed to the XOP_HOME and the IDL_DIR environmental variables.
rem *** Roger J. Dejus, ASD/APS, September 28, 2007.
rem *** Modified srio@esrf.eu: Use XOP_HOME=%cd%\  to avoid customization!

setlocal
rem Define environmental variables for code XOP


rem set XOP_HOME directory
set XOP_HOME=%cd%\

rem Set IDL directory
set IDL_DIR=%XOP_HOME%\IDL70win


rem Set IDL_PATH
rem Note the escape character (^) before the special characters
rem set IDL_PATH=^<IDL_DEFAULT^>;%XOP_HOME%
set IDL_PATH=^<IDL_DEFAULT^>

rem Set XOP_TASK
rem XOP_TASK is obtained from the first command line parameter if present (overrides the env. variable)
rem Uses the default only if the first parameter is absent and the environmental variable XOP_TASK is not set on entry
set XOP_TASK_DEFAULT=xop
if not (%1) == () (set XOP_TASK=%1) else if (%XOP_TASK%) == () (set XOP_TASK=%XOP_TASK_DEFAULT%)

rem Set XOP working directory
set XOP_WD=%XOP_HOME%\tmp

rem Set XOP start-up command
set IDL_BIN=%IDL_DIR%\bin\bin.x86
rem set XOP_COMMAND="%IDL_BIN%\idlrt" -em="%XOP_HOME%\xop.sav"
rem This command will start XOP without opening a DOS window (srio@esrf.eu 2008-09-22)
set XOP_COMMAND=start /d "%IDL_BIN%" /i idlrt -em="%XOP_HOME%xop.sav"

rem Print statements for debugging
rem echo %XOP_HOME%
rem echo %IDL_DIR%
rem echo "%IDL_PATH%"
rem echo %XOP_WD%
rem echo %XOP_TASK%
rem echo %XOP_COMMAND%
rem pause

rem Start XOP
%XOP_COMMAND%
endlocal
