;
;+
;
; =================================  xmckale      ============================
;
;   xmckale is a widget based graphical interface to interpolate
;   McKale XAFS phase shift tables (A G McKale, B W Veal, A P Paulikas,
;   S K Chan and G S Knapp, J. Amer. Chem. Soc. 110, (1999) 3763)
;
;   Data are taken from the DABAX data base.
;
; =========================================================================
;
; LAST MODIFICATION: msr/msr/99-02-18
;
;
;-
;	MODIFICATION HISTORY:
;       by  Manuel Sanchez del Rio. ESRF. August 1996.
;	99-02-18 adapted for xop 2.0. Included in XOP's extension XAID.
;
Function xmckale_version
return,'1.1'
end
;
;=====================================================================
;
;

function xmckale_calc,str,Group=group
;

Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!err_string
  itmp = Dialog_Message(/Error,Dialog_Parent=group,$
    'XMCKALE_CALC: '+'error caught: '+!error_state.msg)
  Catch, /Cancel
  RETURN,0
ENDIF
r = str.r ; 3.0
        dist = 1.0/4 - 1.0/2.5
        distx = 1.0/r - 1.0/2.5
zc = str.at1
z = str.at2
edge = str.edge( 1+fix(str.edge(0)) ) ; 'K'
h=dabax_access(dabax_pathf('XAFS_McKale.dat'),Group=group)
l = spec_access(h,/list)
index = where(l eq z) + 1
case edge of
 'K': begin
	index1 = index(0)
	index2 = index(1)
	end
 'L': begin
	index1 = index(2)
	index2 = index(3)
	end
endcase
data1 = spec_data(h,index1,/index)
print,'title1 : ',spec_name(h,index1,/index)
print,'title2 : ',spec_name(h,index2,/index)
data2 = spec_data(h,index2,/index)

if zc eq z then datac = data1 else begin
  if edge EQ 'K' then datac = spec_data(h,strcompress(zc,/rem)+'.1') $
	else datac = spec_data(h,strcompress(zc,/rem)+'.3')
  print,'titlec : ',spec_name(h,strcompress(zc,/rem)+'.3')
endelse

;print,'data1: ',data1
;print,'data2: ',data2
;print,'datac: ',datac

k = datac(0,*)
fc = datac(1,*)
f11 = data1(3,*)
f22 = data2(3,*)
m11 =  data1(2,*)
m22 =  data2(2,*)

f = f11 + (f22-f11)*(distx/dist) + fc
m = m11 + (m22-m11)*(distx/dist)

        step = 0.05d0
	k2 = findgen(401)*step

        f2 =  interpol(f,k,k2)
        m2 =  interpol(m,k,k2)

tmp = fltarr(4,n_elements(k2))
tmp(0,*) = k2
tmp(1,*) = m2*sin(f2+2.0*k2*r)
tmp(2,*) = m2
tmp(3,*) = f2

return,tmp
end

;=====================================================================
;
;
;=====================================================================
;
PRO xmckale_event,event

Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!err_string
  itmp = Dialog_Message(/Error,Dialog_Parent=event.top,$
    'XMCKALE_EVENT: '+'error caught: '+!error_state.msg)
  Catch, /Cancel
  GoTo,out
ENDIF
Widget_Control, event.id, get_UValue=eventUValue

if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''

stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy

case eventuvalue of
  'QUIT':begin	
	widget_control,/destroy,event.top
	return
	end
  'HELP':begin	
	WIDGET_CONTROL,/HOURGLAS
	xhelp,'xmckale',GROUP=event.top
	end
  'SET':begin	
	str1 = state.str.parameters
        helpdir = getenv('DABAX_HELP')
        if helpdir EQ '' then helpcmd=0 else begin
          ;if sdep() EQ 'WINDOWS' then helpcmd="xdisplayfile1,'"+$
          ;        helpdir+"\xmckale.par',group=event.top" else $
          ;        helpcmd="xdisplayfile1,'"+helpdir+$
          ;       "/xmckale.par',group=event.top"
          helpcmd="xdisplayfile1,'"+helpdir+sdep(/ds)+$
          "xmckale.par',group=event.top"
        endelse
  	XScrMenu,str1,/Interp,/NoType,action=action,Ncol=1, $
		titles=state.str.titles,flags=state.str.flags, $
		help=helpcmd
  	if  action EQ 'DONT' then goto,out
	tmp = xmckale_calc(str1,Group=event.top)
	IF N_Elements(tmp) EQ 1 AND tmp[0] EQ 0 THEN GoTo,out
	xplot,tmp,YCOL=2,group = event.top, coltitles = ['k[A^-1]',$
	 'chi','modulus','phase'],xtitle='-1',ytitle='-1', title=$
	 'McKale interpolated results for '+str1.edge(1+fix(str1.edge(0)))+ $
	 ' Edge; Zc='+strcompress(str1.at1,/rem)+$
	 ' Zscat='+strcompress(str1.at2,/rem)+ $
	 ' R='+ strcompress(str1.r,/rem)


	state.str.parameters = str1
	end
  else:
endcase

out:
Widget_Control, stateid, set_UValue=state, /No_Copy
end
;
;=======================================================================
;
PRO xmckale,GROUP=group



Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!err_string
  itmp = Dialog_Message(/Error,Dialog_Parent=event.top,$
    'XMCKALE: '+'error caught: '+!error_state.msg)
  Catch, /Cancel
  RETURN
ENDIF
;
wbase = widget_base(/COLUMN,TITLE='xmckale '+xMcKale_version(),$
	MBAR=wMenuBar)
;
;
; the blocks box
;
Bbox=widget_base(wbase,/Column) ; also to store state
 

;Menu bar
wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit', Uvalue= 'QUIT')
wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
  wtmp = WIDGET_BUTTON(wHelpMenu, VALUE='xMcKale', UVALUE='HELP')

tmp = widget_button(Bbox,VALUE='Set Parameters',UVALUE='SET')


if sdep() EQ 'WINDOWS' then $
font = 'VERDANA*BOLD*ITALIC*24' else $
font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

junk = WIDGET_LABEL( Bbox, FONT=font, VALUE='xMcKale')
junk = WIDGET_LABEL( Bbox, FONT=font, VALUE='XAFS phases (McKale)')


str = dabax_defaults('xmckale')
state = { str:str }

widget_control,Widget_Info(wbase,/Child),set_uvalue=state
widget_control,wbase,/REALIZE
xmanager,'xMcKale',wbase,GROUP=group
;
end
