pro POLSPL,x,y,w,npts,xl,xh,nr,c,nc
;+
; NAME:
;	POLSPL
;
; PURPOSE:
;
;	polynomial spline least squares fit to data points Y(I).
;	only the function and it's first derivative are matched at the knots,
;	in order to give more degrees of freedom in the fit.
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	POLSPL,x,y,w,npts,xl,xh,nr,c,nc,
;
; INPUTS:
;	X(i),i=1,npts           abscissas
;	Y(i),i=1,npts           ordinates
;	W(i),i=1,npts           weighting factor in least squares fit
;	fit minimizes the sum of w(i)*(y(i)-poly(x(i)))**2
;	if uniform weighting is desired, w(i) must be 1.
;	NPTS points in X,Y arrays.  XL,XH arrays contain NR adjacent ranges
;	over which to fit individual polynomials.  Array NC specifies
;	how many poly coeffs to use in each range.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	array C returns
;	all coeffs, the first NC(1) of which belong to the first range,
;	the second NC(2) of which belong to the second range, and so forth.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	Quite inefficient, because it uses a lot of loops inherited from
;	the Fortran code. However, for small set of data it is useful.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	(Translated from a Fortran Code)
;	The method here is to fit ordinary polynomials in X, not B-splines,
;	order to save space on a mini-computer.  This means that the
;	is rather poorly conditioned, and hence the limits on the
;	of the polynomial.  The method of solution is Lagrange's
;	multipliers for the knot constraints and gaussian
;	to solve the linear system.
;
; EXAMPLE:
;
;	POLSPL,X,Y,W,NPTS,XL,XH,NR,C,NC
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;-
;
; this subroutine is IDL translation of the fortran subroutine
; poslpl.for (found in the Frascati's package of EXAFS data analysis)
;
;
;
;	SUBROUTINE POLSPL(X,Y,W,NPTS,XL,XH,NR,C,NC)
;C
;C	POLYNOMIAL SPLINE LEAST SQUARES FIT TO DATA POINTS Y(I).
;C	ONLY THE FUNCTION AND IT'S FIRST DERIVATIVE ARE MATCHED AT THE KNOTS,
;C	IN ORDER TO GIVE MORE DEGREES OF FREEDOM IN THE FIT.
;C
;C	X(I),I=1,NPTS		ABSCISSAS
;C	Y(I),I=1,NPTS		ORDINATES
;C	W(I),I=1,NPTS		WEIGHTING FACTOR IN LEAST SQUARES FIT
;C			FIT MINIMIZES THE SUM OF W(I)*(Y(I)-POLY(X(I)))**2
;C			IF UNIFORM WEIGHTING IS DESIRED, W(I) MUST BE 1.
;C
;C	NPTS POINTS IN X,Y ARRAYS.  XL,XH ARRAYS CONTAIN NR ADJACENT RANGES
;C	OVER WHICH TO FIT INDIVIDUAL POLYNOMIALS.  ARRAY NC SPECIFIES
;C	HOW MANY POLY COEFFS TO USE IN EACH RANGE.  ARRAY C RETURNS
;C	ALL COEFFS, THE FIRST NC(1) OF WHICH BELONG TO THE FIRST RANGE,
;C	THE SECOND NC(2) OF WHICH BELONG TO THE SECOND RANGE, AND SO FORTH.
;C
;C	THE METHOD HERE IS TO FIT ORDINARY POLYNOMIALS IN X, NOT B-SPLINES,
;C	IN ORDER TO SAVE SPACE ON A MINI-COMPUTER.  THIS MEANS THAT THE
;C	FIT IS RATHER POORLY CONDITIONED, AND HENCE THE LIMITS ON THE
;C	DEGREE OF THE POLYNOMIAL.  THE METHOD OF SOLUTION IS LAGRANGE'S
;C	UNDETERMINED MULTIPLIERS FOR THE KNOT CONSTRAINTS AND GAUSSIAN
;C	ELIMINATION TO SOLVE THE LINEAR SYSTEM.
;C
;
on_error,2;
;
; few definitions
;
df = fltarr(26)  &  a = dblarr(36,37)  &  nbs = intarr(11)
xk = dblarr(10)  &  c = dblarr(36)  
j=0 &  i=0  &  ne_idl=0 & n = 0 & k = 0 & ibl = 0
ns = 0  &  ns1 = 0
;
for i=1,35 do begin
  C(I)=0.
  for j=1,36 do a(i,j) = 0.d0
endfor
;
N=0
NBS(1)=1
;
for i=1,nr do begin
  n=n+fix(nc(i))
  NBS(I+1)=N+1
  if (xl(i) lt xh(i)) then goto,ten
  T=XL(I)
  XL(I)=XH(I)
  XH(I)=T
  ten:
endfor
;
N=N+2*(NR-1)
N1=N+1
XL(NR+1)=0.
XH(NR+1)=0.
for ibl=1,nr do begin
  XK(IBL)=.5*(XH(IBL)+XL(IBL+1))
  if (xl(ibl) gt xl(ibl+1)) then xk(ibl)=.5*(xl(ibl)+xh(ibl+1))
  NS=NBS(IBL)
  ne_idl=nbs(ibl+1)-1
  for i=1,npts do begin
    if((x(i) lt xl(ibl)) or (x(i) gt xh(ibl))) then goto, thirty
    DF(NS)=1.0D0
    NS1=NS+1
    for j=ns1,ne_idl do df(j)=df(j-1)*x(i)
    for j=ns,ne_idl do begin
      for k=j,ne_idl  do begin 
        a(j,k)=a(j,k)+df(j)*df(k)*w(i)
      endfor
        a(j,n1)=a(j,n1)+df(j)*y(i)*w(i)
    endfor
    thirty:
  endfor
endfor
;
NCOL=NBS(NR+1)-1
NK=NR-1
if(nk eq 0) then goto, sixtysix
for ik=1,nk do begin
  NCOL=NCOL+1
  NS=NBS(IK)
  ne_idl=nbs(ik+1)-1
  A(NS,NCOL)=-1.D0
  NS=NS+1
  for i=ns,ne_idl  do a(i,ncol)=a(i-1,ncol)*xk(ik)
  NCOL=NCOL+1
  A(NS,NCOL)=-1.D0
  NS=NS+1
  if(ns gt ne_idl) then goto, fifty
  for i=ns,ne_idl  do a(i,ncol)=(ns-i-2)*xk(ik)^(I-NS+1)
  fifty:
  ncol=ncol-1
  NS=NBS(IK+1)
  ne_idl=nbs(IK+2)-1
  A(NS,NCOL)=1.D0
  NS=NS+1
  for i=ns,ne_idl do a(i,ncol)=a(i-1,ncol)*xk(ik)
  NCOL=NCOL+1
  A(NS,NCOL)=1.D0
  NS=NS+1
  if(ns gt ne_idl) then goto, sixtyfive
  for i=ns,ne_idl do begin
    a(i,ncol)=(i-ns+2)*xk(ik)^(i-ns+1)
  endfor
  sixtyfive:
endfor
;
sixtysix:
for i=1,n do begin
  I1=I-1
  for j=1,i1 do  a(i,j)=a(j,i)
endfor
;
NM1=N-1
for i=1,nm1 do begin
  I1=I+1
  M=I
  t=abs(a(i,i))
  for j=i1,n do begin
    if(t ge abs(a(j,i))) then goto, eighty
    M=J
    t=abs(a(j,i))
    eighty:
  endfor
  if(m eq i) then goto, ninety
  for j=1,n1 do begin
    T=A(I,J)
    A(I,J)=A(M,J)
    A(M,J)=T
  endfor
  ninety:
  for j=i1,n do begin
    T=A(J,I)/A(I,I)
    for k=i1,n1 do  a(j,k)=a(j,k)-t*a(i,k)
  endfor
endfor
;
C(N)=A(N,N1)/A(N,N)
;
for i=1,nm1 do begin
  NI=N-I
  T=A(NI,N1)
  NI1=NI+1
  for j=ni1,n do  t=t-c(j)*a(ni,j)
  c(ni)=t/a(ni,ni)
endfor
;
return
end
