function GETE0, setin,METHOD = method, SORT = sort, INDEX = imax, $
  DELTA_E0 = delta_e0, spl = spl
;
;+
; NAME:
;	GETE0
;
; PURPOSE:
;	This function calculates the Eo or edge of a xafs spectrum
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	my_e0 = GETE0 (myset)
;
; INPUTS:
;	set:	fltarr(2,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	METHOD:	0 Returns the maximum of the derivative (default)
;		1 The Eo is selected by the user using the mouse from
;		  the derivative shown
;	SORT:	When set, sorts and eliminates duplicated points prior
;		to the calculation. 
;
;       The  following keywords are only valid when METHOD=0: 
;
;	INDEX: set to a named variable to store the index of the 
;		point with E0. 
;	DELTA_E0: set to a named variable to store the indetermination
;		in e0 (i.e. if the e0 is found at the index point i, 
;		the indetermination is delta_e0=(x[i+1]-x[i-1])/2).
;	SPL: when set, performs a second iteration to get a better 
;		e0 value. For that, it makes either an interpolation or
;		a spline of the interval containing 21 points around
;		the first e0. The resulting interpolation/spline
;		contains 500 points. Use:
;		SPL=1 for interpolation method; and
;		SPL=2 for spline.
;
; OUTPUTS:
;	This function returns the Eo value
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	The Eo is calculated as the most important inflexion point
;	of the spectrum, that is the maximun value of the derivative
;
; EXAMPLE:
;
;		mye0 = gete0(myset)
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;	98-10-13 srio@esrf.fr adds sort keyword.
;	98-11-02 srio@esrf.fr uses catch, IDL function MAX, and
;	  introduce the keywords that are only valid when METHOD=0.
;-
;
;on_error,2
catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   if sdep(/w) then itmp = Dialog_Message(/Error,$
	'GETe0: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   return,0
endif
;
;print,' Calculating the derivative... '
set = setin
if keyword_set(sort) then begin
  good = uniq( set[0,*], sort(set[0,*]))
  set = fltarr(n_elements(setin[*,0]),n_elements(good))
  for i=0,n_elements(setin[*,0])-1 do set[i,*]=setin[i,good]
end
npts=n_elements(set(0,*))
tmp = deriv(set(1,*))
der=set
der(1,*)=tmp
;
; default mode: maximum of the derivative
;
IF NOT(Keyword_Set(method)) THEN BEGIN    ; default: max of the derivative
  imax=0L
  ymax = max(der[1,*],imax)
  xmax = der[0,imax]
  e0=xmax
  delta_e0 = (der[0,imax+1] - der[0,imax-1])/2.0

  IF Keyword_Set(spl) THEN BEGIN
    tmpnew = set[*,((imax-10) > 0):((imax+10) < npts-1)]
    nnn = N_Elements(tmpnew[0,*])
    xx = ((FindGen(500)/499.0)*(tmpnew[0,nnn-1]-tmpnew[0,0]))+tmpnew[0,0]
    IF spl EQ 1 THEN yy = Interpol(set[1,*],set[0,*],xx) ELSE $
      yy = Spline(set[0,*],set[1,*],xx)
    iimax=0L
    dder = Deriv(yy)
    ymax = max(dder,iimax)
    xmax = xx[iimax]
    e0=xmax
    delta_e0 = (dder[iimax+1] - dder[imax-1])/2.0
  ENDIF
;
; get the value with cursor
;
ENDIF ELSE BEGIN
  set_norm = set
  min1=min(set(1,*)) & max1=max(set(1,*))
  set_norm(1,*) = (set(1,*)-min1)/(max1-min1) + 0.4
  plotset,set_norm,yrange=[-.5,1.5]
;
  der_norm = der
  min1=min(der(1,*)) & max1=max(der(1,*))
  der_norm(1,*) = (der_norm(1,*)-min1)/(max1-min1) - 0.4
  plotset,der_norm,/over
;
  print,' Please, move the cursor until the selected value and click '
  cursor,tmp,tmp1,3
  e0 = tmp
ENDELSE
;
;print,' The selected Eo is:   ',e0
;
return,e0
end
