
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
PRO derivset,setin,der,plot=plot
;
;+
; NAME:
;	DERIVSET
;
; PURPOSE:
;	This procedure calculates the three first derivatives of
;	 a set of data
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	DERIVSET, setin,der
;
; INPUTS:
;	set:	fltarr(2,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	PLOT when set, plots the set and the first derivatives
;	on current graphics device
;
; OUTPUTS:
;	a 4-columns set of data with tha abscissas (1st column), the 
;	first (2nd column), second (3rd column) and fourth 
;	derivatives (4th col)
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	uses DERIV IDL's procedure
;
; EXAMPLE:
;
;		DERIVSET,setin,der,/plot
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	May, 1993	
;-
on_error,2
der1x=deriv(setin(0,*),setin(1,*))
der2x=deriv(setin(0,*),der1x)
der3x=deriv(setin(0,*),der2x)
der = fltarr(4,n_elements(setin(0,*)))
der(0,*) = setin(0,*)
der(1,*) = der1x
der(2,*) = der2x
der(3,*) = der3x
if keyword_set(plot) then begin
  if (plot eq 1) then begin
    set_norm = setin
    min1=min(setin(1,*)) & max1=max(setin(1,*))
    set_norm(1,*) = (setin(1,*)-min1)/(max1-min1) + 0.4
    plotset,set_norm,yrange=[-.5,1.5]
   ;
    der_norm = der1x
    min1=min(der1x) & max1=max(der1x)
    der_norm = (der_norm-min1)/(max1-min1) - 0.4
    oplot,setin(0,*),der_norm
  endif else begin
    set_norm = setin
    min1=min(setin(1,*)) & max1=max(setin(1,*))
    set_norm(1,*) = (setin(1,*)-min1)/(max1-min1) + 1.5
    plotset,set_norm,yrange=[-.4,2.4]
    ; 
    der_norm = der1x
    min1=min(der1x) & max1=max(der1x)
    der_norm = (der_norm-min1)/(max1-min1) + 0.8
    oplot,setin(0,*),der_norm
    ; 
    der_norm = der2x
    min1=min(der2x) & max1=max(der2x)
    der_norm = (der_norm-min1)/(max1-min1) - 0.2
    oplot,setin(0,*),der_norm
  endelse
endif
;
return
end
