FUNCTION XAID_DEFAULTS,program,group=group
;+
; NAME:
;	XAID_DEFAULTS
;
; PURPOSE:
;	Define the data structure for each program of the XAID extension.
;	The purpose of this function is to contain all the default input 
;	parameter definition in order to allow different Xop users to
;	customize their particular input defaults. 
;
; CATEGORY:
;	Xop/Xaid application.
;
; CALLING SEQUENCE:
;
;	inp = XAID_DEFAULTS('xprogram')
;
; INPUTS:
;	xprogram:	Name of the program interface in Xop.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;       group = The widget ID of the widget that calls the routine.
;               This is passed to widget_message in its dialog_parent
;               keyword to center the window message.
;
; OUTPUTS:
;	The input structure with the data necessary to run the program.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS: *** WARNING  ***
;	If the user changes this defaults, be careful with the type
;	of variable. Saying for instance a:4 initializes a as short
;	integer and WILL NEVER be a float. Place a:4.0 to set it as
;	float.
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	inp = XAID_DEFAULTS('xaid_mu2chi')
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr) 2006-03-09
;			using dabax_defaults.pro as template
;-


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XAID_DEFAULTS: error caught (returned 0): '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN,0
ENDIF

program = strupcase(program)

case program of
	'XAID_MU2CHI': begin
		;
		xaid_mu2chi = {  $
		file:'<none>', $
		preMin:0.0, $
		preMax:0.0, $
		e0:0.0, $
		jump:0.0, $
		npol:3, $
		degree:'[2,2,2]', $
		knots:'[2,4,6,8]', $
		kkmin:2.0, $
		kkmax:12.0, $
		extraction:['0','Experimental','Constant',$
			'Lengeler-Eisenberg'],  $
		rmin:0.0, $
		rmax:8.0, $
		ftwindow:['1','Gaussian','Hanning','None','Parzen',$
			'Welch','Hamming','Tukey','Papul','Kaiser'], $
		ftpar:0.2 $
		}
		end
	'XAID_FF': begin
		;
		window_ftr,names=windowlist
		xaid_ff = {  $
		krange:[2.0,12.0], $
		rrange:[0.,6.], $
		rrrange:[0.,6.],$
		kkrange:[2.1,11.9],$
		filter:['1',windowlist], $
		kpower:['0','0','1','2','3','4'], $
		rshell:0.0, $
		WinPar:0.2 $
		}
		end
	else:   begin
		message,/info,'ERROR: Program not found'
		out = 0
		end
	endcase

;
;----------------------- WARNING !! -----------------------------
; If this section is modified, please check also xop_defaults.pro
; dabax_defaults, etc.
;----------------------------------------------------------------
;
; rename the structure to out
;
out = 0
command = 'out = '+program
;print,command 
tmp = Execute(command)

;
; Overwrite data with values from defaults files
; (same section in dabax_defaults, xop_defaults, xplot_defaults 
;  and xnlfit_defaults)
;
sep = sdep(/ds)
filedir = [Xop_GetEnv('XOP_HOME')+sep+'defaults'] 
filedir = [filedir]
IF Xop_GetEnv('XOP_DEFAULTS_DIR') NE '' THEN $
   filedir = [filedir,Xop_GetEnv('XOP_DEFAULTS_DIR')]

nfiles = n_elements(filedir)
if nfiles EQ 1 then filedir = [filedir]
tmp=0
for i=0,nfiles-1 do begin
  file = filedir[i]+sep+StrLowCase(program)+'.xop'
  tmp = checkfile(file)
  if tmp EQ 1 then begin
    str_par = Xop_Input_Load(inputFile=file)
    ;IF N_Tags(out.parameters) NE 0 THEN BEGIN
    IF (Where(StrUpCase(Tag_Names(out)) EQ 'PARAMETERS'))(0) NE -1 THEN BEGIN
      tmp = out.parameters
      Copy_Structure,str_par, tmp
      out.parameters = tmp
    ENDIF ELSE BEGIN
      tmp = out
      Copy_Structure,str_par, tmp
      out = tmp
    ENDELSE
    message,/info,'Defaults from file: '+file+'
  endif
endfor
;
; return
;
return,out
end
