
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
function K2E,inset
;
;
;+
; NAME:
;	K2E
;
; PURPOSE:
;	This function translates a set with scale in wavenumber (K) [A^(-1)]
;	to a new set with scale in energy (E) [eV]
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	set_ev = K2E(set_k)
;
; INPUTS:
;	set_ev:	fltarr(2,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	set_k: output set in K
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	The opposite of K2E
;
; EXAMPLE:
;
;	set2 = K2E(set1)
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	January, 1993	
;-
;
; converts a set in k to a set in energy
; the negative k are treated as negative energies
;
on_error,2
;
tmpx = inset(0,*)
npts = n_elements(tmpx)
;sign_val = fltarr(npts)
;for i=0,npts-1 do begin
;  if (tmpx(i) ge 0.) then begin
;    sign_val(i) = 1.
;  endif else sign_val(i) = -1.
;endfor
tmpx = ((tmpx gt 0) * 2-1) * tmpx * tmpx * 3.810011
;
outset = inset
outset(0,*) = tmpx
;
return, outset
end
