
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
function GETJUMP, exper, ask=ask, Dialog_Parent=dialog_parent,$
  iMode=iMode,nomouse=nomouse
;
;+
; NAME:
;	GETJUMP
;
; PURPOSE:
;	This function inputs the jump of a xafs spectrum
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	myjump = GETJUMP(myset)
;
; INPUTS:
;	myset:	fltarr(2,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;       IMODE: 0 (default) Uses the default value
;	       1 gets jump from cursor 
;	       2 inputs data
;	DIALOG_PARENT: this keyword is passed to dialogs for centering
;		the widget with a parent widget.
;
; OUTPUTS:
;	myjump: the value with the jump
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	The jump value is read with the mouse 
;
; EXAMPLE:
;
;		jump = GETJUMP (set2)
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;	93-05-24 MSR small modifications
;	94-10-10 MSR NOMOUSE keyword.
;	96-08-13 MSR (srio@esrf.fr) changes wmenu->wmenu2 and 
;		xtext->Dialog_Message
;	00-02-12 MSR (srio@esrf.fr) adds Dialog_Parent keyword
;	06-03-06 srio@esrf.fr removes non-widget code. IMODE kw.
;		NOMOUSE no longer used (kept for compatibility)
;-
;
on_error,2
IF N_Elements(imode) EQ 0 THEN imode=0
jump=0.0
;

CASE imode OF
  0: BEGIN
       ;
       ; automatic calculation of jump (mean value of the points sitting
       ; in the normalized interval interval [0.2,0.4]  where extrema are
       ; Eo and xmax )
       ;
       plotset,exper
       xmin = gete0(exper)
       xmax = max(exper(0,*))
       xmin_good = xmin + 0.2*(xmax-xmin)
       xmax_good = xmin + 0.4*(xmax-xmin)
       cutset,exper,good,xrange=[xmin_good,xmax_good]
       tmp1=(total(good(1,*)))/(n_elements(good(1,*)))  - min(exper(1,*))
       good(1,*) = good(1,*)*0.0+tmp1
       plotset,good,/over
       oplot,good(0,*),good(1,*)*0.0+ min(exper(1,*))
       jump=Abs(tmp1)
     END
  1: BEGIN ; cursor
       itmp = Dialog_Message(/info,['Click two points:', $
	  'The baseline and the ', $
	  ' upper point for jump'],Dialog_Parent=dialog_parent)
       cursor,tmp,tmp2,3
       plotset,[tmp,tmp2],/over,psym=1
       cursor,tmp,tmp1,3
       plotset,[tmp,tmp1],/over,psym=1
       jump = Abs(tmp1-tmp2)
      END
   2: BEGIN  ; input value
       tmp = { n:1.0 }
       XscrMenu,tmp,/NoType,Titles='Jump value:',Wtitle='Input Jump', $
	 action=action,Dialog_Parent=dialog_parent
         if action eq 'DO' then jump=Abs(tmp.n)
      END
ENDCASE
;
return,jump
end
