;+
; NAME:
;	READ_GFILE
;
; PURPOSE:
;	This function returns an idl structure with the information 
;	contained in a SHADOW gfile.
;
; CATEGORY:
;	SHADOW
;
; CALLING SEQUENCE:
; 
;	Result = read_gfile(input)
;
; OPTIONAL INPUTS:
;	input:	the file name to be loaded. If not present, it looks
;		for the start.00 file sitting somewhere in !PATH.
;
; KEYWORD PARAMETERS:
;	OE:	When set and when "input" is not present, then the program 
;		looks for the start.0<OE> file  sitting somewhere in !PATH.
; OUTPUTS:
;	An idl structure with tags corresponding to values in the gfile.
;
; SIDE EFFECTS:
;	It may be a bit slow because it makes many text string manipulation.
;
; PROCEDURE:
;	It uses make_str to create the structure. A lot of string manipulation 
;	is needed before to prepare the input to make_str. It uses the 
;	auxiliar function read_gfile_arrays in the case that the gfile 
;	contains arrays (as for example in start.01).
;
; EXAMPLE:
;
;		A = READ_GFILE('start.02')
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio, srio@esrf.fr, 97/11/05
;
;	01/05/14 bug fixed: NPOINT is not required now.
;	17/05/14 bug fixed: refix NPOINT bug
;	2006-04-07 srio@esrf.fr fix a bug when reading files with no
;		string variables. Allows ";" as comment lines. Allows
;		blank lines. 
;
;-

Function read_gfile_arrays,f,a,indarr
;
; Only for internal use of read_gfile
;
catch, error_status
if error_status ne 0 then begin
  catch, /cancel
  message,/info,'Error caught: '+!err_string
  return,0
endif
barr=f
;
;barrnames = all names including index
;barrnames2 = all names without indeces
;
barrnames = barr
barrnames2 = barr
barr1=strpos(barrnames,'|')
barr2=strpos(barrnames,')')
barr3=strpos(barrnames,'(')
barr2=barr2-barr1
barr3=barr3-barr1-1
for i=0,n_elements(barr)-1 do barrnames(i) = strmid(barr(i),barr1(i)+1,barr2(i))
for i=0,n_elements(barr)-1 do $
  barrnames2(i) = strmid(barr(i),barr1(i)+1,barr3(i))
;
; identify single names and multiplicity
;
barr_sort_I=sort(barrnames2)
barr_sort=barrnames(barr_sort_I)
barr_sort2=barrnames2(barr_sort_I)
barr_uniq_I=uniq(barr_sort2)
barr_uniq=barr_sort2(barr_uniq_I)
barr_multi=barr_uniq_I-shift(barr_uniq_I,1)
barr_multi(0)=barr_uniq_I(0)+1
;
; create the text (strarr) containing the structure definition (to be
; passed to make_str)
;
g=strarr(n_elements(barr_multi))
for i=0,n_elements(barr_multi)-1 do begin
  tmp = f(barr_sort_I(barr_uniq_I(i)))
  ;print,barr_uniq(i),barr_multi(i),' ** ',tmp
  tmp1=strmid(tmp,0,strpos(tmp,'|'))
  g(i) = 'replicate('+tmp1+','+strcompress(barr_multi(i),/rem)+') | '+$
	barr_uniq(i)
endfor
;
; make the structure
;
h=make_str(g)
;
; assign values to the structure arrays
;
for i=0,n_elements(indarr)-1 do begin
  line = strtrim(a(indarr(i)),1)
  name=strmid(line,0,strpos(line,'('))
  value=strmid(line,strpos(line,'=')+1,strlen(line)-strpos(line,'=')-1)
  index=strmid(line,strpos(line,'(')+1,strpos(line,')')-strpos(line,'(')-1)
  index=strcompress(fix(index)-1,/rem)
  ;print,' '
  ;print,'line: **'+line+'**'
  ;print,'name: **'+name+'**'
  ;print,'index: **'+index+'**'
  ;print,'value: **'+value+'**'
  mytype = 0
  command = 'mytype = type(h.'+name+'(0))' 
  itmp = execute(command)
  ;print,'type: ',mytype
  if mytype EQ 7 then begin
    if strcompress(value,/re) EQ '' then value="''" else $
       value="'"+value+"'"
  endif
  command = 'h.'+name+'('+index+') = '+value
  ;print,command
  itmp = execute(command)
endfor
return,h
end ;read_gfile_arrays
;
;
;
Function read_gfile,file,oe=oe

;
; loads a start.00 file and returns the structure
;

catch, error_status
if error_status ne 0 then begin
  catch, /cancel
  message,/info,'Error caught: '+!err_string
  return,0
endif

if n_params() EQ 0 then begin
  if keyword_set(oe) then file='start.0'+strmid(strcompress(oe,/rem),0,1) $
	else file='start.00'
  file=filepath1(file)+sdep(/ds)+file
  message,/info,'Using file: '+file
endif
if checkfile(file) NE 1 then begin
  message,/info,'Error reading input file: '+file
  return,0
endif
a=read_textfile(file)

itmp = Where(StrCompress(strMid(a,0,1),/Rem) EQ ';',Comple=ic)
IF itmp[0] NE -1 THEN a=a[ic] 

itmp = Where(StrCompress(a,/Rem) EQ '',Comple=ic)
IF itmp[0] NE -1 THEN a=a[ic] 

b=a
; uses Long integer for npoint
index=where(strlowcase(strmid(strcompress(a,/rem),0,6)) EQ 'npoint',count)
IF count NE 0 THEN b(index) = strtrim(b(index))+'L'
;
; create the text for the structute: 'value | name'
;
for i=0,n_elements(b)-1 do b(i)=strsubstitute(b(i),'=','|')
c=strtrim(b,2)
c1=strpos(c,'|')
c2=strlen(c)
d=c
for i=0,n_elements(d)-1 do $
  d(i)=strmid(c(i),c1(i)+1,c2(i)-c1(i))+'|'+strmid(c(i),0,c1(i))
d=strtrim(d,2)
;
; find the text entries
;
bline = strmid(d,0,1)
e=intarr(n_elements(d))
for i=0,n_elements(e)-1 do e(i)=Strparse(' .+-0123456789 ',bline(i))
ind=where(e NE 1)
;
; place quotes in text entries
;
IF ind[0] NE -1 THEN BEGIN
  for i=0,n_elements(ind)-1 do d(ind(i))="'"+d(ind(i))
  for i=0,n_elements(ind)-1 do d(ind(i))=strsubstitute(d(ind(i)),'|',"'|")
ENDIF
;
; check if arrays are defined (i.e. in start.01)
;
indarr=where( strpos(d,'(') NE -1)
;
; if no arrays are found then exit
;
if n_elements(indarr) EQ 1 and indarr(0) EQ -1 then begin
 str1=make_str(d)
 return,str1
endif

e=d(where( strpos(d,'(') EQ -1))
str1=make_str(e)
f=d(indarr)
str2=read_gfile_arrays(f,a,indarr)
return,create_struct(str1,str2)
end
