;
; This file initializes the preferencies for SHADOWVUI
; 
; It may be customized to reflect the local SHADOW installation
; Please check the STEP 1 and STEP 2 section
;
common xsh_f0, wk_names, wk_data
common shadow, xshgeom, xshoe, shadow_start
common xhelp, docdir 
;
; customize shadow initialization (by default we use Bourne shell)
; Please check that the file .shadowrc.sh is correctly customized:
;      1) the directory paths are correctly set,
;      2) the SHADOW_START_FORMAT is set to GFILE (not FORTRAN)
;      3) the SHADOW_ENV_FILE points to /tmp/shadow-env-${USER} (this
;             is necessary to run sources without using make_id)
;


ds=SDep(/ds)  ; director separator

;
; define shadow_root
;
shadowvui_root = XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'

;
; define the shadow version used in different platfoems
;

; default: it works well for wigglers
shadow_version='2.3.0'

; the only one avaulable (without recompilation)
IF !version.os EQ 'darwin' THEN shadow_version='2.3.3' 
; 1Mrays
IF !version.os EQ 'linux' THEN shadow_version='2.3.2m' 

IF !version.os_family EQ 'Windows' THEN shadow_dir= 'shadow-'+shadow_version+'-win' ELSE shadow_dir = 'shadow-'+shadow_version+'-'+!version.os

shadow_root=dospath(shadowvui_root+ds+shadow_dir)

; this is to define SHADOW_ROOT at any time in IDL
;IF !version.os_family EQ 'Windows' THEN SetEnv,'SHADOW_ROOT='+shadow_root
SetEnv,'SHADOW_ROOT='+shadow_root


;
; Extends the path to data directory under shadowvui
;
!path=!path+SDep(/ps)+shadowvui_root+ds+'data'

;
; defines the commands to be run for initializing shadow

IF !version.os_family EQ 'Windows' THEN shadow_start=['set SHADOW_ROOT='+shadow_root,'set PATH='+shadow_root+ds+'bin;c:\windows\system32\cmd.exe','SET SHADOW_ENV_FILE=xsh_env_file.inp'] 


; this is for sh (default)
IF !version.os_family EQ 'unix' THEN setenv,'SHELL=/bin/sh'
IF !version.os_family EQ 'unix' THEN shadow_start='. '+shadow_root+'/.shadowrc.sh'
; if using /bin/csh uncomment the next section
; IF !version.os_family EQ 'unix' THEN setenv,'SHELL=/bin/csh'
; IF !version.os_family EQ 'unix' THEN shadow_start='source '+shadow_root+'/.shadowrc'

;
;  Extends the docdir and help paths
;
docdir=[docdir,shadowvui_root+ds+'doc']
!help_path = !help_path +SDep(/ps)+shadowvui_root+ds+'doc'

;
; in case you want a define a starting working directory, uncomment and
; customize the next command. Warning: the selected directory must
; exists, otherwise SHADOWVUI will not start.
; This SHADOWVUI_WD variable can be defined in the Unix script or the 
; windows .bat file that start SHADOWVUI, instead of here.
; If defined in both places, the one defined here will be considered.
; The default is the current directory under Unix.

; setenv,'SHADOWVUI_WD=/tmp'
