;
;+
;
;==============================  XSh_PlotXY   ==================================
;
; XSh_Plotxy is a widget based graphical interface for the PlotXY
; IDL implementation of the SHADOW plotxy tool.
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  Menu bar
;  ========
;  File:
;    XSh_Plotxy input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
;  Help:   Shows the XSh_PlotXY help (this text) and PlotXY help.
;
;  Other controls
;  ==============
;  
;  "Quit" button: quite sthe program
;  "Show contols": starts an application allowing to change interactively 
;	the parameters. 
;  "Refresh" refresh the screen by exucuting the command written at the 
;	bottom (which may be different to the parameters input with
;	"Show controls").
;  "Refresh in a new window" creates a new clone window and executes
;	PlotXY with parameters defined in the "Show controls". This
;	option is useful when tracing running SHADOW as a second time
;	with some changed parameters and wanted to compare with the 
;	previous run without destoying the previous PlotXY graph.
;  The bottom editable line can be used to enter by hand any PlotXY
;	command. Enter <return> for updating the graph. Note that 
;	entering a command here does not update the parameters available
;	under the "Show controls" button. Also, by using this button, 
;	the previous existing command is overwritten.
;	
;  
;  For zooming (in fact, changing abscissas and ordinates range) select 
;       a region of interest in the main plotting area.
;  For zooming out, doublr click on the plot.
;  
;
;
; COPYRIGHT:
;	XSH_Plotxy  belongs to SHADOWVUI package and it is distributed 
;	as an XOP extension.
;
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE. 
;
;       XOP WEB SITE:
;       http://www.esrf.eu/UsersAndScience/Experiments/TBS/SciSoft/xop2.3/
;
; CREDITS:
;	Published calculations made with SHADOW should refer:
;
;	 C. Welnak, G.J. Chen and F. Cerrina, 
;        "SHADOW: a synchrotron radiation X-ray Optics simulation tool",
;	 Nucl. Instr. and Meth. in Phys. Res. A347 91994) 344
;  
;        http://dx.doi.org/ 10.1016/0168-9002(94)91906-2  
;
;	or
;
;	 SHADOW WEB Page: http://www.nanotech.wisc.edu/shadow/
;
;
;	Published calculations made with SHADOWVUI/XOP should refer:
;
;	  M. Sanchez del Rio and R. J. Dejus 
;         "Status of XOP: an x-ray optics software toolkit"
;         SPIE Proceedings Vol. 5536 (2004) pp.171-174
;
;         http://dx.doi.org/10.1117/12.560903
;
;
; MODIFICATIONS: 
;
;	Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF
;	00/07/10 srio@esrf.fr version 1.1 for xop 2.0. Documented.
;	08/04/28 srio@esrf.eu documented the non-interactive call. 
;                Changed inputs. Updated doc. 
;	08/09/09 srio@esrf.eu added zoom. V 1.3
;
;
;========================================================================
;
;-

FUNCTION xsh_plotxy_version
RETURN,'1.3'
END

;
;===============================================================================
;
PRO xsh_plotxy_refresh,wId,command=fCommand
;
; Command=0 Update graph
;         1 Update command (only)
;         2 Update command and graph
;

stateid = Widget_Info(wId,/Child)
Widget_Control, stateid, get_UValue=state ; , /No_Copy

;
; update command (of required)
IF KeyWord_Set(fCommand) THEN BEGIN
  Command = XSh_plotxy_Command(state.strptr)
  Widget_Control,state.wids.command,Set_Value=command(0)

  ; update window bar
  wTitle = 'PlotXY: '+ (*(state.strPtr)).shadow_in
  state.wTitle=wTitle
  Widget_Control,state.wids.base,TLB_Set_Title= wTitle

  IF fCommand EQ 1 THEN RETURN 

ENDIF


widget_control,state.wids.draw,get_value=windownum
wset,windownum

;old_windownum=!d.window

old_p=!p
old_x=!x
old_y=!y

!p.position=0 

Widget_Control,state.wids.command,Get_Value=Command,/HourGlass
if strcompress(Command(0),/Rem) NE '' then begin
  tmp = execute(command(0)+',group='+StrCompress(wId,/Rem)+'L')
  state.psysvar.x=!x
  state.psysvar.y=!y
  state.psysvar.p=!p
  state.zoom.zoomIn=0
  Widget_Control,state.wids.base,TLB_Set_Title= 'PlotXY: '+command[0]
endif
Widget_Control, stateid, Set_UValue=state ; , /No_Copy

!p=old_p
!x=old_x
!y=old_y

END ; xsh_plotxy_refresh

;
;===============================================================================
;
Pro xsh_plotxy_event, event

;!p.position=0 

Widget_Control, event.id, get_UValue=eventUValue
;Widget_Control, event.id, get_Value=Value

if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''

stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state ; , /No_Copy

widget_control,state.wids.draw,get_value=windownum
wset,windownum

;
; Action
;
Case eventUValue OF
     'RESIZE': BEGIN
	if sdep() EQ 'UNIX' then begin
	  widget_control,state.wids.draw,$
		scr_xsize=event.x-5,scr_ysize=event.y-105
          Widget_Control,state.wids.command,xsize=(event.x-5)/8
          Widget_Control,state.wids.base,xsize=event.x-5
	endif else begin
	  widget_control,state.wids.draw,$
		scr_xsize=event.x+5,scr_ysize=event.y-65
          Widget_Control,state.wids.command,xsize=(event.x+5)/6.15
          Widget_Control,state.wids.base,xsize=event.x+5
	endelse
        ;Widget_Control,state.wids.command,Get_Value=Command,/HourGlass
        ;tmp = execute(command(0)+',group=event.top')
        Widget_Control,stateId,Set_UValue=state
        xsh_plotxy_refresh,event.top
     END
     'CURSOR': Begin

        widget_control,state.wids.draw,get_value=windownum
        wset,windownum

        old_p=!p
        old_x=!x
        old_y=!y
        !p=state.psysvar.p
        !x=state.psysvar.x
        !y=state.psysvar.y
        ; show cursor position
          coords_d = [event.x,event.y]
        IF Widget_Info(state.wids.cursor,/Valid_Id) THEN BEGIN
          coords_d = [event.x,event.y]
          if (coords_d(0) GT !d.x_size or coords_d(0) LT 0 or $
            coords_d(1) GT !d.y_size or coords_d(1) LT 0) then return
          coords = convert_coord(event.x,event.y,/device,/to_data)
          
          widget_control,state.wids.cursor,SET_VALUE='  ('+$
        	strcompress(coords(0),/REM)+','+$
        	strcompress(coords(1),/REM)+')'
        ENDIF

        ; manages zoom
        out = zoom_manager(event,stateId)

        ; if zoom is requested, update graph, etc.
        Widget_Control,stateId,get_UValue=state
        IF state.zoom.zoomIn EQ 1 THEN BEGIN
          ; close parameters window (if open)
	  IF state.controls_status EQ 'shown' THEN BEGIN
		Widget_Control,state.wids.showhide,set_value='Show controls'
		state.controls_status='hiden'
		Widget_control,state.wids.refresh,sensitive=1
		Widget_control,state.wids.refreshNew,sensitive=1
		IF state.wids.controls NE 0L THEN $
			Widget_Control,state.wids.controls,/destroy
		state.wids.controls=0L
                Widget_Control,stateId,Set_UValue=state
	  ENDIF
          str = *(state.strptr)

          IF state.zoom.xs NE state.zoom.xd THEN BEGIN
            xrange = out[0:1]
            str.xrange=xrange
            str.default_xrange=0
          ENDIF ELSE BEGIN
            str.xrange=[0.0,0.0]
            str.default_xrange=1
          ENDELSE

          IF state.zoom.ys NE state.zoom.yd THEN BEGIN
            yrange = out[2:3]
            str.yrange=yrange
            str.default_yrange=0
          ENDIF ELSE BEGIN
            str.yrange=[0.0,0.0]
            str.default_yrange=1
          ENDELSE

          *(state.strptr)=str
          xsh_plotxy_refresh,event.top,command=2
        ENDIF 
        !p = old_p
        !x = old_x
        !y = old_y
        RETURN
	End


    'QUIT': Begin
	; Free pointer if input type is not a pointer
	IF state.type_input NE 10 THEN Ptr_Free,state.StrPtr
	;
	Widget_Control, event.top, /destroy
	Return
	End

    'FILEINPUT': BEGIN
        action=''
        Widget_Control,event.id, Get_Value=action
        CASE action OF
            'Load from file...': BEGIN
              ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
              str_par = Xop_Input_Load(Title=$
              'Select XSh_PlotXY input file...',$
              /NoConf,Filter=filter,Group=event.top)
              IF Type(str_par) EQ 8 THEN BEGIN
                tmp = *(state.strptr)
                Copy_Structure,str_par, tmp, Group=event.top , /OnlyFirstField
                *(state.strptr) = tmp
              ENDIF
	      ; copied from apply section
	      ; update window bar
	      wTitle = 'PlotXY: '+ (*(state.strPtr)).shadow_in
	      state.wTitle=wTitle
	      Widget_Control,state.wids.base,TLB_Set_Title= wTitle
	      ;update command
	      tmp=state.StrPtr
	      Command = XSh_Plotxy_Command(tmp)
	      Widget_Control,state.wids.command,Set_Value=Command,/HourGlass
	      ;tmp = execute(command(0)+',group=event.top')
              Widget_Control,stateId,Set_UValue=state
              xsh_plotxy_refresh,event.top
            END
            'Save to file...': BEGIN
              str_par = *(state.strPtr)
              Xop_Input_Save,str_par,File='xsh_plotxy.xop',$
                /Write, Group=event.top, Comment='; xop/xsh_plotxy(v'+$
              xsh_plotxy_version()+') input file on '+SysTime()
            END
            'Save as default': BEGIN
              str_par = *(state.strPtr)
              Xop_Input_Save,str_par,Group=event.top, $
                Default='xsh_plotxy.xop',Comment='; xop/xsh_plotxy(v'+$
              xsh_plotxy_version()+') input file on '+SysTime()
            END
          ENDCASE
        END

    'APPLY': Begin
        Widget_Control,stateId,Set_UValue=state
        xsh_plotxy_refresh,event.handler,command=2
	End
    'PRINT': Begin
	Widget_Control,state.wids.command,Get_Value=Command,/HourGlass
	XPrint,Buffer=command(0), Group=event.top
	End
    'REFRESH': Begin
        xsh_plotxy_refresh,event.top
	End
    'REFRESHNEW': Begin
	Widget_Control,state.wids.command,Get_Value=Command,/HourGlass
	IF StrCompress(command[0],/Rem) EQ '' THEN BEGIN 
	  XSh_PlotXY,/NoExecute
	ENDIF ELSE BEGIN
	  str = *state.strPtr
	  XSh_PlotXY,str,wTitle=state.wTitle
	ENDELSE
	END
    'SHOWHIDE': Begin
	Case state.controls_status of
	'hiden': Begin
		Widget_Control,state.wids.showhide,set_value='Hide controls'
		state.controls_status='shown'
		p=0
		Widget_control,state.wids.refresh,sensitive=0
		Widget_control,state.wids.refreshNew,sensitive=0
		Widget_Control,/HourGlass
		xsh_plotxy_controls,state.strptr,TLB_ID=p,Group=event.top, $
			Caller_ID=event.handler
		state.wids.controls=p
		End
	'shown': Begin
		Widget_Control,state.wids.showhide,set_value='Show controls'
		state.controls_status='hiden'
		Widget_control,state.wids.refresh,sensitive=1
		Widget_control,state.wids.refreshNew,sensitive=1
		IF state.wids.controls NE 0L THEN $
			Widget_Control,state.wids.controls,/destroy
		state.wids.controls=0L
		End
	EndCase
	End
    'Help.XSh_Plotxy': xhelp,'xsh_plotxy',GRO=event.top
    'Help.Plotxy': xhelp,'plotxy',GRO=event.top
    else: print,'else : ',eventUValue
ENDCASE


Widget_Control, stateid, Set_UValue=state ; , /No_Copy

END

;
;======================================================================
;
;
;+ 
; 
;  NON INTERACTIVE CALL OF XSH_PLOTXY: 
;
;
;  PRO xsh_plotxy, $
;    input, $                  ; undefined, structure, file name, pointer
;    col1, $                   ; shadow column for plot (horizontal)
;    col2, $                   ; shadow column for plot (vertical)
;    File=file, $              ; string with file name (overwrites "input")
;    Wtitle = wtitle, $        ; string with window title
;    NOEXECUTE = noexecute, $  ; create windows, but do not execute plotxy
;    GROUP=group               ; id of the window parent
;
;-
PRO xsh_plotxy, $
  input, $                  ; undefined, structure, file name, pointer
  col1, $                   ; shadow column for plot (horizontal)
  col2, $                   ; shadow column for plot (vertical)
  File=file, $              ; string with file name (overwrites "input")
  Wtitle = wtitle, $        ; string with window title
  NOEXECUTE = noexecute, $  ; create windows, but do not execute plotxy
  GROUP=group               ; id of the window parent

on_error,2
;
; analyse input
;
CASE type(input) OF
  0: BEGIN ; undefined
	str = XSh_Defaults('XSH_PLOTXY')
	ptr = Ptr_New(str)
     END
  8: BEGIN ; structure
	ptr = Ptr_New(input)
     END
  7: BEGIN ; string (file name)
	str = XSh_Defaults('XSH_PLOTXY')
	ptr = Ptr_New(str)
        (*ptr).shadow_in = input
     END
  10: BEGIN ; pointer
	ptr = input
     END
ENDCASE

if keyword_set(file) then (*ptr).shadow_in = file
if N_Elements(col1) NE 0 then (*ptr).col1 = col1 ;ELSE (*ptr).col1 = 1
if N_Elements(col2) NE 0 then (*ptr).col2 = col2 ;ELSE (*ptr).col2 = 3

; check if file exists
if checkfile((*ptr).shadow_in) NE 1 then begin
  itmp = Dialog_Message(/Question,Dialog_Parent=group,$
  ['XSH_PLOTXY: Input file does not exist: '+(*ptr).shadow_in,'Abort?'])
  if itmp EQ 'Yes' then return
endif

if not(keyword_set(wtitle)) then wtitle = 'PlotXY window'

; 
; Create widgets
;
wbase=widget_base(/col,MBAR=wMenuBar,Title=wtitle,$
 /TLB_Size_Events,UVALUE='RESIZE')
wstate=widget_base(wbase) ; to store state

;Menu bar
wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)

  wtmp0 = widget_button(wFileMenu,VALUE='XSh_PlotXY input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Print...', Uvalue= 'PRINT',/Separator)
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit', Uvalue= 'QUIT',/Separator)

wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='XSh_Plotxy', $
	UVALUE='Help.XSh_Plotxy')
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='Plotxy', UVALUE='Help.Plotxy')


wblk =widget_base(wbase,/col)

wtmp0 = Widget_Base(wbase,/Row)
  wtmp = Widget_Button(wtmp0,Value='Quit',UValue='QUIT')
  ;wtmp = Widget_Button(wtmp0,Value='Refresh',UValue='REFRESH')
  wshowhide = Widget_Button(wtmp0,Value='Show controls',UValue='SHOWHIDE')
  wrefresh = Widget_Button(wtmp0,Value='Refresh',UValue='REFRESH')
  wRefreshNew = Widget_Button(wtmp0,Value='Refresh in a new window', $
    UValue='REFRESHNEW')
wtmp0 = Widget_Base(wbase,/Row)
  ;wcursor = Widget_Label(wtmp0,Value='**************************',UValue='DUMMY')
  wcursor = Widget_Label(wtmp0,Value='****Select a ROI to zoom****',UValue='DUMMY')

;WDraw = widget_draw(wbase,xsize=600,ysize=400)
WDraw = widget_draw(wbase,xsize=600,ysize=400,$
	/MOTION_EVENTS,UVALUE='CURSOR',RETAIN=2,BUTTON_EVENTS=1)

if sdep() EQ 'UNIX' then xsize=95 else xsize=100
wCommand = Widget_Text(wbase,Value='',/Align_Left,XSize=xsize,/Edit,$
	UValue='REFRESH')

psysvar={x:!x,y:!y,p:!p}
wids = {showhide:wshowhide,command:wcommand, controls:0L, draw:wdraw,$
	base:wbase,refresh:wrefresh,refreshNew:wRefreshNew,cursor:wCursor}
state = {wids:wids, controls_status:'hiden', strptr:ptr, $
	type_input:type(input), wTitle:wTitle, $
        psysvar:psysvar, zoom:zoom_manager(/return_structure) }

state.zoom.boxcolor=!d.table_size/2
stateid = Widget_Info(wbase,/Child)
Widget_Control, stateid, Set_UValue=state ; , /No_Copy

widget_control,wbase,/realize

xsh_plotxy_refresh,wBase,/command
if not(keyword_set(noexecute)) then begin
  xsh_plotxy_refresh,wBase
endif

xmanager, 'xsh_plotxy', wbase, GROUP=group, /No_Block

end

