;+
;
; This application creates a file containing a mesh surface
; with a conic surface.
;
;
; Algorithm:
;  1) Calculate the coefficients of the conic using 
;     conicset. This function mimics SHADOW/MSETUP 
;  2) Create a mesh using the predefined conic (comicmesh)
;  3) Create files for SHADOW and display surfaces.
;
; Author: M. Sanchez del Rio
;
; Modification history:
;    2007-11-07 srio@esrf.eu written.
;    2009-01-07 srio@esrf.eu revisited.
;
;
;-

;
;===================================================================
;
FUNCTION xsh_conic_version
return,'1.01'
END

;
;===================================================================
;
PRO xsh_conic_updatewidgets,wid
;
; cp parameters from str to widgets
;
on_error,2

stateid = Widget_Info(wid,/Child)
Widget_Control, stateid, get_UValue=state, No_Copy=0
wids = state.wids

pars = state.str.parameters
FOR i=0,N_Elements(state.wids)-1 do begin
   Widget_Control,wids[i],Get_Value=tmp0
   tmp = pars.(i)
   Widget_Control,wids[i],Set_Value=fix(tmp[0],type=type(tmp0))
ENDFOR
END ; xsh_conic_updatewidgets

;
;===================================================================
;
PRO xsh_conic_updatestr,wid
;
; cp parameters from widgets to str
;
on_error,2

stateid = Widget_Info(wid,/Child)
Widget_Control, stateid, get_UValue=state, No_Copy=0
wids = state.wids

pars = state.str.parameters
FOR i=0,N_Elements(wids)-1 do begin
   Widget_Control,wids[i],Get_Value=tmp
   IF N_Elements(pars.(i)) EQ 1 THEN BEGIN
      pars.(i)=tmp
   ENDIF ELSE BEGIN
      Widget_Control,wids[i],Get_Value=tmp
      tt = pars.(i)
      tt[0]=tmp
      pars.(i)=tt
   ENDELSE
ENDFOR

state.str.parameters=pars
Widget_Control,StateId,set_UValue=state
END ; xsh_conic_updatestr

;
;===================================================================
;
PRO xsh_conic_event,event
;
on_error,2

Widget_Control, event.id, get_UValue=eventUValue
IF N_Elements(eventUValue) EQ 0 THEN eventUValue=''


;stateid = Widget_Info(event.handler,/Child)
;Widget_Control, stateid, get_UValue=state, No_Copy=0
;help,state,/str

Case eventUValue OF
    '': RETURN
    'QUIT': BEGIN
	Widget_Control,event.top,/Destroy
	END
    'FILEINPUT': BEGIN
        action=''
        Widget_Control,event.id, Get_Value=action
        stateid = Widget_Info(event.handler,/Child)
        Widget_Control, stateid, get_UValue=state, No_Copy=0
        CASE action OF
          'Load from file...': BEGIN
            if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
            str_par = Xop_Input_Load(Title=$
            'Select xsh_conic input file...',$
            /NoConf,Filter=filter,Group=event.top)
            IF Type(str_par) EQ 8 THEN BEGIN
              tmp = state.str.parameters
              Copy_Structure,str_par, tmp, Group=event.top ,$
                 /OnlyFirstField
              state.str.parameters = tmp
            ENDIF
            Widget_Control, stateid, Set_UValue=state, No_Copy=0
	    xsh_conic_updatewidgets,event.handler
          END
          'Save to file...': BEGIN
            str_par = state.str.parameters
            Xop_Input_Save,str_par,File='xsh_conic.xop',$
              /Write, Group=event.top, Comment= $
              '; xop/xsh_conic(v'+$
               xsh_conic_version()+') input file on '+SysTime()
          END
          'Save as default': BEGIN
            str_par = state.str.parameters
            Xop_Input_Save,str_par,Group=event.top, $
              Default='xsh_conic.xop',Comment=$
                      '; xop/xsh_conic(v'+$
                 xsh_conic_version()+') input file on '+SysTime()
          END
        ENDCASE
	END

    'HELP': BEGIN 
	xhelp,'xsh_conic',group=event.top
	END

    'TAB': 

    'CALC': BEGIN ; calculate surface
          xsh_conic_updatestr,event.handler

	  stateid = Widget_Info(event.handler,/Child)
	  Widget_Control, stateid, get_UValue=state
          pars = state.str.parameters
          wids = state.wids

;help,pars.theta

          ccc = conicset(pars.p,pars.q,pars.theta*1e-3, $
                type=Fix((pars.type)[0]), $
                convex=Fix((pars.convex)[0]), $
                cylindrical=Fix((pars.cyl)[0]), $
                cylAngle=pars.cylAngle,txt=txt)

	 XDisplayFIle1,text=txt,group=event.top,Title=$
           'xsh_conic results'

         conicmesh,ccc,ll=pars.length,ww=pars.width, $
           nx=pars.nx,ny=pars.ny, $
           presurface=pars.file,surf=surf , $
           modify=Fix((pars.sag)[0]), $
           pp=pars.p, qq=pars.q, theta=pars.theta*1e-3

	END

    'PRESURFACE1': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.parameters.file
	filesha=strmid(filedat,0,strpos(filedat,'.'))+'.sha'

	; delete .sha
	openw,unit,filesha,/delete,/get_lun
	free_lun,unit
	
	
	; create new file
	CASE SDep() OF
	'UNIX': BEGIN
	  command = "printf '"+filedat+" \n"+filesha+"\n' | presurface"
	  xsh_run,command
	  END
	'WINDOWS': BEGIN
	  OpenW,unit,'presurface_tmp.inp',/Get_Lun
	  PrintF,unit,filedat
	  PrintF,unit,filesha
	  Free_Lun,unit
	  xsh_run,'presurface < presurface_tmp.inp'
	  END
	 ELSE: itmp = Dialog_Message(/Error,'OS not implemented: '+SDep(),$
		Dialog_Parent=event.top)
	ENDCASE

	IF checkfile(filesha) NE 1 THEN  BEGIN
	  itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
		'XSH_WAVINESS_EVENT Problem creating file '+filesha)
	ENDIF ELSE BEGIN
	  itmp = Dialog_Message(/Info,Dialog_Parent=event.top, $
		'File (binary) written to disk: '+filesha)
	ENDELSE
	END
    'PRESURFACE2': xsh_run," xterm -e presurface " 
    'VIEW': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.parameters.file
	presurface,filedat,out,/NoPlot
	xsurface1,out.z,out.x,out.y,xtitle='x',ytitle='y'
	END
    'VIEWI': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.parameters.file
	presurface,filedat,out,/NoPlot
	iSurface,out.z,out.x,out.y,xtitle='x',ytitle='y'
	END

    'VIEWT': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.parameters.file
        XDisplayFIle1,filedat,Group=event.top
	END

    'PROFILES': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.parameters.file
	presurface,filedat,out,/NoPlot
	exodus,/only,/quit,parent=p
        slp = slopes(out)
	FOR i=0,N_Elements(out.x)-1 DO BEGIN
	    tmp = Make_Set(Reform(out.y),Reform((out.z)[i,*]))
	    slp1 = StdDev(slp[1,i,*])
            IF i EQ 0 THEN BEGIN 
              alltmp=tmp 
              allslope = slp1*180/!pi*3600
            ENDIF ELSE BEGIN 
              alltmp=alltmp+tmp
              allslope = allslope + slp1*180/!pi*3600
            ENDELSE
	    title='Z(Y) profile at x:'+ Strcompress((out.x)[i])+$
		'; slope='+StrCompress(slp1*180/!pi*3600,/Rem)+' arc sec'
	    exodus_loadfile,p,data=tmp,title=title
	ENDFOR
        alltmp = alltmp/N_Elements(out.x)
        allslope = allslope/N_Elements(out.x)
	exodus_loadfile,p,data=alltmp,title=$
         '  MEAN Z(Y) profile. Mean slope: '+ $
         StrCompress(allslope,/Rem)+' arc sec'
	FOR i=0,N_Elements(out.y)-1 DO BEGIN
	    tmp = Make_Set(Reform(out.x),Reform((out.z)[*,i]))
	    slp1 = StdDev(slp[0,*,i])
            IF i EQ 0 THEN BEGIN 
              alltmp=tmp 
              allslope = slp1*180/!pi*3600
            ENDIF ELSE BEGIN 
              alltmp=alltmp+tmp
              allslope = allslope + slp1*180/!pi*3600
            ENDELSE
	    title='Z(X) profile at y:'+ Strcompress((out.y)[i])+$
		'; slope='+StrCompress(slp1*180/!pi*3600,/Rem)+' arc sec'
	    exodus_loadfile,p,data=tmp,title=title
	ENDFOR
        alltmp = alltmp/N_Elements(out.y)
        allslope = allslope/N_Elements(out.y)
	exodus_loadfile,p,data=alltmp,title=$
         '  MEAN Z(X) profile. Mean slope: '+ $
         StrCompress(allslope,/Rem)+' arc sec'
	END


    'PSD': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.parameters.file
	presurface,filedat,out,/NoPlot
	exodus,/only,/quit,parent=p,/xlog,/ylog
	FOR i=0,N_Elements(out.x)-1 DO BEGIN
            s=prof2psd(Reform(out.y),Reform((out.z)[i,*]),f=f, $
             positive_only=1)
	    tmp = Make_Set(f,s)
	    ;slp1 = StdDev(slp[1,i,*])
            ;IF i EQ 0 THEN BEGIN 
            ;  alltmp=tmp 
            ;  allslope = slp1*180/!pi*3600
            ;ENDIF ELSE BEGIN 
            ;  alltmp=alltmp+tmp
            ;  allslope = allslope + slp1*180/!pi*3600
            ;ENDELSE
	    title='PSD of Z(Y) at x:'+ Strcompress((out.x)[i])
	    exodus_loadfile,p,data=tmp,title=title
	ENDFOR
	FOR i=0,N_Elements(out.y)-1 DO BEGIN
            s=prof2psd(Reform(out.x),Reform((out.z)[*,i]),f=f, $
             positive_only=1)
	    tmp = Make_Set(f,s)
            ;IF i EQ 0 THEN BEGIN 
            ;  alltmp=tmp 
            ;  allslope = slp1*180/!pi*3600
            ;ENDIF ELSE BEGIN 
            ;  alltmp=alltmp+tmp
            ;  allslope = allslope + slp1*180/!pi*3600
            ;ENDELSE
	    title='PDS of Z(X) profile at y:'+ Strcompress((out.y)[i])
	    exodus_loadfile,p,data=tmp,title=title
	ENDFOR
	END


    else: print,'EventUValue NOT FOUND: ',eventUValue
EndCase
end
;
;===================================================================
;
PRO xsh_conic,input, Group=group

if NOT(Keyword_Set(input)) THEN BEGIN
  str = xsh_defaults_preprocessors('xsh_conic')
endif

wbase=widget_base(/col,title='xsh_conic '+xsh_conic_version(),$
  MBar=wMenu)
wtmp = widget_base(wbase) ; to store state


wtmp0 = Widget_Button(wMenu,VALUE='File')
    wtmp = widget_button(wtmp0,VALUE='Load from file...', $
          UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...', $
          UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default', $
          UValue='FILEINPUT')
    wtmp = Widget_Button(wtmp0,VALUE='Quit',UVALUE='QUIT',/Sepa)

wtmp0 = Widget_Button(wMenu,VALUE='Help',/help)
  wtmp = Widget_Button(wtmp0,VALUE='xsh_conic',UVALUE='HELP')

wtmp0 = widget_base(wbase,/Row) ; Main Buttons
  wtmp = widget_button(wtmp0,Value='Quit',UValue='QUIT')
  ;wtmp = Widget_Button(wtmp0,Value='Load... ',$
  ;	UValue='LOAD_XSH_CONIC')
  wtmp = Widget_Button(wtmp0,Value='Calculate',UValue='CALC')
  ;wtmp = widget_button(wtmp0,Value='Help',UValue='HELP')
 
;
; different bases
;
wTab=Widget_Tab(wbase,UVal='TAB') 
  wConic=Widget_Base(wTab,Title='Conic', Column=1)
  wMesh=Widget_Base(wTab, Title='Mesh', Column=1) 
  wOutputs=Widget_Base(wTab, Title='Outputs', Column=1) 

ww = LonArr(N_Tags(str.parameters))
;
; conic
;
w1 = Widget_Base(wConic,/col,Frame=0)


  FOR i=0,6 do begin
    wtmp0 = Widget_Base(w1,/row)
    IF N_Elements(str.parameters.(i)) EQ 1 THEN BEGIN
      wtmpA = Widget_Label(wtmp0,Value= $
            String(str.titles[i],Format='(A25)'))
      wtmpB = Widget_Text(wtmp0, $
        Value=StrCompress(str.parameters.(i),/Rem), $
        /edit,xsize=25,/Align_right)
    ENDIF ELSE BEGIN
      wtmp0 = Widget_Base(w1,/row)
      wtmpB = cw_droplist(wtmp0, Value=str.parameters.(i), $
        Title=String(str.titles[i],Format='(A25)'))
    ENDELSE
    ww[i]=wtmpB
  ENDFOR

;
; mesh
;
w1 = Widget_Base(wMesh,/col,Frame=0)

  FOR i=7,11 do begin
    wtmp0 = Widget_Base(w1,/row)
    IF N_Elements(str.parameters.(i)) EQ 1 THEN BEGIN
      wtmpA = Widget_Label(wtmp0,Value= $
            String(str.titles[i],Format='(A25)'))
      wtmpB = Widget_Text(wtmp0, $
        Value=StrCompress(str.parameters.(i),/Rem), $
        /edit,xsize=25,/Align_right)
    ENDIF ELSE BEGIN
      wtmp0 = Widget_Base(w1,/row)
      wtmpB = cw_droplist(wtmp0, Value=str.parameters.(i), $
        Title=String(str.titles[i],Format='(A25)'))
    ENDELSE
    ww[i]=wtmpB
  ENDFOR
  i=12
  wtmpB = CW_Pickfile(w1,Title='Output file [.dat]: ', $
    Value=str.parameters.file, Path=0,/Button_Last,UValue='')
  ww[i]=wtmpB

;
; Outputs
;
w1 = Widget_Base(wOutputs,/col,/Frame)
  wtmp = Widget_Label(w1,Value= $
	' ** Create Output Files **')
;

  ;wtmp = Widget_Base(w1,/Row)
    ;wtmp0 = Widget_Label(wtmp,Value= '1) WRITE .dat FILE (MANDATORY)') 
    ;wtmp0 = Widget_Button(wtmp,Value='GO', UVALUE='WRITEFILE')

  wtmp = Widget_Base(w1,/Row)
  wtmp = Widget_Button(w1,Value='Calculate',UValue='CALC')

  wtmp = Widget_Base(w1,/Row)
    wtmp0 = Widget_Label(wtmp,Value='1) VISUALIZE .dat OUTPUTS (OPTIONAL)')
    wtmp0 = Widget_Button(wtmp,Value='XSurface1',UVALUE='VIEW')
    wtmp0 = Widget_Button(wtmp,Value='iSurface',UVALUE='VIEWI')
    wtmp0 = Widget_Button(wtmp,Value='Text',UVALUE='VIEWT')


  wtmp = Widget_Base(w1,/Row)
    wtmp0 = Widget_Label(wtmp, Value='2) RUN PRESURFACE (.dat -> .sha) (MANDATORY)')
    wtmp0 = Widget_Button(wtmp, Value='GO (automatic)', UVALUE='PRESURFACE1')
    wtmp0 = Widget_Button(wtmp, Value='GO (manual)', UVALUE='PRESURFACE2')


  wtmp = Widget_Base(w1,/Row)
    wtmp0 = Widget_Label(wtmp,Value='3) WRITE XSH_WAVINESS .inp INPUT FILE (OPTIONAL)')
    wtmp0 = Widget_Button(wtmp,Value='GO',UVALUE='WRITEINP')
  wtmp = Widget_Base(w1,/Row)
    wtmp0 = Widget_Label(wtmp,Value='4) ANALYZE PROFILES (OPTIONAL)')
    wtmp0 = Widget_Button(wtmp,Value='Profiles',UVALUE='PROFILES')
    wtmp0 = Widget_Button(wtmp,Value='PSD',UVALUE='PSD')



wids = ww ; { w:ww}
state = {wids:wids, str:str}

;
;
;
widget_control,Widget_Info(wbase,/Child),set_uvalue=state


widget_control,wbase,/realize
xmanager,'xsh_conic',wbase,GROUP=group,/NO_BLOCK
end
