FUNCTION RC2REF,anglefile,rcfile,d,file,intens=intens
;+
; FUNCTION RC2REF,anglefile,rcfile,d,file,intens=intens
;
; to create an intensity array from a file with a rocking
; curve and the angle.* shadow files.
;
; experimental status
;
; history:
; M. Sanchez del Rio, ESRF, June 1995
; READ_ASCII renamed to RASCII 97-09-30
; 2008-03-31 srio@esrf.eu calls physical_constants('hc')
;-
;
on_error,2
if n_params() lt 4 then begin
  print,'RC2REF: Usage: output = rc2ref(anglefile,rcfile,d,file)'
  return,0
endif
a=rascii(anglefile)
;endif
ener = getshcol(file,11)
lambda = physical_constants('hc')/ener
thetab = asin(lambda/2/d) * 180./!pi
ang = (a(1,*) - (90. - thetab))*!pi/180.
rc = rascii(rcfile)
;plotfile,rc
;pause
print,'RC2REF: Calling interpol...'
inty = interpol(rc(1,*),rc(0,*),ang)
;inty = interpolate(rc(1,*),rc(0,*),ang)
print,'RC2REF: Back from interpol.'
if not(keyword_set(intens)) then out = inty > 0 else $
                                out = (inty > 0) * intens
print,'RC2REF: Intensity is: ',total(out)
return,out
end


