PRO xsh_plotxy_controls_event,event
;
; Create the control window for XSh_PlotXY
; To be used internally by XSh_PlotXY
; srio@esrf.fr 97-12-4
; srio@esrf.fr 06.02.16 added retrace
; srio@esrf.fr 07.06.11 added pixelized contours
;
Widget_Control, event.id, get_UValue=eventUValue

; ignore tab events
IF Type(eventUValue) EQ 7 THEN $
  IF eventUValue EQ 'TAB' THEN RETURN

Widget_Control, event.id, get_Value=Value
 
if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''
 
stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy
 
;help,eventUValue
Case eventUValue OF
;    'BASES': BEGIN
;        for i=0,3 do Widget_Control,state.wids.Bases(i),map=0
;        Widget_Control,state.wids.Bases(event.value),map=1
;        END
    'SHOWHIDE': BEGIN
	IF state.wids.caller_id EQ 0L THEN BEGIN
	  Widget_control,event.top,/Destroy 
	  return
	ENDIF ELSE BEGIN ; close controls window and send event to xsh_plotxy
	  tmp = 0
	  XSh_PlotXY_PStr_Update,state.wids,state.strptr
          Widget_Control,state.wids.xrange,get_value=tmp
	  if tmp(0) EQ tmp(1) then (*(state.strptr)).default_xrange=1 else $
		(*(state.strptr)).default_xrange=0
          Widget_Control,state.wids.yrange,get_value=tmp
	  if tmp(0) EQ tmp(1) then (*(state.strptr)).default_yrange=1 else $
		(*(state.strptr)).default_yrange=0
          Widget_Control,state.wids.climits,get_value=tmp
	  if tmp(0) EQ tmp(1) then (*(state.strptr)).default_climits=1 else $
		(*(state.strptr)).default_climits=0
	  newevent=event
	  newevent.handler=state.wids.caller_id
	  XSh_PlotXY_Event,newevent
	ENDELSE
	Return
	END
    'APPLY': BEGIN
	IF state.wids.caller_id EQ 0L THEN BEGIN
	  itmp = Dialog_Message(Dialog_Parent=event.top, /Error,$
		'XSh_Plotxy_Controls not called from XSh_Plotxy')
	  GoTo,out
	ENDIF
	XSh_PlotXY_PStr_Update,state.wids,state.strptr
	newevent=event
	newevent.handler=state.wids.caller_id
	XSh_PlotXY_Event,newevent
	END
    'AUTOREFRESH': BEGIN
	index=0
	Widget_Control,event.id,Get_Value=index
	tmp = state.StrPtr
	(*tmp).AutoRefresh=index
	END
    else: BEGIN
	tmp = state.StrPtr
	IF (*tmp).AutoRefresh EQ 1 THEN BEGIN
	  XSh_PlotXY_PStr_Update,state.wids,state.strptr
	  newevent=event
	  newevent.handler=state.wids.caller_id
	  newevent.id=state.wids.apply
	  XSh_PlotXY_Event,newevent
	ENDIF
	END
EndCase


out:
Widget_Control, stateid, set_UValue=state, /No_Copy
end
;
;====================================================================
;
PRO xsh_plotxy_controls,input, TLB_ID=wbase, Group=group, $
  Caller_ID=Caller_ID

IF NOT(Keyword_Set(caller_id)) THEN caller_id=0L
if NOT(Keyword_Set(input)) THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group, [ $
	'No input data given to XSh_Plotxy_Controls','Using Default',$
	'(Creating Pointer tha will not be deleted).'])
  input = Ptr_New(Xsh_Defaults_results('XSH_PLOTXY'))
endif

wbase=widget_base(/col,title='xsh_plotxy_controls')
wtmp = widget_base(wbase) ; to store state

wtmp0 = widget_base(wbase,/Row) ; Main Buttons
  wtmp = widget_button(wtmp0,Value='Close',UValue='SHOWHIDE')
  wApply = widget_button(wtmp0,Value='Refresh',UValue='APPLY')
  wtmp1 = widget_Base(wtmp0,/Row,/Frame)
  wtmp = widget_label(wtmp1,Value='AutoRefresh: ')
  wAutoRefresh = cw_bgroup(wtmp1,['No','Yes'],/Exclusive,Uvalue='AUTOREFRESH',$
	/Return_Index,/Row)
 
;
; different bases
;
;wBasesButtons = cw_bgroup(wbase, $
;        ['General','Histograms','Color','Presentation'], $
;        /Exclusive,Uvalue='BASES',/Row,/Frame,/Return_Index,Set_Value=0,$
;        /No_Rel)
;
wTab=Widget_Tab(wbase,UVal='TAB') 
  wGeneral=Widget_Base(wTab,Title='General', Column=1)
  wHistograms=Widget_Base(wTab, Title='Histograms', Column=1) 
  wColor=Widget_Base(wTab, Title='Color', Column=1) 
  wPresentation=Widget_Base(wTab, Title='Presentation', Column=1) 

 
;wBases = widget_base(wbase)
;wGeneral = widget_base(wbases,/col,/frame)
;wHistograms = widget_base(wbases,/col,/frame)
;wColor = widget_base(wbases,/col,/frame)
;wPresentation = widget_base(wbases,/col,/frame)



;
; general
;
wfile = Widget_Base(wGeneral,/col,/Frame)
wshadow_in = CW_PickFile(wfile)
wtmp0 = Widget_Base(wfile,/row)
  wtmp = Widget_Label(wtmp0,Value=' Retrace distance: ')
  wRetrace = Widget_Text(wtmp0,Value='0.0',/edit,xsize=20)


wtmp = Widget_Base(wGeneral,/Row,/Frame)
wcol1 = cw_xshcol(wtmp,Title='Horiz:',/Col)
wcol2 = cw_xshcol(wtmp,Title='Vert :',/Col)

wtmp = Widget_Base(wGeneral,/Row,/Frame)
wXRange = cw_array(wtmp,Title='X range:',/Col,val=[0.0,0.0],$
	names=['X Min','X Max'],/Default)
wYRange = cw_array(wtmp,Title='Y range:',/Col,val=[0.0,0.0],$
	names=['Y Min','Y Max'],/Default)

wnolost = CW_Droplist(wGeneral,Title='Rays:', $
	Value=['0','All Rays','Good Only','Lost Only'])

wcart = CW_Droplist(wGeneral,Title='Cartesian Axes:', $
	Value=['0','No','Yes'])
wContour = CW_Droplist(wGeneral,Title='Plot Type:', $
	Value=['0','Scattered','Contour w/o ref','Contour w refl',$
	'Color Contour w/o ref','Color Contour w ref',$
        'Pixelized w/o ref','Pixelized w ref'])

;
; histograms
;
wHisto = cw_droplist(wHistograms,Title='Histo:', $
  Value=['0','Weighted with rays','Overploted weighted with intensity ',$
	'Weighted with intensity','Skip'])
wtmp0 = Widget_Base(wHistograms,/row)
  wtmp = Widget_Label(wtmp0,Value='Number of bins: ')
  ;wNbins = widget_slider(wtmp0, /FRAME, MIN=1,MAX=100,XSIZE=205)
  ;;wNBins = cw_array(wHistograms,Title='Number of bins:',/Frame)
  wNBins = Widget_Text(wtmp0,Value='25',/edit,xsize=20)
wcalfwhm = CW_Droplist(wHistograms,Title='Histogram FWHM:', $
	Value=['0','No','Yes'])
wgaussfit = CW_Droplist(wHistograms,Title='Histogram Fit:', $
	Value=['0','No','Gauss+2nd deg pol','Gauss','PseudoVoigt','Lorentzian'])
wtmp0 = Widget_Base(wHistograms,/row)
  wtmp = Widget_Label(wtmp0,Value='Binning for CONTOURS: ')
  wNC_Bins = Widget_Text(wtmp0,Value='25',/edit,xsize=20)
wtmp0 = Widget_Base(wHistograms,/row)
  wtmp = Widget_Label(wtmp0,Value='Number of curves for CONTOURS: ')
  wNLevels = Widget_Text(wtmp0,Value='6',/edit,xsize=20)
wSmooth = CW_Droplist(wHistograms,Title='Smooth for CONTOURS:', $
	Value=['0','No','Yes'])

;
; color
;
wCCol = cw_xshcol(wColor,Title='Column color:',/ZeroCol)
wtmp0 = Widget_Base(wColor,/row)
  wtmp = Widget_Label(wtmp0,Value='Bins: ')
  wCbins = widget_slider(wtmp0, /FRAME, MIN=1,MAX=250,XSIZE=205)
wCLimits = cw_array(wColor,Title='Histo Limits:',/Frame,val=[0.0,0.0],$
	names=['Min for color histo','Max for color histo'],/Default)
wCref = cw_droplist(wColor,Title='Reflectivity:',value=$
	['0','No','Yes'],/Frame)
wcfile = CW_PickFile(wColor,/Frame)


;
;presentation
;
wtmp0 = Widget_Base(wPresentation,/row)
  wtmp = Widget_Label(wtmp0,Value='Title: ')
  wTitle = Widget_Text(wtmp0,Value='',/edit,xsize=20)
wSlit = cw_array(wPresentation,Title='Slit:',$
	Value=replicate(0.0,4),/Default,names=$
	['Lower Left X','Lower Left Y','Upper Right X','Upper Right Y'])
wNoComm = CW_Droplist(wPresentation,Title='Comment section:', $
	Value=['0','Yes','No'])
wtmp0 = Widget_Base(wPresentation,/row)
  wtmp = Widget_Label(wtmp0,Value='CharSize: ')
  wCharsize = Widget_Text(wtmp0,Value='',/edit,xsize=20)
wtmp0 = Widget_Base(wPresentation,/row)
  wtmp = Widget_Label(wtmp0,Value='MulFac: ')
  wMulFac = Widget_Text(wtmp0,Value='',/edit,xsize=20)
;wtmp0 = Widget_Base(wPresentation,/row)
;  wtmp = Widget_Label(wtmp0,Value='Contour levels: ')
;  wNLevels = Widget_Text(wtmp0,Value='',/edit,xsize=20)
wPublish = CW_Droplist(wPresentation,Title='Publication:', $
	Value=['0','No','Yes'])

wids = { $
;general
	shadow_in:wshadow_in, retrace:wRetrace, col1:wcol1, col2:wcol2, $
	xrange:wxrange, yrange:wyrange, nolost:wnolost, cart:wcart, $
	contour:wContour, $
; histograms
	histo:wHisto, nbins:wNbins, nc_bins:wNC_Bins, NLevels:wNLevels, calfwhm:wcalfwhm, gaussfit:wgaussfit,$
; color
	cfile:wCfile, cbins:wCbins, ccol:wccol, climits:wclimits, cref:wcref, $
; presentation
	title:wtitle, slit:wslit, nocomm:wnocomm, charsize:wcharsize, $
	mulfac:wmulfac, publish:wpublish, smooth:wsmooth, $
;bases
;	bases:[wGeneral,wHistograms,wColor,wPresentation], $
;others
	Caller_ID:Caller_ID,AutoRefresh:wAutoRefresh,Apply:wApply}
state = {wids:wids, strptr:input}

;
; set defaluts
;
XSh_Plotxy_Controls_Update,wids,input
;
;
;
widget_control,Widget_Info(wbase,/Child),set_uvalue=state,/no_copy
;for i=1,3 do widget_control,wids.bases(i),map=0


widget_control,wbase,/realize
xmanager,'xsh_plotxy_controls',wbase,GROUP=group,/NO_BLOCK
end
