;+
;
;
; Pro respower,input,col1,col2,nolost=nolost,nbins=nbins,  $
;  hlimit = hlimit, title=title 
;
;-
Pro respower,input,col1,col2,nolost=nolost,nbins=nbins,  $
  hlimit = hlimit, title=title

;
on_error,2
if n_params() LT 3 then begin
  print,'RESPOWER: Usage: respower,'+"'"+'shadowdata'+"'"+',col_energy,col_x'
  return
endif
if  col1 ne 11 and col1 NE 19 then print, $
  'RESPOWER: Warning: first column is NOT energy or wavelength.'

;
; load shadow-idl structure and define  arrays and constants
;
str = readsh(input)
if not(keyword_set(str)) then return
if not(keyword_set(title)) then title=''
if not(keyword_set(hlimit)) then hlimit = 0.1

a=getshcol(str,[col1,col2],nolost=nolost)

if not(keyword_set(nbins)) then nbins=100
calfwhm = 1
if not(keyword_set(gauss)) then gauss=2
degree=1

coeff=poly_fit(a(0,*),a(1,*),degree,yfit,error,sigma,amatrix)
print,'RESPOWER: the poly_fit parameters are y = c(0) + c(1)x + c(2)x^2 + ...  with: '
for i=0,degree do begin
  print,' c(',i,') = ',coeff(i)
endfor
;
; substract the fit
;
diff = a
diff(1,*) = a(1,*)-yfit

sst  = stddev(diff(1,*))
mean1  = mean(diff(1,*))
print,'RESPOWER: Mean of residuals: ',mean1
print,'RESPOWER: StDev of residuals: ',sst

arr1=diff(0,*)
arr2=diff(1,*)
yran=fltarr(2)
yran(0) = min(arr2)
yran(1) = max(arr2)
binsize =(yran(1)-yran(0))/float(nbins)
hy = histogramw(arr2,binsize=binsize,min=yran(0),max=yran(1))
hx = fltarr(nbins)
for i=0,nbins-1 do hx(i) = yran(0)+ binsize/2 + binsize*i
hhx = fltarr (2*nbins)
hhy = fltarr (2*nbins)
for i=0,2*nbins-1,2  do begin
 hhx(i) = hx(fix(i/2))-binsize/2
 hhx(i+1) = hx(fix(i/2))+binsize/2
 hhy(i) = hy(fix(i/2))
 hhy(i+1) = hy(fix(i/2))
endfor
xrange = [0,1.1*max(hhy)]

;
; makes fit
;
; gaussian fit (if selected)
;if keyword_set (gauss) then begin
; if (gauss eq 1) then begin
;   vfit = gauss_fit (hx,hy,avfit)
; endif
; if (gauss eq 2) then begin
;   vfit = gaussfit (hx,hy,avfit)
;   zgauss = (hx-avfit(1))/avfit(2) 
; endif
; print,'RESPOWER: Gaussian fit on histogram: '
; print,'RESPOWER:                                       sigma=',avfit(2)
; print,'RESPOWER:                                       fwhm =',2.35*avfit(2)
;endif
;
; if selected, calculate fwhm
;
;if keyword_set(calfwhm) then begin
; hh = fltarr(2,nbins)
; hh(0,*) = hx
; hh(1,*) = hy
;endif
; 
; get histo maximum and limits
; 
hmax = max(hy)
hmaxi =  where ( hy EQ hmax)
hmaxi = hmaxi(0)
tmp = where ( hy GT hmax*hlimit)
hlefti = tmp(0)
hrighti = tmp(n_elements(tmp)-1)
print,'Histo tolerance: ',hlimit
print,'Left: ',hx(hlefti),hy(hlefti)
print,'Peak: ',hx(hmaxi),hy(hmaxi)
print,'Right: ',hx(hrighti),hy(hrighti)

;fwhm_val = getfwhm(hh,/reverse_plot)
;print,'RESPOWER: FWHM of the histogram is :',fwhm_val

; --------- all plots --------
;
oldpos=!p.position
xx0 = !p.position(0)
yy0 = !p.position(1)
xx1 = !p.position(2)
yy1 = !p.position(3)
if xx0 EQ xx1 then begin
  xx0 = 0.0  &  xx1 = 1.0
endif
if yy0 EQ yy1 then begin
  xx0 = 0.0  &  yy1 = 1.0
endif
xx = abs(xx1-xx0)
yy = abs(yy1-yy0)

help,col1
CASE col1 OF
  11: xtitle='Energy [eV]'
  19: xtitle='Wavelength [A]'
  else: xtitle='col'+StrCompress(col1,/Rem)
ENDCASE
; 
; top graph
;
!p.position= [xx0,yy0,xx0,yy0] + [.1*xx,.60*yy,.7*xx,.95*yy]
plot,a(0,*),a(1,*),psym=3,xtitle=xtitle,ytitle='Z [cm]'
amin = min(a(0,*))
amax = max(a(0,*))
xfit=amin + findgen(100)/99.*(amax-amin)
oplot,xfit,coeff(1)*xfit+coeff(0)+hx(hmaxi)
;
; overplots fit shifted to the histogram center
;
oplot,xfit,xfit*0.
oplot,xfit,coeff(1)*xfit+coeff(0)+hx(hlefti),linestyle=3
oplot,xfit,coeff(1)*xfit+coeff(0)+hx(hrighti),linestyle=3
;deltax = abs( (hx(hlefti)-hx(hmaxi))/coeff(1))
orig = -1.0*(coeff(0)+hx(hmaxi))/coeff(1)
;oplot,[orig,orig],[-1000,1000]

deltax1 = abs( (hx(hlefti)-hx(hmaxi))/coeff(1))
oplot,[orig-deltax1,orig-deltax1],[-1000,1000]

deltax2 = abs( (hx(hrighti)-hx(hmaxi))/coeff(1))
oplot,[orig+deltax2,orig+deltax2],[-1000,1000]
deltax = deltax1 + deltax2
;
; bottom graph
;
!p.position= [xx0,yy0,xx0,yy0] + [.1*xx,.1*yy,.7*xx,.50*yy]
plot,diff(0,*),diff(1,*),psym=3,/noerase,xtitle=xtitle, $
  ytitle='Z-Z!Dfit!N [cm]'
;
; overplots lines shifted to the histogram center, ans left and right sides
;
print,'>>>>>>hx(hmaxi) : ',hx(hmaxi)
print,'>>>>>>hx(hlefti) : ',hx(hlefti)
print,'>>>>>>hx(hrighti) : ',hx(hrighti)
oplot,xfit,xfit*0.+hx(hmaxi)
oplot,xfit,xfit*0.+hx(hlefti),linestyle=3
oplot,xfit,xfit*0.+hx(hrighti),linestyle=3

;
; titles
;
csize = !p.charsize * 1.4
tsize = !p.charsize * 2.0
xyouts,/nor,xx0+xx*0.10,yy0+yy*0.98,title,siz=tsize
text='Command: respower,'+"'"+str.name+"',"+ $
 strcompress(col1,/rem)+','+strcompress(col2,/rem)+',nbins='+ $
 strcompress(nbins,/rem)
if keyword_set(hlimit) then text = text + ',hlimit='+strcompress(hlimit,/rem)
if keyword_set(nolost) then text = text + ',nolost='+strcompress(nolost,/re)
xyouts,/nor,xx0+xx*0.10,yy0+yy*0.96,text

;
; data
;
xyouts,/nor,xx0+xx*0.71,yy0+yy*0.9,'Linear fit pendient: '+strcompress(coeff(1),/rem)
xyouts,/nor,xx0+xx*0.71,yy0+yy*0.87,'Histogram peak at: '+strcompress(hx(hmaxi),/rem)
xyouts,/nor,xx0+xx*0.71,yy0+yy*0.84,'Histogram base line: '+strcompress(hlimit,/rem)
;xyouts,/nor,xx0+xx*0.71,yy0+yy*0.81,'Hist Fit FWHM: = '+strcompress(2.35*avfit(2),/rem)
xyouts,/nor,xx0+xx*0.71,yy0+yy*0.78,'Delta = '+strcompress(deltax,/rem)
xyouts,/nor,xx0+xx*0.71,yy0+yy*0.75,'Origin = '+strcompress(orig,/rem)
xyouts,/nor,xx0+xx*0.71,yy0+yy*0.72,'Resolving Power = '+strcompress(orig/deltax,/rem)
intens,str,nolost=nolost,ii
xyouts,/nor,xx0+xx*0.71,yy0+yy*0.69,'Intensity = '+strcompress(ii,/rem)

;
; histogram plot
;
!p.position= [xx0,yy0,xx0,yy0] + [.75*xx,.1*yy,.9*xx,.5*yy]
plot,hhy,hhx,yrange=yran,xrange = xrange,/noerase
plot,hhy*0.+hmax*hlimit,hhx,yrange=yran,xrange = xrange,/noerase
;if keyword_set(gauss) then begin
; if (gauss eq 1) then begin
;   oplot,vfit,hx
; endif
; if (gauss eq 2) then begin
;   oplot,vfit,hx
; endif
;endif

;if keyword_set(calfwhm) then begin
; fwhm_val = getfwhm(hh,/reverse_plot)
;endif
;
; reset !p.position
;
!p.position=oldpos

end

