function  REFLAG, shadow_in, SLITCOL=slitcol, SLITRANGE=slitrange, $
FLAGVAL=flagval,FILE=FILE,COMPLEMENTARY=complementary,_Extra=extra
;+
; NAME:
;	REFLAG 
; PURPOSE:
;	an IDL implementation amd extension of the REFLAG and 
;	SHADOWIT SHADOW's utilities
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	 shadow_out=reflag(shadow_in)
; INPUTS:
;	shadow_in   IDL structure with SHADOW data
;	shadow_out  IDL structure with the resulting SHADOW data after
;		changing the flag
; OPTIONAL INPUTS:
; KEYWORD PARAMETERS:
;       SLITCOL   = number of the column where flag has to be applied.
;		When this keyword and the FILE one are selected, the
;		new flag column is the one of shadow_in, otherwise
;		it takes the one of file.
;       SLITRANGE  = range of BAD VALUES for the SLITCOL considered,
;		i.e., the points inside this interval are flagged negatively.
;	COMPLEMENTARY = when this keyword is set, the bad values are
;		the complementary of those in the SLITRANGE interval,
;		i.e., bad rays are OUTSIDE the SLITRANGE
;	FLAGVAL = value of the flag to out in (default=-1)
;	FILE = shadow file or IDL-SHADOW structure where to apply the 
;		SLITCOL and SLITRANGE keywords (If this keyword is omitted
;		then use the same as shadow_in)
;	_EXTRA = Other keywords are passed to READSH
;	OUTPUTS:
;	shadow_out: the ne IDL-SHADOW structure
; OPTIONAL OUTPUT PARAMETERS:
; COMMON BLOCKS:
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Similar to SHADOW's original.
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble August 1993
;	94/07/06 MSR Changes to a function and solves a bug when using
;		the FILE and SLITCOL options together.
;	06/02/23 srio@esrf.fr rewritten a large part, added complementary 
;		keyword. Added _Extra keyword. 
;	07/10/18 srio@esrf.eu corrects doc (mismatch good<->bad)
;-
on_error,2
;
if not(keyword_set(flagval)) then flagval=-1.0
;
; load shadow-idl structures
;
in = readsh(shadow_in,_Extra=extra)
if keyword_set(file) then filein = readsh(file,_Extra=extra)
;
; prepare the output
;
out = in
;
; if file defined, copy the flags from it
;
if  keyword_set(file) then begin
  if not(keyword_set(slitcol)) then out.ray(9,*) = filein.ray(9,*)
  in = filein
endif
;
; 
;
if keyword_set(slitrange) and keyword_set(slitcol) then  begin
  ; 
  ; if slitcol is energy
  ;
  if (slitcol eq 11) then slitrange = slitrange*2.0*!pi/1.239852D-4
  ;
  xx = GetShCol(in,slitcol)
   IF Keyword_Set(complementary) THEN BEGIN
     iibad = Where ( xx le slitrange(0) OR xx ge slitrange(1) )
   ENDIF ELSE BEGIN
     iibad = Where ( xx ge slitrange(0) AND xx le slitrange(1) )
   ENDELSE

   IF iibad[0] NE -1 THEN BEGIN
	out.ray(9,iibad) = flagval
	print,'REFLAG: Points reflagged: ',N_Elements(iibad)
	igood = Where (out.ray(9,*) GE 0)
	IF igood[0] NE -1 THEN print,'REFLAG: Good points: ',N_Elements(igood) $
		ELSE print,'REFLAG: No good points remained.'
   ENDIF ELSE BEGIN
	Print,'REFLAG: Nothing reflagged'
   ENDELSE
   
endif
RETURN,out
end
