function GETPHASE, shadow_in
;+
; NAME:
;	GETPHASE
; PURPOSE:
;	to get and correct the phase of a SHADOW-IDL structure
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;
;	phase = readsh('shadow_file_name')
;
;	with that, IDL stores in an array named phase (or whatever you
;	want) the s and p phases of the shadow_file_name 
; INPUTS:
;	SHADOW_FILE_NAME name of the input files: shtmp.par and shtmp.ray
; OUTPUTS:
;	PHASE an array (2,npoints) with the s and p phases
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	none
; RESTRICTIONS:
;	None.
; PROCEDURE:
;       This program extracts the phases from the SHADOW file and
;       corrects it in function of the direction of the electric
;       vector. When the electric vector is pointing back, a pi angle
;       is added to the phase.
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, 1 Oct 1992
;-
on_error,2
;
; load shadow-idl structure and define arrays and constants
;
input_type = (size(shadow_in)) ((size(shadow_in)) (0)+1)
if input_type eq 7 then shadow_out = readsh(shadow_in)
if input_type eq 8 then shadow_out = shadow_in
;
phase_s=shadow_out.ray(13,*)
phase_p=shadow_out.ray(14,*)
e_s = shadow_out.ray(6,*)
e_p = shadow_out.ray(17,*)
pi = 3.141592653589793238462643
;
tmp_s = phase_s*0.0
aa = where(e_s<0.0,count)
if (count gt 0 ) then tmp_s(where(e_s<0.0))=pi
;
tmp_p = phase_p*0.0
aa = where(e_p<0.0,count)
if (count gt 0 ) then tmp_p(where(e_p<0.0))=pi
;
new_phase_s = phase_s + tmp_s
new_phase_p = phase_p + tmp_p
phase=fltarr(4,n_elements(e_s))
phase(0,*) = new_phase_s
phase(1,*) = new_phase_p
phase(2,*) = phase_s
phase(3,*) = phase_p
return,phase
end
