PRO conicmesh,c,ww=ww,ll=ll,nx=nx,ny=ny,x=x,y=y, $
  modify=flatSag, pp=p,qq=q,theta=theta, $
  presurface=presurface, surf=surf
;+
;
;       NAME:
;               CONICMESH
;       PURPOSE:
;               This function calculates a mesh surface
;               using the conic coefficients from conicset()
;       CATEGORY:
;               SHADOW tools
;       CALLING SEQUENCE:
;               conicmesh,c
;
; 	INPUTS:
;		c: 10 conic coefficients, like the  output of 
;			conicset()
;	
; 	KEYWORD PARAMETERS
;		ww: the surface width in cm (along X)
;		ll: the surface length in cm (along Y)
;        	nx: number of points in X
;        	ny: number of points in Y
;		modify: a flag for allowing to modify the
;			conic surface: 
;			0: no modification
;			1: REPLICATE central meridional prof
;			2: REPLICATE central sag prof
;			3: replicate central mer + add central sag
;			4: fixed in sag + central meridional
;			5: conic in sag + central meridional
;		pp: the p distance in cm (needed if modify=4,5)
;		qq: the q distance in cm (needed if modify=4,5)
;		theta: grazing incident angle in rad (needed if 
;			modify=4,5)
;		presurface: set to a file name to write the 
;			surface in SHADOW predurface format.
;		surf: set to a named variable to get the surface 
;			in a structuto of type { x:x, y:y, z:z}
;
;	AUTHOR: 
;		M. Sanchez del Rio srio@esrf.eu
;	
;	MODIFICATION HISTORY:
;		2007-11-08 written
;
;-
on_error,2
;
; mesh
; 
IF N_Elements(flatSag) EQ 0 THEN flatSag=0

IF N_Elements(x) GT 1 THEN BEGIn
  xx=x
ENDIF ELSE BEGIN
  IF N_Elements(nx) EQ 0 THEN nx = 21
  IF N_Elements(ww) EQ 0 THEN ww = 10
  xx = makearray1(nx,-double(ww)/2,double(ww)/2)
ENDELSE

IF N_Elements(y) GT 1 THEN BEGIn
  yy=y
ENDIF ELSE BEGIN
  IF N_Elements(ny) EQ 0 THEN ny = 11
  IF N_Elements(ll) EQ 0 THEN ll = 10
  yy = makearray1(ny,-double(ll)/2,double(ll)/2)
ENDELSE


zz = DblArr(nx,ny)

For i=0,nx-1 do begin
  For j=0,ny-1 do begin
   
  x = xx[i] 
  y = yy[j]

  aa = c[2]
  bb = c[4]*y+c[5]*x+c[8]
  cc = c[0]*x^2 + c[1]*y^2 + c[3]*x*y + c[6]*x + c[7]*y + c[9]

  IF aa NE 0 THEN BEGIN
    discr = bb^2-4*aa*cc
    s1 = (-bb+Sqrt(discr))/2/aa
    s2 = (-bb-Sqrt(discr))/2/aa
    ss = min([s1,s2])
  ENDIF ELSE BEGIN
    ss = -cc/bb
  ENDELSE

  zz[i,j] = ss


  EndFor
EndFor

;
; change curvatures
;

help,flatSag
CASE flatSag of
  0:
  1: BEGIN ; REPLICATE central meridional prof
    zCenter = Reform(zz[nx/2,*])
    FOR i=0,nx-1 DO zz[i,*]=zCenter
    END
  2: BEGIN ; REPLICATE central sag prof
    zCenter = Reform(zz[*,ny/2])
    FOR j=0,ny-1 DO zz[*,j]=zCenter
    END
  3: BEGIN ; replicate central mer + add central sag
    zCenter = Reform(zz[nx/2,*])
    sagCenter = Reform(zz[*,ny/2])
    ;;sagCenter = zz[*,0]
    ;;sagCenter = sagCenter-min(sagCenter)
    FOR i=0,nx-1 DO zz[i,*]=zCenter ; replicate central meridional
    FOR j=0,ny-1 DO zz[*,j]=zz[*,j]+sagCenter ; add central sag
    END

  4: BEGIN ; fixed in sag + central meridional
    zCenter = Reform(zz[nx/2,*])
    ;; FOR j=0,ny-1 DO zz[*,j]=zCenter

    IF Keyword_set(p) THEN BEGIN
    pp = sqrt(p[0]^2+yy^2-2*p[0]*yy*cos(!dpi-theta[0]))
    qq = sqrt(q[0]^2+yy^2-2*q[0]*yy*cos(theta[0]))
    rsag = 2D0*pp*qq/(pp+qq)*sin(theta[0])
    ENDIF

    zz=zz*0
    rSagJ = rsag[ny/2]
    message,/info,'Using Rsag: '+StrCompress(rSagJ)
    FOR j=0,ny-1 DO BEGIN
      sagI = -xx^2
      ;rSagJ = rsag[j]
      sagI = -sqrt(sagI+rSagJ^2) + rSagJ
      zz[*,j]=zz[*,j]+sagI ; add sag
    ENDFOR
    FOR i=0,nx-1 DO zz[i,*]=zz[i,*]+zCenter
    END


  5: BEGIN ; conic in sag + central meridional
    zCenter = Reform(zz[nx/2,*])
    ;; FOR j=0,ny-1 DO zz[*,j]=zCenter

    IF Keyword_set(p) THEN BEGIN
    pp = sqrt(p[0]^2+yy^2-2*p[0]*yy*cos(!dpi-theta[0]))
    qq = sqrt(q[0]^2+yy^2-2*q[0]*yy*cos(theta[0]))
    rsag = 2D0*pp*qq/(pp+qq)*sin(theta[0])
    ENDIF

    zz=zz*0
    rSagJ = rsag[ny/2]
    FOR j=0,ny-1 DO BEGIN
      sagI = -xx^2
      rSagJ = rsag[j]
      sagI = -sqrt(sagI+rSagJ^2) + rSagJ
      zz[*,j]=zz[*,j]+sagI ; add sag
    ENDFOR
    FOR i=0,nx-1 DO zz[i,*]=zz[i,*]+zCenter
xplot,yy,rsag,/no,coltitles=['y[cm]','Rsag[cm]']
    END
else:
ENDCASE
;
IF N_elements(presurface) THEN $
  matr2presur,zz,xx,yy,File=presurface

surf = {z:zz,x:xx,y:yy}

END




