;+
; NAME:
;       SHOW_ELEMENT.
;
; PURPOSE:
;       This procedure set the property of an optical_system to show 
;	it as a selected element.
;
; CATEGORY:
;       BLViewer
;
; CALLING SEQUENCE:
;       SHOW_ELEMENT, pInfo
;
; INPUTS:
;		pInfo: A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;		none
;
; EXAMPLE:;
;       SHOW_ELEMENT, pInfo
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-
;**********show_element******************
pro blv_show_element, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_show_element: error caught: '+!error_state.msg)
   RETURN
ENDIF


if (*pinfo).data.position eq -1 then return
module=(*pInfo).data.system->get_module(pos=(*pinfo).data.position)
module->setProperty, selected=1
module->trace
end
