;+
; NAME:
;       beam_define.
;
; PURPOSE:
;       This file define the beam class. The beam object is used to keep 
;	optical rays.
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;       beam=obj_new('beam')
;
; INPUTS:
;		none
;
; EXAMPLE:;;		..
;       beam=obj_new('beam')
;		rayon=[x, y, z, dx, dy, dz, flagOut]
;		beam->add, rayon
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-
;***************************
;purpose:the init procedure
function beam::init
;self.rayon=obj_new('idl_container')
self.pRayon=ptr_new(fltArr(1,7))
return, 1
end

;***************************
pro beam::read_from_shadow_file,file
Forward_Function GetShCol
;purpose: put a shadow file in the beam Added by srio
;clean
rayon = GetShCol(file,[0,1,2,3,4,5,9])
;help,rayon
ptr_free, self.pRayon
self.pRayon=ptr_new([fltArr(1,7),Transpose(rayon)], /no_copy)
END



;***************************
;purpose: add rayon vector to the list (n*7) vector
pro beam::add, rays
sold=(size(*(self.pRayon)))[1]
srays=(size(rays))[1]
snew=sold+srays
rayon=fltarr(snew,7)
rayon[0:sold-1,*]=[*(self.pRayon)]
rayon[sold:snew-1,*]=rays
ptr_free, self.pRayon
self.pRayon=ptr_new(rayon, /no_copy)

;self.rayon->add, rayon
end
;***********************
;purpose: return the number of rays in the beam
function beam::count
n=(size(*(self.pRayon)))[1]-1
return, n
end

;***********************
;purpose: calculate limits
PRO beam::getLimits,xrange=xrange,yrange=yrange,zrange=zrange
  rayon=(*(self.pRayon))
  rayon=rayon[1:(size(rayon))[1]-1,*]
  x=rayon[*,0] & y=rayon[*,1] & z=rayon[*,2]
  xrange=[min(x),max(x)]
  yrange=[min(y),max(y)]
  zrange=[min(z),max(z)]
END



;**********************
;purpose: return the ray keep at the 'pos' position
function beam::get, pos
IF N_Elements(pos) EQ 0 THEN BEGIN
  rayon=(*(self.pRayon)) 
  rayon=rayon[1:(size(rayon))[1]-1,*]
ENDIF ELSE rayon=(*(self.pRayon))[pos+1,*]
return, rayon
end
;****************************
;purpose: the cleanUp procedure
pro beam::cleanUp
ptr_free, self.pRayon
end
;*****************************
;purpose: the define procedure
pro beam__define
;rayon=obj_new()
pRayon=ptr_new(fltArr(1,7))

struct={ beam, $
			;rayon:rayon $ ;to keep rayon
			pRayon:pRayon $
		}
end

