;		
;========================================================================
;

Pro xshscr_modify,oestr,nn,GROUP=group,ACTION=action

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHSCR_MODIFY: Error caught: '+$
	!err_string,/error)
   return
endif

if n_elements(oestr) EQ 0 then oestr=read_gfile('exafin.exa')
if n_elements(nn) EQ 0 then nn=1
ni = nn-1

titles=[ 'Position rel. to mirror',$
  'Distance (abs) from mirror',$
  'Aperturing',$
  'Open slit/Solid stop',$
  'Aperture shape',$
  'Slit width/  x-axis',$
  'Slit heigth/ z-axis',$
  'Slit center/  x-axis',$
  'Slit center/  z-axis',$
  'External file with coordinate',$
  'Absorption',$
  'Thickness [ CM ]',$
  'Opt. Const. File-name'] 

flags = ['1',$		;
  '1',$			;
  '1',$			; 2 Aperturing
  'w(2) EQ 1',$			;
  'w(2) EQ 1',$			; 4 rectang/ell/external
  'w(2) EQ 1 AND w(4) NE 2',$			;
  'w(2) EQ 1 AND w(4) NE 2',$			;
  'w(2) EQ 1 AND w(4) NE 2',$			;
  'w(2) EQ 1 AND w(4) NE 2',$			;
  'w(2) EQ 1 AND w(4) EQ 2',$			;
  '1',$			; 10 absorption
  'w(10) EQ 1',$			;
  'w(10) EQ 1']			;
  

tmp =    {    I_SCREEN:[strcompress(oestr.I_SCREEN(ni),/Rem),'After','Before'],$
   SL_DIS:oestr.SL_DIS(ni), $
   I_SLIT:[strcompress(oestr.I_SLIT(ni),/Rem),'No','Yes'],$
   I_STOP:[strcompress(oestr.I_STOP(ni),/Rem),$
	'aperture/slit','obstruction/stop'],$
   K_SLIT:[strcompress(oestr.K_SLIT(ni),/Rem),'Rectangular','Ellipse',$
	'External'],$
   RX_SLIT:oestr.RX_SLIT(ni), $
   RZ_SLIT:oestr.RZ_SLIT(ni), $
   CX_SLIT:oestr.CX_SLIT(ni), $
   CZ_SLIT:oestr.CZ_SLIT(ni), $
   FILE_SCR_EXT:oestr.FILE_SCR_EXT(ni), $
   I_ABS:[strcompress(oestr.I_ABS(ni),/Rem),'No','Yes'],$
   THICK:oestr.THICK(ni), $
   FILE_ABS:oestr.FILE_ABS(ni) }

action=0
XScrMenu,tmp,/NOTYPE,/INTERPRET,wtitle='Screen/Slit/Filter #'+$
  strcompress(nn,/Rem),FLAGS=flags,TITLES=titles,ACTION=action,GROUP=group,$
  NCOL=3

if action eq 'DONT' then return

oestr.I_SCREEN(ni) = fix(tmp.I_SCREEN(0))
oestr.SL_DIS(ni) = tmp.SL_DIS
oestr.I_SLIT(ni) = fix(tmp.I_SLIT(0))
oestr.I_STOP(ni) = fix(tmp.I_STOP(0))
oestr.K_SLIT(ni) = fix(tmp.K_SLIT(0))
oestr.RX_SLIT(ni) = tmp.RX_SLIT
oestr.RZ_SLIT(ni) = tmp.RZ_SLIT
oestr.CX_SLIT(ni) = tmp.CX_SLIT
oestr.CZ_SLIT(ni) = tmp.CZ_SLIT
oestr.FILE_SCR_EXT(ni) = tmp.FILE_SCR_EXT
oestr.I_ABS(ni) = fix(tmp.I_ABS(0))
oestr.THICK(ni) = tmp.THICK
oestr.FILE_ABS(ni) = tmp.FILE_ABS

return
end

; 
;===============================================================================
;
Pro xshscr_copy,oestr_input,i_from,i_to,GROUP=group,verbose=verbose

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHSCR_COPY: Error caught: '+$
	!err_string,/error)
   return
endif

oestr = oestr_input

if i_from GT 10 or i_to GT 10 then begin
  message,/info,'Cannot copy from screen '+strcompress(i_from)+' to '+$
	strcompress(i_to)
  return
endif

if keyword_set(verbose) then $
  message,/info,'Copying from screen '+strcompress(i_from)+' to '+$
	strcompress(i_to)

; convert from screen number to screen index

ii_to = i_to - 1
ii_from = i_from - 1

oestr.I_SCREEN(ii_to) = oestr.I_SCREEN(ii_from) 
oestr.SL_DIS(ii_to) = oestr.SL_DIS(ii_from) 
oestr.I_SLIT(ii_to) = oestr.I_SLIT(ii_from) 
oestr.I_STOP(ii_to) = oestr.I_STOP(ii_from) 
oestr.K_SLIT(ii_to) = oestr.K_SLIT(ii_from) 
oestr.RX_SLIT(ii_to) = oestr.RX_SLIT(ii_from) 
oestr.RZ_SLIT(ii_to) = oestr.RZ_SLIT(ii_from) 
oestr.CX_SLIT(ii_to) = oestr.CX_SLIT(ii_from) 
oestr.CZ_SLIT(ii_to) = oestr.CZ_SLIT(ii_from) 
oestr.FILE_SCR_EXT(ii_to) = oestr.FILE_SCR_EXT(ii_from) 
oestr.I_ABS(ii_to) = oestr.I_ABS(ii_from) 
oestr.THICK(ii_to) = oestr.THICK(ii_from) 
oestr.FILE_ABS(ii_to) = oestr.FILE_ABS(ii_from) 

oestr_input = oestr
end

;		
;========================================================================
;

PRO xshscr_update,state,add=add,delete=delete,group=group,$
  alldelete=alldelete

f_insert = 0
f_del  = 0
nn =  state.oestr.n_screen
if keyword_set(add) then begin
  if Widget_Info(state.wids.select,/Valid) then begin
    Widget_Control,state.wids.select,Get_Value=nsel
    nsel=nsel+1
  endif else nsel=0
  if nsel NE nn then begin
    itmp = Dialog_Message(Dialog_Parent=group,$
      ['This option will insert a new screen after the screen number '+$
	strcompress(nsel),'Please confirm:'],/Cancel)
    if itmp EQ 'Cancel' then return
    f_insert = 1
  endif
  ; add screen and poit to the added one
  nsel = nsel+1
  nn = nn+1
endif

if keyword_set(delete) then begin
  if not( Widget_Info(state.wids.select,/Valid) ) then return
  Widget_Control,state.wids.select,Get_Value = delete_n
  delete_n = delete_n + 1
  nsel = delete_n - 1 > 1
  itmp = Dialog_Message(Dialog_Parent=group,$
    ['This option will remove screen number '+strcompress(delete_n),$
       'Please confirm:'],/Cancel)
  if itmp EQ 'Cancel' then return
  if delete_n NE nn then f_del = 1
  nn =  nn-1
endif

if keyword_set(alldelete) then begin
  if not( Widget_Info(state.wids.select,/Valid) ) then return
  itmp = Dialog_Message(Dialog_Parent=group,$
    ['This option will remove all defined screens',$
       'Please confirm:'],/Cancel)
  if itmp EQ 'Cancel' then return
  nn = 0
endif

if nn GT 10 then begin
  itmp = Dialog_Message(/Error,Dialog_Parent=group,$
  'Maximum number of screens is 10')
  return
endif

if Widget_Info(state.wids.select,/Valid) then $
  widget_control,state.wids.select,/Destroy

;help,nn
;help,f_insert
;help,f_del
;help,nsel

if nn gt 0 then begin
  wtmp = CW_BGroup(state.wids.selectbase,$
    strcompress(indgen(nn)+1),/Exclusive,UVALUE='SELECT',COLUMN=10, $
    Set_Value=nsel-1>0)
  state.wids.select = wtmp
endif

if f_insert EQ 1 then begin
  ;for i=nn,nsel+1,-1 do print,'moved screen to ',i,' from',i-1
  for i=nn,nsel+1,-1 do xshscr_copy,state.oestr,i-1,i,/verbose
  ;print,'inserted screen #',nsel
  xshscr_copy,state.oestr,10,nsel,/verbose
endif
if f_del EQ 1 then begin
  ;print,'deleted screen #',delete_n
  ;for i=delete_n+1,nn+1 do print,'moved screen to ',i-1,' from',i
  for i=delete_n+1,nn+1 do xshscr_copy,state.oestr,i,i-1,/verbose
endif

state.oestr.n_screen = nn
if nn EQ 0 then state.oestr.f_screen=0 else state.oestr.f_screen=1
end
;		
;========================================================================
;

PRO xshscr_event,event

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHSCR_EVENT: Error caught: '+$
	!err_string,/error)
   goto,out
endif

stateid = widget_info(event.handler,/Child)
;help,stateid
Widget_Control,stateid,Get_UValue=state,/No_Copy
Widget_Control,event.id,Get_UValue=uval
;help,uval

CASE uval OF
  'DONE': BEGIN
	handle_Value,state.h_action,'DO',/Set
	handle_Value,state.h_oe,state.oestr,/Set
	Widget_Control,event.top,/Destroy
	Return
	END
  'CANCEL': BEGIN
	handle_Value,state.h_action,'DONT',/Set
	Widget_Control,event.top,/Destroy
	Return
	END
  'ADD': BEGIN
	xshscr_update,state,/add,group=event.top
	END
  'MODIFY': BEGIN
	if not(Widget_Info(state.wids.select,/Valid)) then goto,out
	Widget_Control,/HourGlass
	Widget_Control,state.wids.select,Get_Value=nsel
	nsel=nsel+1
        tmpstr = state.oestr
	action = 0
	xshscr_modify,tmpstr,nsel,GROUP=event.top,ACTION=action
        if action EQ 'DONT' then goto,out
        state.oestr = tmpstr
	END
  'DELETE': BEGIN
	xshscr_update,state,/delete,group=event.top
	END
  'DELETEALL': BEGIN
	xshscr_update,state,/alldelete,group=event.top
	END
;  'SELECT': BEGIN
;	Widget_Control,event.id,Get_Value = val
;	help,val
;	END
  ELSE: BEGIN
	END
ENDCASE


out:
IF widget_info(stateid,/Valid_Id) THEN $
  Widget_Control,stateid,Set_UValue=state,/No_Copy
END


;		
;========================================================================
;
Pro xshscr,oestr,ACTION=action,Group=group, Wtitle=wtitle

IF NOT(KEYWORD_SET(wtitle)) THEN wtitle='Screen Manager'

if n_elements(oestr) EQ 0 then oestr=read_gfile('exafin.exa')


;
; start creating widgets

base1=Widget_Base(Column=1,Title=wtitle)
Widget_Center,base1,Parent=group

butbase=Widget_Base(base1,Row=1)
  doner=Widget_Button(butbase,Value='Accept',UValue='DONE')
  canceler=Widget_Button(butbase,Value='Cancel',UValue='CANCEL')

para=Widget_Base(base1,Column=1) 

;
; Action
;
wtmp0=Widget_Base(para,Row=1)
wtmp = Widget_Button(wtmp0,VALUE='Add screen',UVALUE='ADD')
wtmp = Widget_Button(wtmp0,VALUE='Modify screen...',UVALUE='MODIFY')
wtmp = Widget_Button(wtmp0,VALUE='Delete screen',UVALUE='DELETE')
wtmp = Widget_Button(wtmp0,VALUE='Delete all',UVALUE='DELETEALL')
;but = {label:'',icon:'',help:''}
;my_buttons = replicate(but,6)
;my_buttons.label=['Done','Cancel','Add','Modify...','Delete','Delete all']
;my_buttons.help=['Exit screen manager and accept changes',$
;  'Exit screen manager and discard changes',$
;  'Add a new screen after selected one',$
;  'Modify parameters of the selected screen',$
;  'Delete selected screen',$
;  'Delete all screens']
;wcw = cw_toolbar(wtmp0,value=my_buttons,event_pro='xshscr_event',$
;  UVAL=['DONE','CANCEL','ADD','MODIFY','DELETE','DELETEALL'] )
;
;
; Select screen
;
wtmp0=Widget_Base(para,Col=1,/Frame)
title='Select screen:
wtmp=Widget_Label(wtmp0,value=title,/align_left)
wselectbase = Widget_Base(wtmp0)
n_screen = oestr.n_screen
; if oestr.f_screen EQ 0 then n_screen = 0 
if n_screen NE 0 then $
  wselect=CW_BGroup(wselectbase,strcompress(indgen(n_screen)+1),Col=10,$
 /Exclusive,UValue='SELECT',set_value=n_screen-1) else wselect = 0L
;
; end of widget definition 
;



Widget_Control,base1,/Realize

wids =	{ selectbase:wselectbase, select:wselect} 
   
;  xshoe_updatemain,wids,oestr

pointer=Handle_Create()
ac_pointer=Handle_Create()
                
state = {wids:wids, oestr:oestr, h_oe:pointer, h_action:ac_pointer }

;help,Widget_Info(base1,/Child)
Widget_Control,Widget_Info(base1,/Child),Set_UValue=state,/No_copy
XManager,'XSHSCR',base1,MODAL=1

action=0
Handle_Value,ac_pointer,action
Handle_Free,ac_pointer

if action EQ 'DO' then begin
  Handle_Value,pointer,retdata
  oestr = retdata
endif else begin
  retdata = oestr
endelse
Handle_Free,pointer

END
