function blv_create_optical_module_symbol, type_name, rlen1, rlen2, $
	rwidx1, rwidx2, prof, mesh_file=mesh_file

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_create_optical_module_symbol: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


case type_name of
	'Rectangle': begin
		symbol=blv_mirror_rect(rlen1, rlen2 , rwidx1, rwidx2, prof=prof)
	end
	'Ellipse': begin
		symbol=blv_mirror_ellip(rwidx2, rlen2, prof=prof)
	end
	'Ellipse with a hole': begin
		symbol=blv_mirror_ellip_hole(rlen1, rwidx1, rlen2, rwidx2, $
			prof=prof)
	end
	'Infinite surface':begin
		symbol=blv_mirror_inf(rlen1, rwidx1, prof=prof)
	end
	'External (VRML)': begin
		if n_elements(mesh_file) ne 0 then begin
			if mesh_file eq 'undefined' then $
			file=Dialog_PickFile(title='Open Mesh...', /read, $
			filter='*.wrl') $
			else file=mesh_file
		endif else begin
			file=dialog_pickfile(title='Open Mesh...', /read, $
			filter='*.wrl')
			mesh_file=file
		endelse

		if file eq '' then begin
			return, obj_new('idlgrmodel')
		endif

		widget_control, /HOURGLASS
		symbol=read_vrml_file(file)
	end
	else : return, obj_new()
endcase
return, symbol
end
