;
;===============================================================================;

Pro xsh_histo1_controls_event,event


;
; Create the control window for XSh_Histo1
; To be used internally by XSh_Histo1
; srio@esrf.fr 98-03-03
;
Widget_Control, event.id, get_UValue=eventUValue
Widget_Control, event.id, get_Value=Value
 
if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''
 
stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy
 

Case eventUValue OF
    'SHOWHIDE': BEGIN
	IF state.wids.caller_id EQ 0L THEN BEGIN
	  Widget_control,event.top,/Destroy 
	  return
	ENDIF ELSE BEGIN
	  tmp = 0
          Widget_Control,state.wids.xrange,get_value=tmp
	  if tmp(0) EQ tmp(1) then (*(state.strptr)).default_xrange=1 else $
		(*(state.strptr)).default_xrange=0
          Widget_Control,state.wids.yrange,get_value=tmp
	  if tmp(0) EQ tmp(1) then (*(state.strptr)).default_yrange=1 else $
		(*(state.strptr)).default_yrange=0
	  newevent=event
	  newevent.handler=state.wids.caller_id
	  XSh_Histo1_Event,newevent
	ENDELSE
	Return
	END
    'APPLY': BEGIN
	IF state.wids.caller_id EQ 0L THEN BEGIN
	  itmp = Dialog_Message(Dialog_Parent=event.top, /Error,$
		'XSh_Histo1_Controls not called from XSh_Histo1')
	  GoTo,out
	ENDIF
	XSh_Histo1_PStr_Update,state.wids,state.strptr
	newevent=event
	newevent.handler=state.wids.caller_id
	XSh_Histo1_Event,newevent
	END
    'REDRAW': BEGIN
	index=0
	Widget_Control,event.id,Get_Value=index
	tmp = state.StrPtr
	(*tmp).AutoRefresh=index
	END
    else: BEGIN
	tmp = state.StrPtr
	IF (*tmp).AutoRefresh EQ 1 THEN BEGIN
	  XSh_Histo1_PStr_Update,state.wids,state.strptr
	  newevent=event
	  newevent.handler=state.wids.caller_id
	  newevent.id=state.wids.apply
	  XSh_Histo1_Event,newevent
	ENDIF
	END
EndCase


out:
Widget_Control, stateid, set_UValue=state, /No_Copy
end
;
;===============================================================================;

PRO xsh_histo1_controls, input, Group=Group, TLB_ID=wbase, $
CALLER_ID=caller_id

on_error,2

IF NOT(Keyword_Set(caller_id)) THEN caller_id=0L
if NOT(Keyword_Set(input)) THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group, [ $
	'No input data given to XSh_Histo1_Controls','Using Default',$
	'(Creating Pointer that will not be deleted).'])
  input = Ptr_New(Xsh_Defaults_Results('XSH_HISTO1'))
endif

wbase=widget_base(/col,title='xsh_histo1_controls')
wtmp = widget_base(wbase) ; to store state

;
; main buttons
;
wtmp0 = widget_base(wbase,/Row) 
  wtmp = widget_button(wtmp0,Value='Close',UValue='SHOWHIDE')
  wapply = widget_button(wtmp0,Value='Refresh',UValue='APPLY')
  wtmp1 = widget_Base(wtmp0,/Row,/Frame)
  wtmp = widget_label(wtmp1,Value='AutoRefresh: ')
  wAutoRefresh = cw_bgroup(wtmp1,['No','Yes'],/Exclusive,Uvalue='REDRAW',$
	/Return_Index,/Row)
 
; 
; file & column selection
;
wtmp = Widget_Base(wbase,/Row)
  wshadow_in=cw_pickfile(wtmp,Value='begin.dat',/Frame)
  wcol = cw_xshcol(wtmp,Value='1',Title='Column:',/Column,/Frame,UValue='COL')

wtmp0=Widget_Base(wbase,Row=1,/Frame) ;,UValue=hist_control_tlb)
  wxrange=CW_ARRAY(wtmp0,Value=[0.0,0.0],Title='XRange',/Column,$
	/Default,UValue='XRAN',Names=['Minumum','Maximum'])
  wyrange=CW_ARRAY(wtmp0,Value=[0.0,0.0],Title='YRange',/Column,$
	/Default,UValue='YRAN',Names=['Minumum','Maximum'])

;
; refl, losses, 
;
wtmp = Widget_Base(wbase,/Col,/Frame)
  reflecter=['0','No','Yes',$
	'22:|E|',$
	'23:|E|^2 (total intensity)',$
	'24:total int for s-pol',$
	'25:total int for p-pol',$
	'30:S0=|Es|^2 + |Ep|^2',$
	'31:S1=|Es|^2 - |Ep|^2',$
	'32:S2=2|Es|.|Ep|cos(p_s-p_p)',$
	'33:S3=2|Es|.|Ep|sin(p_s-p_p)']
  wreflectivity=cw_droplist(wtmp,Value=reflecter,Title=$
    'Include Reflectivity (weight)? ',UValue='REF')
  loster=['0','All rays','Good Only','Lost Only']
  wnolost=cw_droplist(wtmp,Value=loster,Title='Rays: ',$
	UValue='NOLOST')

wtmp0 = Widget_Base(wbase,/Col,/Frame)
  wtmp1 = Widget_Base(wtmp0,/row)
    wtmp = Widget_Label(wtmp1,Value='Number of bins: ')
    wNbins = widget_slider(wtmp1, /FRAME, MIN=1,MAX=100,XSIZE=205)
wtmp0 = Widget_Base(wbase,/row,/Frame)
  wcalfwhm = CW_Droplist(wtmp0,Title='Calculate FWHM?: ', $
      Value=['0','No','Yes'])
  wgaussfit = CW_Droplist(wtmp0,Title='Fit?: ', $
      Value=['0','No','Gauss+2nd deg pol','Gauss','PseudoVoigt','Lorentzian'])


wtmp0 = Widget_Base(wbase,/row,/Frame)
wwrite=cw_droplist(wtmp0,Value=['0','No','Yes'],Title=$
  'Write Histogram to file (HISTO1)?: ',UValue='WRITE')
wpublish=cw_droplist(wtmp0,Value=['0','No','Yes'],Title=$
  'Publication?: ',UValue='PUBLISH')

;
; titles
;
wtmp0 = Widget_Base(wbase,/Col,/Frame)
  wtmp = Widget_Label(wtmp0,Value='Titles: ')
  wtitle=cw_field (wtmp0,XSize=60,Value='',Title='Top  ',/String,$
	UVal='TITLE',/Return_Events)
  wxtitle=cw_field(wtmp0,XSize=60,Value='',Title='Horiz.',/String,$
	UVal='XTITLE',/Return_Events)
  wytitle=cw_field(wtmp0,XSize=60,Value='',Title='Vert. ',/String,$
	UVal='YTITLE',/Return_Events)

wids={ shadow_in:wshadow_in, col:wcol, xrange:wxrange, yrange:wyrange, $
  nolost:wnolost, nbins:wnbins, calfwhm:wcalfwhm, reflectivity:wreflectivity, $
  write:wwrite, title:wtitle, xtitle:wxtitle, ytitle:wytitle,$
  gaussfit:wgaussfit,publish:wpublish, $
  autorefresh:wAutoRefresh, caller_id:caller_ID, apply:wapply }
state = {wids:wids, strptr:input}

xsh_histo1_controls_update,wids,input
widget_control,Widget_Info(wbase,/Child),set_uvalue=state,/no_copy
widget_control,wbase,/realize
xmanager,'xsh_histo1_controls',wbase,GROUP=group,/No_Block

END
