PRO shadow_setifcpar,parent=iparent,name,value,source=source,trace=trace,$
   index=index
;

;+
; NAME:
;	SHADOW_SETIFCPAR
; PURPOSE:
;	Scripting SHADOWVUI RUNS
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	shadow_setIfcPar,variable,new_value
; INPUTS:
;	variable: The name of the variable (as named in start.xx files)
;	to be changed
;	new_value: The new value of the variable
; KEYWORD PARAMETERS:
;	PARENT = The widget Id of the SHADOWVui window where the value
;		will be changed. If undefined, it takes the current
;		ShadowVui window.
;	SOURCE  = Set to the source type when VARIABLE affects the source.
;		Use Sorce=0 (geometrical), 1 (BM), 2 (Wiggler) 3 Undulator.
;	TRACE = Set to the oe index (e.g., trace=0 for oe1, etc)
;	INDEX = When VARIABLE is an array, use this keyword to select 
;		the index of VARIABLE to be changed. 
;	
; OUTPUTS:
;	Changes the corresponding VARIABLE in ShadowVui window
;
; COMMON BLOCKS:
;	COMMON shadow_ifc,parent1
;	(to allow working without defining PARENT)
;
; EXAMPLE: 
;       ; starts ShadowVUI
;	shadow,parent=p1  
;       ; loads a ws
;	shadow_loadws,p1,file='beamEvol.ws',/norun 
;       ; change number of rays
;	shadow_setIfcPar,parent=p1,'npoint',6000,source=0 
;       ; change asymm angle for oe2
;	shadow_setIfcPar,parent=p1,'a_bragg',12,trace=1 
;	; run shadow
;	shadow_run,p1,/source,/trace
;
; MODOFICATION HISTORY:
;	M. Sanchez del Rio
;       2007/10/09 srio@esrf.eu adds doc and fixes a small bug. 
;
;-

COMMON shadow_ifc,parent1

IF N_Elements(index) EQ 0 THEN index=0

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /Cancel
   Message,/Info,'Error caught: '+!err_string
   itmp = Dialog_Message('SHADOW_SETIFCPAR: Error caught: '+$
	!err_string,/Error,Dialog_Parent=group)
   RETURN
ENDIF

IF Keyword_Set(iparent) THEN BEGIN
  widget_control,iparent,get_uvalue=state
ENDIF ELSE BEGIN
  widget_control,parent1,get_uvalue=state
ENDELSE

IF N_Elements(source) NE 0 THEN BEGIN
  isource=source 
  ps=(state.ptrsrc)[isource]
ENDIF 
IF N_Elements(trace) NE 0 THEN BEGIN
  itrace=trace 
  ps=(state.ptrtrc)[itrace]
ENDIF 

IF Ptr_Valid(ps) NE 1 THEN BEGIN
    itmp = Dialog_Message(/Error, $
	'Undefined source or system', $
	Dialog_Parent=parent1)
    RETURN
ENDIF
tnames=tag_names(*ps)
itmp = Where(tnames EQ StrUpcase(name))
IF itmp[0] EQ -1 THEN BEGIN
  itmp = Dialog_Message(/Error,'Variable unknown: '+name, $
	Dialog_Parent=parent1)
  RETURN
ENDIF
arr = ((*ps).(itmp[0]))
arr[index] = value
((*ps).(itmp[0]))=arr
   
END
