PRO putrays,shinp,fname,splitn=splitn
;+
; NAME:
;	PUTRAYS
; PURPOSE:
;       Similar to RWNAME in shadow library.
;       Writes fortran77 unformatted shadow image file
;       and stores an idl/shadow structure.
; CATEGORY:
;	SHADOW
; CALLING SEQUENCE:
;	PUTRAYS,a,file
; INPUTS:
;	a: an idl/shadow structure or shadow file.
;	file: a file where structure has to be written.
; OUTPUTS:
;	a file on disk.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	Under Windows the Shadow file written with this application may
;	not be read from Fortran code (apparantly it can be read from 
;	SHADOW).
;	It is slow (to be improved).
; PROCEDURE:
;	Straightforward.
; EXAMPLE:
;	This examples reads a shadow file and change the flag
;	a=readsh('begin.dat')	; reads an existing file
;	a.ray(9,*) = -2		; puts flag column equal to -2
;	putrays,a,'begin2.dat'  ; writes the structure in a file
; MODIFICATION HISTORY:
;	31-May-96 by Manuel Sanchez del Rio (srio@esrf.fr)
;	97-11-12 srio@esrf.fr adapts for W95
;-
on_error,2
catch, error
if error NE 0 then begin
  message,'Cannot write file: '+fname,/info
  return
endif

case n_params() of
  0: begin
	message,"Usage: PUTRAYS,structure,'file'",/info
	return
     end
  1: fname = 'putrays.dat'
  else:
endcase

a=readsh(shinp)
syst = sdep()

if not(keyword_set(splitn)) then begin
  message,'Writing file '+fname+'...',/info
  if syst EQ 'UNIX' then begin
	openw,Unit,fname,/f77_unformatted,/get_lun 
	writeu,Unit,a.ncol,a.npoint,0L      ;write the header information
	for i = 1L,a.npoint do begin
	  ray = a.ray(*,i-1)
	  writeu,Unit,ray
	endfor
  endif else begin
  	openw,Unit,fname,/get_lun
	tmp = byte([12,0,0,0])
	writeu,Unit,tmp,a.ncol,a.npoint,0L,tmp      ;write the header information
	for i = 1L,a.npoint do begin
	  ray = a.ray(*,i-1)
	  writeu,Unit,tmp,ray,tmp
	endfor
  endelse
  free_lun,Unit
  message,'File '+fname+' writen to disk.',/info
endif else begin

  nfiles = fix(a.npoint/splitn) > 1
  for ii=1L,nfiles do begin
    fnamei = fname+'-'+strcompress(ii,/rem)
    message,'Writing file '+fnamei+'...',/info
    if syst EQ 'UNIX' then begin
	openw,Unit,fnamei,/f77_unformatted,/get_lun 
	writeu,Unit,a.ncol,splitn<(a.npoint),0L ;write the header information
	istart = (ii-1)*splitn
	iend = ii*splitn-1<(a.npoint-1)
	for jj=istart,iend do begin
	  ray = a.ray(*,jj)
	  writeu,Unit,ray 
	endfor
    endif else begin
    	openw,Unit,fnamei,/get_lun
	writeu,Unit,tmp,a.ncol,splitn<(a.npoint),0L,tmp ;write the header information
	istart = (ii-1)*splitn
	iend = ii*splitn-1<(a.npoint-1)
	for jj=istart,iend do begin
	  ray = a.ray(*,jj)
	  writeu,Unit,tmp,ray,tmp
	endfor
    endelse
    free_lun,Unit
    message,'File '+fnamei+' writen to disk.',/info
  endfor
endelse

end

