;+
; NAME:
;       TRANSPARENCY
;
; PURPOSE:
;       This procedure make transparency all the Polygone of a Graphic model.
;
; CATEGORY:
;       Graphic.
;
; CALLING SEQUENCE:
;       TRANSPARENCY, Model
;
; INPUTS:
;       Model:    An IDLGrModel object.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE
;	    TRANSPARENCY, Model
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-

;**************make a model and all its polygons transparenty

pro transparency, model

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'transparency: error caught: '+!error_state.msg)
   RETURN
ENDIF


	n=model->count()
	for p=0, n-1 do begin
		obj=model->get(pos=p)
		if OBJ_ISA(obj, 'IDLgrModel') then begin
			if n_elements(val) eq 0 then  transparency, obj $
			else if not strcmp(string(val),'constant') then  transparency, obj
		endif
		if OBJ_ISA(obj, 'IDLgrpolygon') then obj->setProperty, style=1
	endfor
end

