;+
; NAME:
;       OPTICAL_SYSTEM__DEFINE.
;
; PURPOSE:
;       This procedure defines the 'optical_system' object. An optical_system 
;		is used to buil an optical system: - an optical source
;						- several optical modules
;
; FIELD:
;		oModel: an idlGrModel to draw the 3D representation
;		oModules: an idlContainer of Modules
;		oSource: an Optical_source
;		dimension_scale:the scale of the modules (all its conponents)
;		dimensionElement_scale: the scale of the optical elements
;		distance_scale: the scale of the distance in the modules
;		log: the type of scale for the distance in the modules 
;			0 ->linear, 1->log
;		show_X: does X must be draw: 0->yes, 1->no
;			show_axis
;			show_plane_added
;			show_symbol
;			show_normal
;			show_axes_element
;		trans: does the optical elements must be transparent: 
;			0->yes, 1->no
;		rays_style: how does the rays must be draw:
;			0->points, 1->lines, 2->vectors
;		rays_type_toDraw: whitch rays must be draw:
;			0->all, 1->good only, 2->lost only, 3->none
;		vector_sensitive_source:scall to apply on the vector arrows 
;			of the source planes
;		vector_sensitive_element: the optical elements
;		vector_sensitive_image:the image planes
;		normal_scale:the scale of the normals
;		axes_element_scale: the scale of the element's axes
;		X_color: the RVB color of Xs
;			optical_element_color
;			optical_axes_color
;			optical_plane_color
;			normal_color
;			axes_element_color
;
; CATEGORY:
;       optical_system class.
;
; CALLING SEQUENCE:
;       system=obj_new('OPTICAL_System')
;
; INPUTS:
;		None
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:;
;
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by:  ESRF, EXP, May 2001
;
;-
;***********************************************
;purpose : the cleanup procedure
pro optical_system::cleanup
nb_module=self.oModules->count()

for pos=0, nb_module-1 do self->delete_module, posi=0
obj_destroy, self.oSource
obj_destroy, self.omodel
obj_destroy,self
end
;**********************************
;purpose : to draw the system
pro optical_system::trace, evolution=evolSys
if n_elements(evolSys) eq 0 then evolSys=100.
;print, 'evolsys: ', evolSys
nb_module=self.oModules->count()
if nb_module gt 0 then evolMax=100./nb_module
T=identity(4)
for pos=0, nb_module-1 do begin
	evolModule=nb_module*evolSys - pos*100
	if evolModule gt 100. then evolModule=100.
	if evolModule lt 0. then evolModule=0.
	;print, 'pos: ', pos, ' evolmodule: ', evolModule
	module=self->get_module(posi=pos)
	module->setProperty, transform=T
	module->trace, evolution=evolModule
	module->getProperty, out_transform=T
endfor
self.oSource->trace
end
;************************************************************
;purpose : changes the value of fields
pro optical_system::setProperty, dimension_scale=dimension_scale, $
								distance_scale=distance_scale, $
								show_axis=show_axis, $
								show_plane_added=show_plane_added, $
								show_symbol=show_symbol, $
								show_normal=show_normal, $
								show_axes_element=show_axes_element, $
								Log=log, $
								Transparen=transparen, $
								rays_style=rays_style, $
								rays_type_toDraw=rays_type_toDraw, $
								vector_sensitive_source=vector_sensitive_source, $
								vector_sensitive_element=vector_sensitive_element, $
								vector_sensitive_image=vector_sensitive_image, $
								optical_element_color=optical_element_color, $
								optical_axes_color=optical_axes_color, $
								optical_plane_color=optical_plane_color, $
								normal_color=normal_color, $
								normal_scale=normal_scale, $
								axes_element_scale=axes_element_scale, $
								axes_element_color=axes_element_color, $
								distEqual=distEqual, $
								flagEqual=flagEqual


if n_elements(dimension_scale) NE 0 then self.sParameter.dimension_scale=dimension_scale
;if n_elements(dimensionElement_scale) NE 0 then self.sParameter.dimensionElement_scale=dimensionElement_scale
if n_elements(distance_scale) NE 0 then self.sParameter.distance_scale=distance_scale
if n_elements(show_axis) NE 0 then begin
	self.sParameter.show_axis=show_axis
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, show_axis=self.sParameter.show_axis
	endfor
endif
if n_elements(show_plane_added) NE 0 then begin
	self.sParameter.show_plane_added=show_plane_added
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, show_plane_added=self.sParameter.show_plane_added
	endfor
endif
if n_elements(show_axes_element) NE 0 then begin
	self.sParameter.show_axes_element=show_axes_element
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, show_axes_element=self.sParameter.show_axes_element
	endfor
	source=self->get_source()
	source->setProperty, show_axisX=self.sParameter.show_axes_element, $
						show_axisY=self.sParameter.show_axes_element, $
						show_axisZ=self.sParameter.show_axes_element
endif

if n_elements(show_normal) NE 0 then begin
	self.sParameter.show_normal=show_normal
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, show_normal=self.sParameter.show_normal
	endfor
endif
if n_elements(show_symbol) NE 0 then begin
	self.sParameter.show_symbol=show_symbol
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, show_symbol=self.sParameter.show_symbol
	endfor
endif
if n_elements(log) NE 0 then begin
	self.sParameter.log=log
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, log=self.sParameter.log
	endfor
endif
if n_elements(transparen) NE 0 then begin
	self.sParameter.trans=transparen
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, transparen=self.sParameter.trans
	endfor
	source=self->get_source()
	source->setProperty, transparen=self.sParameter.trans
endif
if n_elements(rays_style) NE 0 then begin
	self.sParameter.rays_style=rays_style
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, rays_style=self.sParameter.rays_style
	endfor
endif
if n_elements(rays_type_toDraw) NE 0 then begin
	self.sParameter.rays_type_toDraw=rays_type_toDraw
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, rays_type_toDraw=self.sParameter.rays_type_toDraw
	endfor
endif
if n_elements(vector_sensitive_source) NE 0 then begin
	self.sParameter.vector_sensitive_source=vector_sensitive_source
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, vector_sensitive_source=self.sParameter.vector_sensitive_source
	endfor
endif
if n_elements(vector_sensitive_element) NE 0 then begin
	self.sParameter.vector_sensitive_element=vector_sensitive_element
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, vector_sensitive_element=self.sParameter.vector_sensitive_element
	endfor
endif
if n_elements(vector_sensitive_image) NE 0 then begin
	self.sParameter.vector_sensitive_image=vector_sensitive_image
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, vector_sensitive_image=self.sParameter.vector_sensitive_image
	endfor
endif
if n_elements(optical_element_color) NE 0 then begin
	self.sParameter.optical_element_color=optical_element_color
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, optical_element_color=self.sParameter.optical_element_color
	endfor
endif
if n_elements(optical_axes_color) NE 0 then begin
	self.sParameter.optical_axes_color=optical_axes_color
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, optical_axes_color=self.sParameter.optical_axes_color
	endfor
endif
if n_elements(optical_plane_color) NE 0 then begin
	self.sParameter.optical_plane_color=optical_plane_color
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, optical_plane_color=self.sParameter.optical_Plane_color
	endfor
endif
if n_elements(normal_color) NE 0 then begin
	self.sParameter.normal_color=normal_color
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, normal_color=self.sParameter.normal_color
	endfor
endif
if n_elements(normal_scale) NE 0 then begin
	self.sParameter.normal_scale=normal_scale
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, normal_scale=self.sParameter.normal_scale
	endfor
endif
if n_elements(axes_element_scale) NE 0 then begin
	self.sParameter.axes_element_scale=axes_element_scale
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, axes_element_scale=self.sParameter.axes_element_scale
	endfor
	source=self->get_source()
	source->setProperty, axis_scale=self.sParameter.axes_element_scale
endif
if n_elements(axes_element_color) NE 0 then begin
	self.sParameter.axes_element_color=axes_element_color
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, axes_element_color=self.sParameter.axes_element_color
	endfor
	source=self->get_source()
	source->setProperty, axis_color=self.sParameter.axes_element_color
endif
if n_elements(distEqual) then self.sParameter.distEqual=distEqual
if n_elements(flagEqual) then self.sParameter.flagEqual=flagEqual
end
;****************************************************************
;purpose : gets the value of fields
pro optical_system::getProperty, dimension_scale=dimension_scale, $
								distance_scale=distance_scale, $
								show_axis=show_axis, $
								show_plane_added=show_plane_added, $
								show_symbol=show_symbol, $
								show_normal=show_normal, $
								show_axes_element=show_axes_element, $
								Log=log, $
								Transparen=transparen, $
								rays_style=rays_style, $
								rays_type_toDraw=rays_type_toDraw, $
								vector_sensitive_source=vector_sensitive_source, $
								vector_sensitive_element=vector_sensitive_element, $
								vector_sensitive_image=vector_sensitive_image, $
								optical_element_color=optical_element_color, $
								optical_axes_color=optical_axes_color, $
								optical_plane_color=optical_plane_color, $
								normal_color=normal_color, $
								normal_scale=normal_scale, $
								axes_element_scale=axes_element_scale, $
								axes_element_color=axes_element_color, $
								oModel=oModel, $
								distEqual=distEqual, $
								flagEqual=flagEqual


show_axis=self.sParameter.show_axis
show_plane_added=self.sParameter.show_plane_added
show_symbol=self.sParameter.show_symbol
show_normal=self.sParameter.show_normal
show_axes_element=self.sParameter.show_axes_element
dimension_scale=self.sParameter.dimension_scale
distance_scale=self.sParameter.distance_scale
log=self.sParameter.log
transparen=self.sParameter.trans
rays_style=self.sParameter.rays_style
rays_type_toDraw=self.sParameter.rays_type_toDraw
oModel=self.oModel
vector_sensitive_source=self.sparameter.vector_sensitive_source
vector_sensitive_element=self.sparameter.vector_sensitive_element
vector_sensitive_image=self.sparameter.vector_sensitive_image
optical_element_color=self.sparameter.optical_element_color
optical_axes_color=self.sparameter.optical_axes_color
optical_plane_color=self.sparameter.optical_plane_color
normal_color=self.sparameter.normal_color
normal_scale=self.sparameter.normal_scale
axes_element_scale=self.sparameter.axes_element_scale
axes_element_color=self.sparameter.axes_element_color
distEqual=self.sparameter.distEqual
flagEqual=self.sparameter.flagequal

end
;*******************************************
; purpose: to apply parameters to all modules of the system
pro optical_system::update_parameter_all
n=self->count()
for pos=0, n-1 do begin
	self->upDate_parameter_module, pos
endfor
end
;******************************************
; purpose: to apply parameters to one module
pro optical_system::update_parameter_module, posi

module=self->get_module(posi=posi)
module->setProperty, show_axis=self.sParameter.show_axis, $
					show_plane_added=self.sParameter.show_plane_added, $
					show_symbol=self.sParameter.show_symbol, $
					show_normal=self.sParameter.show_normal, $
					log=self.sParameter.log,$
					transparen=self.sParameter.trans, $
					show_axes_element=self.sParameter.show_axes_element, $
					rays_style=self.sParameter.rays_style, $
					rays_type_toDraw=self.sParameter.rays_type_toDraw, $
					vector_sensitive_source=self.sparameter.vector_sensitive_source, $
					vector_sensitive_element=self.sparameter.vector_sensitive_element, $
					vector_sensitive_image=self.sparameter.vector_sensitive_image, $
					optical_element_color=self.sparameter.optical_element_color, $
					optical_axes_color=self.sparameter.optical_axes_color, $
					optical_plane_color=self.sparameter.optical_plane_color, $
					normal_color=self.sparameter.normal_color, $
					normal_scale=self.sparameter.normal_scale, $
					axes_element_scale=self.sparameter.axes_element_scale, $
					axes_element_color=self.sparameter.axes_element_color

end
;*******************************************
;purpose : to add a module at the position 'posi'
pro optical_system::add_module, module, position=posi
if n_elements(posi) eq 0 then posi=self->count()
if obj_isa(module, 'optical_module') then begin
	self.oModules->add, module, posi=posi
	module->getProperty, graphic=model
	self.oModel->add, model, posi=posi
	self->update_parameter_module, posi
	module->setProperty, parent=self
	if posi gt 0 then begin
		prec=self->get_module(pos=posi-1)
		prec->getProperty, out_transform=T
		module->setProperty, transform=T
	endif
endif else begin
	message, 'Object must be an Optical_Module'
endelse
end
;********************************************
;purpose : to get the number of modules in the system
function optical_system::count
return, self.oModules->count()
end
;**************************************
;purpose : to remove a module of the system
pro optical_system::remove_module, position=pos
if n_elements(pos) eq 0 then pos=0
module=self.oModules->get(pos=pos)
module->setProperty, parent=obj_new()

self.oModules->remove, module

module->getProperty, graphic=graphic
self.oModel->remove, graphic
end
;**********************************************
;purpose : to remove a module of the system and delete it from memory
pro optical_system::delete_module, position=pos
if n_elements(pos) eq 0 then pos=0
module=self.oModules->get(pos=pos)
self.oModules->remove, module
obj_destroy, module
end
;************************************************
;purpose : to delete the beam of the optical system's modules
pro optical_system::delete_beam
nb_module=self.oModules->count()
for pos=0, nb_module-1 do begin
	module=self.oModules->get(pos=pos)
	module->delete_beam
endfor
end
;********************************************
;purpose : to get a module of the system
function optical_system::get_module, position=pos
if n_elements(pos) eq 0 then pos=0
module=self.oModules->get(pos=pos)
return, module
end
;*********************************************
;purpose : to get the source of the system
function optical_system::get_source
return, self.oSource
end
;**********************************************
;purpose: the init function
function optical_system::init
self.oSource=obj_new('optical_source')
self.oModules=obj_new('idl_container')
self.oModel=obj_new('idlGrModel')
self.oSource->getProperty, graphic=model_source
self.oSource->setProperty, parent=self
self.oModel->add, model_source
self.sparameter.dimension_scale=1.
self.sparameter.distance_scale=1.
self.sparameter.log=0
self.sparameter.show_axis=0 ; 0 means visible
self.sparameter.show_plane_added=0
self.sparameter.show_symbol=0
self.sparameter.show_normal=0
self.sparameter.show_axes_element=0
self.sparameter.trans=0
self.sparameter.log=1
self.sparameter.rays_style=0
self.sparameter.rays_type_toDraw=0
self.sparameter.vector_sensitive_source=1.
self.sparameter.vector_sensitive_element=1.
self.sparameter.vector_sensitive_image=1.
self.sparameter.optical_element_color=[110,110,255]
self.sparameter.optical_axes_color=[255,110,110]
self.sparameter.optical_plane_color=[110,255,110]
self.sparameter.normal_color=[255,255,0]
self.sparameter.normal_scale=1.0
self.sparameter.axes_element_scale=1.0
self.sparameter.axes_element_color=[255, 255, 255]
self.sparameter.distEqual=10.
self.sparameter.flagEqual=0
return, 1
end
;**********************************************
;purpose ; to change field's value function to their current value
pro optical_system::flip, show_axis=sa, $
			show_symbol=ss, $
			show_normal=sn, $
			transparen=transparen, $
			show_axes_element=sae, $
			log=log

if n_elements(sa) ne 0 then begin
	self.sParameter.show_axis=abs(self.sParameter.show_axis-1)
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, show_axis=self.sParameter.show_axis
	endfor
endif
if n_elements(ss) ne 0 then begin
	self.sParameter.show_symbol=abs(self.sParameter.show_symbol-1)
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, show_symbol=self.sParameter.show_symbol
	endfor
endif
if n_elements(sn) ne 0 then begin
	self.sParameter.show_normal=abs(self.sParameter.show_normal-1)
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, show_normal=self.sParameter.show_normal
	endfor
endif
if n_elements(transparen) ne 0 then begin
	self.sParameter.trans=abs(self.sParameter.trans-1)
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, transparen=self.sParameter.trans
	endfor
endif
if n_elements(log) ne 0 then begin
	self.sParameter.log=abs(self.sParameter.log-1)
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, log=self.sParameter.log
	endfor
endif
if n_elements(sae) ne 0 then begin
	self.sParameter.show_axes_element=abs(self.sParameter.show_axes_element-1)
	n=self->count()
	for pos=0, n-1 do begin
		module=self->get_module(posi=pos)
		module->setProperty, show_axes_element=self.sParameter.show_axes_element
	endfor
endif

end
;********************************************************************
;purpose: the define procedure
pro optical_system__define
oModules=obj_new()
oModel=obj_new()
oSource=obj_new()
flt=0.
int=0

sParameter={general_parameters, $

			dimension_scale:flt, $
			distance_scale:flt, $
			show_axis:int, $
			show_plane_added:int, $
			show_symbol:int, $
			show_normal:int, $
			show_axes_element:int, $
			trans:int, $
			log:int,$
			rays_style:int, $
			rays_type_toDraw:int, $
			vector_sensitive_source:flt, $
			vector_sensitive_element:flt, $
			vector_sensitive_image:flt, $

			optical_element_color:[int,int,int], $
			optical_axes_color:[int,int,int], $
			optical_plane_color:[int,int,int], $
			normal_color:[int,int,int], $
			normal_scale:flt, $
			axes_element_scale:flt, $
			axes_element_color:[int, int, int], $

			distEqual:flt, $
			flagEqual:int $
			}

struct={optical_system, $
		oModules:oModules, $
		oModel:oModel, $
		oSource:oSource, $
		sParameter:sParameter $
		}
end
