
;+
; NAME:
;       blv_set_angle
;
; PURPOSE:
;       This function create a modal widget base with all the field 
;		necessary to control the 3 orientation's angle of the view 
;		in blViewer. this 3 value can be save as
;		the default perspective view.
;
; CATEGORY:
;       optic.
;
; CALLING SEQUENCE:
;       blv_set_angle, pInfo
;
; INPUTS:
;		pInfo: the uValue of the blViewer widget base
;
; EXAMPLE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, 2001
;-

;******************************************
;purpose : change the current view orientation function to widgets
pro blv_set_angle_work_event, event


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_set_angle_work_event: error caught: '+!error_state.msg)
   RETURN
ENDIF



widget_control, event.top, get_uvalue=pInfoAngle
slider=widget_info( event.id,/uname)

case slider of
	'x':begin
		widget_control, (*pinfoAngle).wsliderX, get_value=x
		(*pinfoAngle).x=x
		end
	'y':begin
		widget_control, (*pinfoAngle).wsliderY, get_value=y
		(*pinfoAngle).y=y
		end
	'z':begin
		widget_control, (*pinfoAngle).wsliderZ, get_value=z
		(*pinfoAngle).z=z
		end
	else:; nothing
endcase
(*(*pinfoAngle).pInfo).wid.model->reset
(*(*pinfoAngle).pInfo).wid.model->rotate, [1,0,0], (*pinfoAngle).x
(*(*pinfoAngle).pInfo).wid.model->rotate, [0,1,0], (*pinfoAngle).y
(*(*pinfoAngle).pInfo).wid.model->rotate, [0,0,1], (*pinfoAngle).z

blv_draw_system, (*pinfoAngle).pInfo
end
;
;=====================================================================================================
;
PRO blv_set_angle_event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_set_angle_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


Widget_Control,event.id, Get_UValue=uvalue


CASE uvalue OF

	'blv_reset_angle_work': BEGIN
		;purpose : reset the 3 angles to their default value.
		widget_control, event.top, get_uvalue=pInfoAngle
		x=203
		y=220
		z=56
		widget_control, (*pinfoAngle).wsliderX, set_value=x
		widget_control, (*pinfoAngle).wsliderY, set_value=y
		widget_control, (*pinfoAngle).wsliderZ, set_value=z
		(*pinfoAngle).x=x
		(*pinfoAngle).y=y
		(*pinfoAngle).z=z
		(*(*pinfoAngle).pInfo).wid.model->reset
		(*(*pinfoAngle).pInfo).wid.model->rotate, [1,0,0], (*pinfoAngle).x
		(*(*pinfoAngle).pInfo).wid.model->rotate, [0,1,0], (*pinfoAngle).y
		(*(*pinfoAngle).pInfo).wid.model->rotate, [0,0,1], (*pinfoAngle).z
		blv_center_view, (*pinfoAngle).pInfo
		blv_draw_system, (*pinfoAngle).pInfo
		END

	'blv_ok_angle_work': BEGIN
		;purpose : apply the new 3 angles on view and close the modal widget
			widget_control, event.top, get_uvalue=pInfoAngle
			(*(*pinfoAngle).pInfo).data.PerspectiveAngle= $
				[(*pinfoAngle).x, (*pinfoAngle).y, (*pinfoAngle).z]
			ptr_free,pinfoAngle
			widget_control, event.top, /destroy
			END
	'blv_cancel_angle_work': BEGIN
		;purpose : close the modal widget
		widget_control, event.top, get_uvalue=pInfoAngle
		(*(*pinfoAngle).pInfo).wid.model->reset
		(*(*pinfoAngle).pInfo).wid.model->rotate, [1,0,0], (*pinfoAngle).x0
		(*(*pinfoAngle).pInfo).wid.model->rotate, [0,1,0], (*pinfoAngle).y0
		(*(*pinfoAngle).pInfo).wid.model->rotate, [0,0,1], (*pinfoAngle).z0
		blv_center_view, (*pinfoAngle).pInfo
		blv_draw_system, (*pinfoAngle).pInfo
		ptr_free,pinfoAngle
		widget_control, event.top, /destroy
		END

	else: Print,'Case not found: '+uvalue

ENDCASE

END

;
;=====================================================================================================
;
;***************main****************
;purpose : define the widget base
pro blv_set_angle, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_set_angle: error caught: '+!error_state.msg)
   RETURN
ENDIF


angle=(*pInfo).data.PerspectiveAngle
base=widget_base(GROUP_LEADER=(*pInfo).wid.tbl,/floating,/col,title="Perspective",/modal)
menu_fin=widget_base(base,/row)
	ok=widget_button(menu_fin,value='Accept', UValue='blv_ok_angle_work')
	cancel=widget_button(menu_fin,value='Cancel', UValue='blv_cancel_angle_work')

wsliderX=widget_slider(base, minimum=0, maximum=360,value=angle[0], $
		title='X:',   uname='x', EVENT_PRO='blv_set_angle_work_event')
wsliderY=widget_slider(base, minimum=0, maximum=360,value=angle[1], $
		title='y:',   uname='y', EVENT_PRO='blv_set_angle_work_event')
wsliderZ=widget_slider(base, minimum=0, maximum=360,value=angle[2], $
		title='Z:',   uname='z', EVENT_PRO='blv_set_angle_work_event')
wreset=widget_button(base,value='Reset To Default', UValue='blv_reset_angle_work')

widget_control, base, /realize


pinfoAngle=ptr_new({pInfo:pInfo, angle:angle,$
		wsliderX:wsliderX, $
		wsliderY:wsliderY, $
		wsliderZ:wsliderZ, $
		x:angle[0], $
		y:angle[1], $
		z:angle[2], $
		x0:angle[0], $
		y0:angle[1], $
		z0:angle[2] $
	})
widget_control, base, set_uvalue=pinfoAngle


xmanager,'blv_set_angle', base

end
